/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder.declarations;

import com.intellij.gwt.uiBinder.declarations.UiXmlVariableDeclaration;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiXmlVariableDeclarationImpl
implements UiXmlVariableDeclaration {
    protected final XmlTag myTag;
    protected final String myFieldName;
    protected final String myType;

    protected UiXmlVariableDeclarationImpl(@NotNull XmlTag tag, @Nullable String defaultFieldName) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/gwt/uiBinder/declarations/UiXmlVariableDeclarationImpl", "<init>"));
        }
        this(tag, UiXmlVariableDeclarationImpl.getFieldName(tag, defaultFieldName), tag.getAttributeValue("type"));
    }

    protected UiXmlVariableDeclarationImpl(@NotNull XmlTag tag, @Nullable String fieldName, @Nullable String type) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/gwt/uiBinder/declarations/UiXmlVariableDeclarationImpl", "<init>"));
        }
        this.myTag = tag;
        this.myFieldName = fieldName;
        this.myType = type;
    }

    private static String getFieldName(@NotNull XmlTag tag, @Nullable String defaultFieldName) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/gwt/uiBinder/declarations/UiXmlVariableDeclarationImpl", "getFieldName"));
        }
        String fieldAttribute = tag.getAttributeValue("field");
        return fieldAttribute != null ? fieldAttribute : defaultFieldName;
    }

    @Override
    @Nullable
    public String getVariableName() {
        return this.myFieldName;
    }

    @Override
    @Nullable
    public String getType() {
        return this.myType;
    }

    @Override
    @Nullable
    public PsiType resolveType() {
        if (this.myType == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)this.myTag.getProject()).getElementFactory().createTypeByFQClassName(this.myType, this.myTag.getResolveScope());
    }

    @Override
    @NotNull
    public XmlTag getTag() {
        XmlTag xmlTag = this.myTag;
        if (xmlTag == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/declarations/UiXmlVariableDeclarationImpl", "getTag"));
        }
        return xmlTag;
    }
}

