/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder;

import com.intellij.gwt.uiBinder.GwtUiXmlUiFieldIntentionBase;
import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateUiFieldIntention
extends GwtUiXmlUiFieldIntentionBase {
    private static final Logger LOG = Logger.getInstance(CreateUiFieldIntention.class);

    @Override
    protected void invokeInternal(Project project, XmlAttributeValue attributeValue, PsiClass psiClass) {
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)attributeValue, XmlTag.class);
            if (tag == null) {
                return;
            }
            String className = UiBinderUtil.getComponentClassName(tag);
            PsiClassType type = elementFactory.createTypeByFQClassName(className, psiClass.getResolveScope());
            PsiField field = elementFactory.createField(attributeValue.getValue(), (PsiType)type);
            PsiModifierList modifierList = field.getModifierList();
            LOG.assertTrue(modifierList != null, field.getClass());
            modifierList.setModifierProperty("private", false);
            modifierList.addAnnotation("com.google.gwt.uibinder.client.UiField");
            PsiField lastField = null;
            PsiField lastUiField = null;
            for (PsiField psiField : psiClass.getFields()) {
                if (UiBinderUtil.isUiField(psiField)) {
                    lastUiField = psiField;
                }
                lastField = psiField;
            }
            if (lastUiField != null) {
                lastField = lastUiField;
            }
            PsiElement added = lastField != null ? psiClass.addAfter((PsiElement)field, lastField) : psiClass.add((PsiElement)field);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(added);
            CodeStyleManager.getInstance((Project)project).reformat(added);
        });
    }

    @Override
    protected PsiClass filterClass(List<PsiClass> classes, String fieldName) {
        for (PsiClass psiClass : classes) {
            if (psiClass.findFieldByName(fieldName, true) != null) continue;
            return psiClass;
        }
        return null;
    }

    @NotNull
    public String getText() {
        if ("Create @UiField for tag" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/CreateUiFieldIntention", "getText"));
        }
        return "Create @UiField for tag";
    }
}

