/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run.remoteUi;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class GwtErrorFilter
implements Filter {
    private static final Pattern FILE_NAME_EXTRACTOR = Pattern.compile("^\\s*\\[ERROR\\] Errors in '(.*)'\\s*$");
    private static final Pattern LINE_NUMBER_EXTRACTOR = Pattern.compile("^\\s*\\[ERROR\\] (Line (\\d+):[.\\s]*.+)\\s*$");
    private final Project myProject;
    private String myCurrentFileUrl;

    public GwtErrorFilter(Project project) {
        this.myProject = project;
    }

    @Nullable
    public Filter.Result applyFilter(String line, int entireLength) {
        if (this.myCurrentFileUrl == null) {
            Matcher matcher = FILE_NAME_EXTRACTOR.matcher(line);
            if (matcher.matches()) {
                this.myCurrentFileUrl = matcher.group(1);
            }
            return null;
        }
        Matcher matcher = LINE_NUMBER_EXTRACTOR.matcher(line);
        if (matcher.find()) {
            VirtualFile virtualFile;
            try {
                virtualFile = VfsUtil.findFileByURL((URL)new URL(this.myCurrentFileUrl));
            }
            catch (MalformedURLException e) {
                this.myCurrentFileUrl = null;
                return null;
            }
            if (virtualFile == null || !virtualFile.isValid()) {
                return null;
            }
            int startIndex = entireLength - line.length() + matcher.start(1);
            int endIndex = entireLength - line.length() + matcher.end(1);
            int lineNumber = Integer.parseInt(matcher.group(2)) - 1;
            OpenFileHyperlinkInfo hyperlinkInfo = new OpenFileHyperlinkInfo(this.myProject, virtualFile, lineNumber, 0);
            return new Filter.Result(startIndex, endIndex, (HyperlinkInfo)hyperlinkInfo);
        }
        this.myCurrentFileUrl = null;
        return this.applyFilter(line, entireLength);
    }
}

