/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.rpc;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public abstract class GwtSearcherBase<Result, Param>
implements QueryExecutor<Result, Param> {
    public boolean execute(final @NotNull Param queryParameters, final @NotNull Processor<Result> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/gwt/rpc/GwtSearcherBase", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/gwt/rpc/GwtSearcherBase", "execute"));
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                GwtFacet gwtFacet;
                PsiFile file = GwtSearcherBase.this.getContainingFile(queryParameters);
                if (file != null && (gwtFacet = GwtFacet.findFacetBySourceFile(file.getProject(), file.getVirtualFile())) != null) {
                    return GwtSearcherBase.this.doExecute(queryParameters, consumer);
                }
                return true;
            }
        });
    }

    protected abstract PsiFile getContainingFile(Param var1);

    protected abstract boolean doExecute(Param var1, Processor<Result> var2);
}

