/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.rpc;

import com.intellij.gwt.rpc.GwtSearcherBase;
import com.intellij.gwt.rpc.RemoteServiceUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.util.Processor;

public class GwtAsyncServiceClassInheritorSearcher {

    public static class Deep
    extends GwtSearcherBase<PsiClass, ClassInheritorsSearch.SearchParameters> {
        @Override
        protected PsiFile getContainingFile(ClassInheritorsSearch.SearchParameters parameters) {
            return parameters.getClassToProcess().getContainingFile();
        }

        @Override
        protected boolean doExecute(ClassInheritorsSearch.SearchParameters queryParameters, Processor<PsiClass> consumer) {
            PsiClass synchronousInterface = RemoteServiceUtil.findSynchronousInterface(queryParameters.getClassToProcess());
            if (synchronousInterface != null) {
                if (!consumer.process((Object)synchronousInterface)) {
                    return false;
                }
                return ClassInheritorsSearch.search((PsiClass)synchronousInterface, (SearchScope)queryParameters.getScope(), (boolean)queryParameters.isCheckDeep(), (boolean)queryParameters.isCheckInheritance(), (boolean)queryParameters.isIncludeAnonymous()).forEach(consumer);
            }
            return true;
        }
    }

    public static class Direct
    extends GwtSearcherBase<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
        @Override
        protected PsiFile getContainingFile(DirectClassInheritorsSearch.SearchParameters parameters) {
            return parameters.getClassToProcess().getContainingFile();
        }

        @Override
        protected boolean doExecute(DirectClassInheritorsSearch.SearchParameters queryParameters, Processor<PsiClass> consumer) {
            PsiClass synchronousInterface = RemoteServiceUtil.findSynchronousInterface(queryParameters.getClassToProcess());
            return synchronousInterface == null || consumer.process((Object)synchronousInterface);
        }
    }
}

