/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.references;

import com.intellij.gwt.references.BaseGwtReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class GwtToHtmlTagReference
extends BaseGwtReference<PsiLiteralExpression> {
    public GwtToHtmlTagReference(PsiLiteralExpression element) {
        super(element);
    }

    public PsiElement resolve() {
        XmlFile[] htmlFiles;
        Object value = ((PsiLiteralExpression)this.myElement).getValue();
        if (!(value instanceof String)) {
            return null;
        }
        String id = (String)value;
        for (XmlFile htmlFile : htmlFiles = this.getHtmlFilesForModule()) {
            PsiElement tag = this.myGwtModulesManager.findTagById(htmlFile, id);
            if (tag == null) continue;
            return tag;
        }
        return null;
    }

    @NotNull
    public String[] getVariants() {
        XmlFile[] files = this.getHtmlFilesForModule();
        LinkedHashSet<String> variants = new LinkedHashSet<String>();
        for (XmlFile file : files) {
            variants.addAll(Arrays.asList(this.myGwtModulesManager.getAllIds(file)));
        }
        String[] stringArray = ArrayUtil.toStringArray(variants);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/references/GwtToHtmlTagReference", "getVariants"));
        }
        return stringArray;
    }
}

