/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.references;

import com.intellij.gwt.references.GwtToCssClassReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GwtToCssClassReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiLiteralExpression literalExpression;
        Object value;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/references/GwtToCssClassReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/gwt/references/GwtToCssClassReferenceProvider", "getReferencesByElement"));
        }
        if (element instanceof PsiLiteralExpression && (value = (literalExpression = (PsiLiteralExpression)element).getValue()) instanceof String) {
            String text = (String)value;
            List<TextRange> ranges = GwtToCssClassReferenceProvider.getWordRanges(text, 1);
            PsiReference[] references = new PsiReference[ranges.size()];
            for (int i = 0; i < ranges.size(); ++i) {
                TextRange rangeInElement = ranges.get(i);
                references[i] = new GwtToCssClassReference<PsiLiteralExpression>(literalExpression, rangeInElement);
            }
            if (references == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/references/GwtToCssClassReferenceProvider", "getReferencesByElement"));
            }
            return references;
        }
        if (element instanceof XmlAttributeValue) {
            XmlAttributeValue attributeValue = (XmlAttributeValue)element;
            String attributeText = attributeValue.getValue();
            List<TextRange> ranges = GwtToCssClassReferenceProvider.getWordRanges(attributeText, 1);
            ArrayList<GwtToCssClassReference<XmlAttributeValue>> references = new ArrayList<GwtToCssClassReference<XmlAttributeValue>>();
            for (TextRange range : ranges) {
                String refText = range.shiftRight(-1).substring(attributeText);
                if (refText.startsWith("{")) continue;
                references.add(new GwtToCssClassReference<XmlAttributeValue>(attributeValue, range));
            }
            PsiReference[] psiReferenceArray = references.toArray(new PsiReference[references.size()]);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/references/GwtToCssClassReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/references/GwtToCssClassReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public static List<TextRange> getWordRanges(String text, int shift) {
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        int start = 0;
        while (true) {
            int end;
            if ((end = text.indexOf(32, start)) == -1) {
                if (start >= text.length()) break;
                ranges.add(new TextRange(shift + start, shift + text.length()));
                break;
            }
            if (start < end) {
                ranges.add(new TextRange(shift + start, shift + end));
            }
            start = end + 1;
        }
        return ranges;
    }
}

