/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.maven;

import com.intellij.gwt.maven.GwtMavenSdk;
import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.gwt.sdk.GwtSdkType;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class GwtMavenSdkType
extends GwtSdkType {
    public GwtMavenSdkType() {
        super("maven");
    }

    @Override
    @NotNull
    public GwtSdk createSdk(String homeDirectoryUrl) {
        String homePath = VfsUtil.urlToPath((String)homeDirectoryUrl);
        GwtMavenSdk gwtMavenSdk = new GwtMavenSdk(homePath, GwtMavenSdkType.getVersion(homePath));
        if (gwtMavenSdk == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/maven/GwtMavenSdkType", "createSdk"));
        }
        return gwtMavenSdk;
    }

    @Override
    public boolean isValidSdkHomeDirectory(File directory) {
        File gwtDev = directory.getParentFile();
        if (gwtDev == null) {
            return false;
        }
        File base = gwtDev.getParentFile();
        if (base == null) {
            return false;
        }
        File parent = base.getParentFile();
        return base.getName().equals("gwt") && parent != null && parent.getName().equals("google") && parent.getParentFile() != null && parent.getParentFile().getName().equals("com");
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    private static String getVersion(String homePath) {
        return PathUtil.getFileName((String)homePath);
    }

    @Override
    public String getPresentableName(String sdkPath) {
        return "GWT " + GwtMavenSdkType.getVersion(sdkPath) + " SDK from Maven Repository";
    }
}

