/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.make;

import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class GwtCompilerPaths {
    private GwtCompilerPaths() {
    }

    public static File getTestGenDirectory(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/make/GwtCompilerPaths", "getTestGenDirectory"));
        }
        return new File(GwtCompilerPaths.getTestOutputRoot(module), "gen");
    }

    public static File getTestOutputDirectory(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/make/GwtCompilerPaths", "getTestOutputDirectory"));
        }
        return new File(GwtCompilerPaths.getTestOutputRoot(module), "www");
    }

    private static File getTestOutputRoot(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/make/GwtCompilerPaths", "getTestOutputRoot"));
        }
        return new File(GwtCompilerPaths.getOutputRoot(module), "test");
    }

    public static File getOutputRoot(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/make/GwtCompilerPaths", "getOutputRoot"));
        }
        return new File(GwtCompilerPaths.getProjectOutputRoot(module.getProject()), GwtCompilerPaths.getOutputDirectoryName(module));
    }

    private static File getProjectOutputRoot(Project project) {
        String cacheDirName = project.getName() + "." + project.getLocationHash();
        return new File(GwtCompilerPaths.getOutputRoot(), cacheDirName);
    }

    public static File getOutputRoot() {
        return new File(PathManager.getSystemPath() + File.separator + "gwt");
    }

    private static String getOutputDirectoryName(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/gwt/make/GwtCompilerPaths", "getOutputDirectoryName"));
        }
        String moduleName = module.getName();
        String modulePath = module.getModuleFilePath();
        return moduleName.replace(' ', '_') + "." + Integer.toHexString(modulePath.hashCode());
    }

    public static File getCompileReportInfo(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/make/GwtCompilerPaths", "getCompileReportInfo"));
        }
        return new File(GwtCompilerPaths.getProjectOutputRoot(project), "compile-reports-v2.xml");
    }

    public static File getGwtSourcePaths(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/make/GwtCompilerPaths", "getGwtSourcePaths"));
        }
        return new File(GwtCompilerPaths.getProjectOutputRoot(project), "gwt-source-paths.xml");
    }

    public static File getGwtDependencies(Project project) {
        return new File(BuildManager.getInstance().getProjectSystemDirectory(project), "gwt-dependencies.xml");
    }
}

