/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.jsinject;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsInjector
implements MultiHostInjector {
    public static final String JSNI_COMMENT_PREFIX = "/*-{";
    public static final String JSNI_COMMENT_SUFFIX = "}-*/";

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/gwt/jsinject/JsInjector", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/gwt/jsinject/JsInjector", "getLanguagesToInject"));
        }
        if (((PsiComment)host).getTokenType() == JavaTokenType.C_STYLE_COMMENT) {
            PsiMethod method;
            PsiComment comment = (PsiComment)host;
            String text = comment.getText();
            if (!JsInjector.isJsniCommentText(text)) {
                return;
            }
            PsiElement parent = host.getParent();
            if (parent != null && parent instanceof PsiMethod && (method = (PsiMethod)parent).getModifierList().hasExplicitModifier("native")) {
                StringBuilder prefix = new StringBuilder();
                JSLanguageDialect language = JavaScriptSupportLoader.GWT_DIALECT;
                NamesValidator namesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)language);
                prefix.append("function ");
                String funName = method.getName();
                if (namesValidator.isKeyword(funName, host.getProject())) {
                    funName = "_" + funName;
                }
                prefix.append(funName);
                prefix.append(" ( ");
                PsiParameter[] parameters = method.getParameterList().getParameters();
                for (int i = 0; i != parameters.length; ++i) {
                    prefix.append(parameters[i].getName());
                    prefix.append(",");
                }
                prefix.append("/*Window*/$wnd,/*Document*/$doc,$entry) ");
                String suffix = "";
                TextRange range = new TextRange(3, text.length() - 3);
                registrar.startInjecting((Language)language).addPlace(prefix.toString(), suffix, (PsiLanguageInjectionHost)host, range).doneInjecting();
            }
        }
    }

    private static boolean isJsniCommentText(String text) {
        return text.startsWith(JSNI_COMMENT_PREFIX) && text.endsWith(JSNI_COMMENT_SUFFIX);
    }

    public static boolean isJsniMethod(@NotNull PsiMethod psiMethod) {
        PsiElement[] elements;
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/gwt/jsinject/JsInjector", "isJsniMethod"));
        }
        if (!psiMethod.getModifierList().hasExplicitModifier("native")) {
            return false;
        }
        for (PsiElement element : elements = psiMethod.getChildren()) {
            if (!(element instanceof PsiComment) || ((PsiComment)element).getTokenType() != JavaTokenType.C_STYLE_COMMENT || !JsInjector.isJsniCommentText(element.getText())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<PsiComment>> list = Collections.singletonList(PsiComment.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/JsInjector", "elementsToInjectIn"));
        }
        return list;
    }
}

