/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.jsinject;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.jsinject.GwtClassMemberReference;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGwtReferenceExpressionImpl
extends JSReferenceExpressionImpl {
    public JSGwtReferenceExpressionImpl(ASTNode node) {
        super(node);
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiElement at = this.findChildByType(JSTokenTypes.AT);
        if (at == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/JSGwtReferenceExpressionImpl", "getReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement classNameStart = at.getNextSibling();
        if (classNameStart == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/JSGwtReferenceExpressionImpl", "getReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement colon2 = this.findChildByType(JSTokenTypes.COLON_COLON);
        PsiElement classNameFinish = colon2 == null ? this.getLastChild() : colon2.getPrevSibling();
        if (classNameFinish == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/JSGwtReferenceExpressionImpl", "getReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        TextRange classNameRange = new TextRange(classNameStart.getStartOffsetInParent(), classNameFinish.getStartOffsetInParent() + classNameFinish.getTextLength());
        GwtFacet facet = GwtFacet.findFacetByPsiElement((PsiElement)this);
        boolean shortReferencesSupported = facet == null || facet.getSdkVersion().isShortClassReferencesInJavaScriptSupported();
        GwtJsniJavaClassReferenceProvider referenceProvider = new GwtJsniJavaClassReferenceProvider(shortReferencesSupported);
        Object[] classReferences = referenceProvider.getReferencesByString(classNameRange.substring(this.getText()), (PsiElement)this, classNameRange.getStartOffset());
        PsiElement member = this.findChildByType(JSTokenTypes.GWT_FIELD_OR_METHOD);
        if (member == null) {
            if (classReferences == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/JSGwtReferenceExpressionImpl", "getReferences"));
            }
            return classReferences;
        }
        TextRange range = TextRange.from((int)member.getStartOffsetInParent(), (int)member.getTextLength());
        PsiReference classReference = classReferences.length > 0 ? classReferences[classReferences.length - 1] : null;
        GwtClassMemberReference classMemberReference = new GwtClassMemberReference(this, classReference, range);
        PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.append((Object[])classReferences, (Object)((Object)classMemberReference), PsiReference.class);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/JSGwtReferenceExpressionImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    public boolean shouldCheckReferences() {
        return false;
    }

    private class GwtJsniJavaClassReferenceProvider
    extends JavaClassReferenceProvider {
        private final boolean myShortReferencesSupported;

        public GwtJsniJavaClassReferenceProvider(boolean shortReferencesSupported) {
            this.myShortReferencesSupported = shortReferencesSupported;
            if (shortReferencesSupported) {
                this.setOption(JavaClassReferenceProvider.ADVANCED_RESOLVE, true);
            }
        }

        public GlobalSearchScope getScope(Project project) {
            return JSGwtReferenceExpressionImpl.this.getResolveScope();
        }

        @NotNull
        public PsiFile getContextFile(@NotNull PsiElement element) {
            PsiLanguageInjectionHost host;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/jsinject/JSGwtReferenceExpressionImpl$GwtJsniJavaClassReferenceProvider", "getContextFile"));
            }
            if (this.myShortReferencesSupported && (host = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost(element)) != null) {
                PsiFile psiFile = host.getContainingFile();
                if (psiFile == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/JSGwtReferenceExpressionImpl$GwtJsniJavaClassReferenceProvider", "getContextFile"));
                }
                return psiFile;
            }
            PsiFile psiFile = super.getContextFile(element);
            if (psiFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/JSGwtReferenceExpressionImpl$GwtJsniJavaClassReferenceProvider", "getContextFile"));
            }
            return psiFile;
        }

        @Nullable
        public PsiClass getContextClass(@NotNull PsiElement element) {
            PsiLanguageInjectionHost host;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/jsinject/JSGwtReferenceExpressionImpl$GwtJsniJavaClassReferenceProvider", "getContextClass"));
            }
            if (this.myShortReferencesSupported && (host = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost(element)) != null) {
                return (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)host, PsiClass.class);
            }
            return null;
        }
    }
}

