/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.jsinject;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.api.impls.MethodParameterInfoHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.gwt.jsinject.GwtClassMemberReference;
import com.intellij.gwt.jsinject.JSGwtReferenceExpressionImpl;
import com.intellij.javascript.JSParameterInfoHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtJSParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<JSArgumentList, PsiMember, JSExpression> {
    private static final Set<? extends Class> ourStopSearch = Collections.singleton(PsiMember.class);

    @NotNull
    public Set<? extends Class> getArgListStopSearchClasses() {
        Set<? extends Class> set = ourStopSearch;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/GwtJSParameterInfoHandler", "getArgListStopSearchClasses"));
        }
        return set;
    }

    public boolean couldShowInLookup() {
        return false;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        return null;
    }

    public Object[] getParametersForDocumentation(PsiMember p, ParameterInfoContext context) {
        if (p instanceof PsiMethod) {
            return ((PsiMethod)p).getParameterList().getParameters();
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public JSArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        PsiElement element;
        JSExpression expression;
        GwtClassMemberReference gwtReference;
        PsiElement parent;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/gwt/jsinject/GwtJSParameterInfoHandler", "findElementForParameterInfo"));
        }
        JSArgumentList argumentList = JSParameterInfoHandler.findArgumentList((PsiFile)context.getFile(), (int)context.getOffset());
        if (argumentList != null && (parent = argumentList.getParent()) instanceof JSCallExpression && (gwtReference = GwtJSParameterInfoHandler.getGwtClassMemberReference(expression = ((JSCallExpression)parent).getMethodExpression())) != null && (element = gwtReference.resolve()) != null) {
            context.setItemsToShow(new Object[]{element});
            return argumentList;
        }
        return null;
    }

    @Nullable
    private static GwtClassMemberReference getGwtClassMemberReference(@Nullable JSExpression expression) {
        PsiReference[] references;
        PsiReference last;
        if (expression == null) {
            return null;
        }
        if (!(expression instanceof JSGwtReferenceExpressionImpl)) {
            PsiElement child = expression.getLastChild();
            if (child instanceof JSGwtReferenceExpressionImpl) {
                expression = (JSGwtReferenceExpressionImpl)child;
            } else {
                return null;
            }
        }
        return (last = (references = expression.getReferences())[references.length - 1]) instanceof GwtClassMemberReference ? (GwtClassMemberReference)last : null;
    }

    public void showParameterInfo(@NotNull JSArgumentList element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/jsinject/GwtJSParameterInfoHandler", "showParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/gwt/jsinject/GwtJSParameterInfoHandler", "showParameterInfo"));
        }
        context.showHint((PsiElement)element, element.getTextOffset(), (ParameterInfoHandler)this);
    }

    public JSArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/gwt/jsinject/GwtJSParameterInfoHandler", "findElementForUpdatingParameterInfo"));
        }
        return JSParameterInfoHandler.findArgumentList((PsiFile)context.getFile(), (int)context.getOffset());
    }

    public void updateParameterInfo(@NotNull JSArgumentList parameterOwner, @NotNull UpdateParameterInfoContext context) {
        if (parameterOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterOwner", "com/intellij/gwt/jsinject/GwtJSParameterInfoHandler", "updateParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/gwt/jsinject/GwtJSParameterInfoHandler", "updateParameterInfo"));
        }
        context.setCurrentParameter(ParameterInfoUtils.getCurrentParameterIndex((ASTNode)parameterOwner.getNode(), (int)context.getOffset(), (IElementType)JSTokenTypes.COMMA));
    }

    public String getParameterCloseChars() {
        return ",){}";
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    public void updateUI(PsiMember p, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/gwt/jsinject/GwtJSParameterInfoHandler", "updateUI"));
        }
        if (p instanceof PsiMethod) {
            MethodParameterInfoHandler.updateMethodPresentation((PsiMethod)((PsiMethod)p), (PsiSubstitutor)PsiSubstitutor.EMPTY, (ParameterInfoUIContext)context);
        } else {
            context.setupUIComponentPresentation(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]), -1, -1, false, false, false, context.getDefaultParameterColor());
        }
    }

    @NotNull
    public JSExpression[] getActualParameters(@NotNull JSArgumentList o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/gwt/jsinject/GwtJSParameterInfoHandler", "getActualParameters"));
        }
        JSExpression[] jSExpressionArray = o.getArguments();
        if (jSExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/GwtJSParameterInfoHandler", "getActualParameters"));
        }
        return jSExpressionArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = JSTokenTypes.COMMA;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/GwtJSParameterInfoHandler", "getActualParameterDelimiterType"));
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = JSTokenTypes.RBRACE;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/GwtJSParameterInfoHandler", "getActualParametersRBraceType"));
        }
        return iElementType;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        Set<Class> set = Collections.singleton(JSCallExpression.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/GwtJSParameterInfoHandler", "getArgumentListAllowedParentClasses"));
        }
        return set;
    }

    @NotNull
    public Class<JSArgumentList> getArgumentListClass() {
        if (JSArgumentList.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/jsinject/GwtJSParameterInfoHandler", "getArgumentListClass"));
        }
        return JSArgumentList.class;
    }
}

