/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections.eventListeners;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.eventListeners.DeprecatedListenerUsages;
import com.intellij.gwt.inspections.eventListeners.EventListenersUsagesCollector;
import com.intellij.gwt.inspections.eventListeners.ListenerUsageInfo;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GwtDeprecatedEventListenersInspection
extends BaseGwtInspection {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/inspections/eventListeners/GwtDeprecatedEventListenersInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/eventListeners/GwtDeprecatedEventListenersInspection", "checkFile"));
        }
        if (file.getFileType() != StdFileTypes.JAVA) {
            return null;
        }
        GwtFacet gwtFacet = GwtDeprecatedEventListenersInspection.getFacet((PsiElement)file);
        if (gwtFacet == null || !gwtFacet.getSdkVersion().isEventHandlersSupported()) {
            return null;
        }
        EventListenersUsagesCollector collector = new EventListenersUsagesCollector();
        file.accept((PsiElementVisitor)collector);
        DeprecatedListenerUsages usages = collector.getListenerUsages();
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        for (ListenerUsageInfo usageInfo : usages.getUsages()) {
            if (!usageInfo.canBeFixed(usages)) continue;
            problems.add(usageInfo.createProblemDescriptor(manager, isOnTheFly));
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/eventListeners/GwtDeprecatedEventListenersInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Deprecated event listeners" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/eventListeners/GwtDeprecatedEventListenersInspection", "getDisplayName"));
        }
        return "Deprecated event listeners";
    }

    @NotNull
    public String getShortName() {
        if ("GwtDeprecatedEventListeners" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/eventListeners/GwtDeprecatedEventListenersInspection", "getShortName"));
        }
        return "GwtDeprecatedEventListeners";
    }
}

