/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections.eventListeners;

import com.intellij.gwt.inspections.eventListeners.EventHandlerInfo;
import com.intellij.psi.PsiType;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

class DeprecatedListener {
    @NonNls
    private static final String DOM_PACKAGE = "com.google.gwt.event.dom.client.";
    @NonNls
    private static final String UI_PACKAGE = "com.google.gwt.user.client.ui.";
    private String myListenerClass;
    private final String myAdapterClass;
    private String myAddListenerMethod;
    private String myRemoveListenerMethod;
    private String myListenersHolderClass;
    private Map<String, EventHandlerInfo> myHandlers = new THashMap();

    DeprecatedListener(@NonNls String eventName) {
        this(eventName, null);
    }

    DeprecatedListener(@NonNls String eventName, @NonNls String adapterClass) {
        this.myListenerClass = UI_PACKAGE + eventName + "Listener";
        this.myAdapterClass = adapterClass;
        this.listenersHolder("com.google.gwt.user.client.ui.Sources" + eventName + "Events", "add" + eventName + "Listener", "remove" + eventName + "Listener");
    }

    public DeprecatedListener handler(@NonNls String handlerName) {
        return this.handler("on" + handlerName, DOM_PACKAGE + handlerName + "Handler", "add" + handlerName + "Handler");
    }

    public DeprecatedListener handler(@NonNls String methodName, @NonNls String handlerClass, @NonNls String addHandlerMethod) {
        return this.handler(methodName, methodName, handlerClass, addHandlerMethod);
    }

    public DeprecatedListener handler(@NonNls String listenerMethodName, @NonNls String handlerMethodName, @NonNls String handlerClass, @NonNls String addHandlerMethod) {
        this.myHandlers.put(listenerMethodName, new EventHandlerInfo(handlerMethodName, handlerClass, addHandlerMethod));
        return this;
    }

    public DeprecatedListener listenersHolder(String listenersHolderClass, String addMethodName, String removeMethodName) {
        this.myListenersHolderClass = listenersHolderClass;
        this.myAddListenerMethod = addMethodName;
        this.myRemoveListenerMethod = removeMethodName;
        return this;
    }

    public String getListenerClass() {
        return this.myListenerClass;
    }

    public String getAdapterClass() {
        return this.myAdapterClass;
    }

    @Nullable
    public String getHandlerClassIfSingle() {
        return this.myHandlers.size() == 1 ? this.myHandlers.values().iterator().next().getHandlerClass() : null;
    }

    public String getAddListenerMethod() {
        return this.myAddListenerMethod;
    }

    public String getRemoveListenerMethod() {
        return this.myRemoveListenerMethod;
    }

    public String getListenersHolderClass() {
        return this.myListenersHolderClass;
    }

    public Collection<String> getMethodNames() {
        return this.myHandlers.keySet();
    }

    public EventHandlerInfo getHandler(String methodName) {
        return this.myHandlers.get(methodName);
    }

    public boolean isListenerOrAdapterType(PsiType type) {
        return type.equalsToText(this.myListenerClass) || this.myAdapterClass != null && type.equalsToText(this.myAdapterClass);
    }
}

