/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.inspections.AbstractClientCodeReferencesInspection;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NonJREEmulationClassesInClientCodeInspection
extends AbstractClientCodeReferencesInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.NonJREEmulationClassesInClientCodeInspection");

    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.classes.not.from.jre.emulation.library.in.client.code", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/NonJREEmulationClassesInClientCodeInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("NonJREEmulationClassesInClientCode" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/NonJREEmulationClassesInClientCodeInspection", "getShortName"));
        }
        return "NonJREEmulationClassesInClientCode";
    }

    @Override
    protected void checkClassReference(@NotNull PsiJavaCodeReferenceElement reference, @NotNull PsiClass referencedClass, @NotNull String className, @NotNull VirtualFile virtualFile, @NotNull GwtFacet gwtFacet, List<GwtModule> gwtModules, @NotNull GwtModulesManager gwtModulesManager, @NotNull InspectionManager manager, boolean isOnTheFly, List<ProblemDescriptor> problems) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/gwt/inspections/NonJREEmulationClassesInClientCodeInspection", "checkClassReference"));
        }
        if (referencedClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedClass", "com/intellij/gwt/inspections/NonJREEmulationClassesInClientCodeInspection", "checkClassReference"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/gwt/inspections/NonJREEmulationClassesInClientCodeInspection", "checkClassReference"));
        }
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/gwt/inspections/NonJREEmulationClassesInClientCodeInspection", "checkClassReference"));
        }
        if (gwtFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtFacet", "com/intellij/gwt/inspections/NonJREEmulationClassesInClientCodeInspection", "checkClassReference"));
        }
        if (gwtModulesManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtModulesManager", "com/intellij/gwt/inspections/NonJREEmulationClassesInClientCodeInspection", "checkClassReference"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/NonJREEmulationClassesInClientCodeInspection", "checkClassReference"));
        }
        if (!NonJREEmulationClassesInClientCodeInspection.isInJdk(virtualFile, gwtFacet)) {
            return;
        }
        PsiClass topLevelClass = PsiUtil.getTopLevelClass((PsiElement)referencedClass);
        if (topLevelClass == null) {
            topLevelClass = referencedClass;
        }
        if (!((GwtFacetConfiguration)gwtFacet.getConfiguration()).getSdk().containsJreEmulationClass(gwtModules, topLevelClass.getQualifiedName())) {
            String message = GwtBundle.message("problem.description.class.0.is.not.presented.in.jre.emulation.library", className, gwtModules.get(0).getQualifiedName());
            problems.add(manager.createProblemDescriptor((PsiElement)reference, message, (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
        }
    }

    @Override
    protected void checkMethodReference(PsiJavaCodeReferenceElement reference, PsiMethod method, GwtFacet facet, List<GwtModule> gwtModules, GwtModulesManager gwtModulesManager, InspectionManager manager, boolean isOnTheFly, List<ProblemDescriptor> problems) {
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiFile psiFile = psiClass.getContainingFile();
        if (psiFile == null) {
            return;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null || !NonJREEmulationClassesInClientCodeInspection.isInJdk(virtualFile, facet)) {
            return;
        }
        PsiClass emulationClass = ((GwtFacetConfiguration)facet.getConfiguration()).getSdk().findJreEmulationClass(gwtModules, psiClass);
        if (emulationClass == null) {
            return;
        }
        if (!NonJREEmulationClassesInClientCodeInspection.containsMethodWithSignature(emulationClass, method)) {
            String message = GwtBundle.message("problem.description.method.0.is.not.presented.in.jre.emulation.library", PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)2), gwtModules.get(0).getQualifiedName());
            problems.add(manager.createProblemDescriptor((PsiElement)reference, message, isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
    }

    private static boolean containsMethodWithSignature(PsiClass emulationClass, PsiMethod method) {
        if (method.isConstructor() && method.getParameterList().getParametersCount() == 0 && emulationClass.getConstructors().length == 0) {
            return true;
        }
        MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (boolean)true);
        for (PsiMethod psiMethod : emulationClass.findMethodsByName(method.getName(), true)) {
            if (!signature.equals((Object)MethodSignatureBackedByPsiMethod.create((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (boolean)true))) continue;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Method with signature " + signature + " not found in " + emulationClass.getQualifiedName());
            PsiFile file = emulationClass.getContainingFile();
            LOG.debug("File: " + (file != null ? file.getVirtualFile() : "null"));
            LOG.debug("Methods:");
            for (PsiMethod psiMethod : emulationClass.getMethods()) {
                LOG.debug(MethodSignatureBackedByPsiMethod.create((PsiMethod)psiMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (boolean)true).toString());
            }
        }
        return false;
    }

    private static boolean isInJdk(VirtualFile virtualFile, GwtFacet facet) {
        ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)facet.getModule()).getFileIndex();
        for (OrderEntry entry : fileIndex.getOrderEntriesForFile(virtualFile)) {
            if (!(entry instanceof JdkOrderEntry)) continue;
            return true;
        }
        return false;
    }
}

