/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GwtOverlayTypeRestrictionsInspection
extends BaseGwtInspection {
    private static final String JAVASCRIPT_OBJECT_CLASS_NAME = "com.google.gwt.core.client.JavaScriptObject";

    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/inspections/GwtOverlayTypeRestrictionsInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/GwtOverlayTypeRestrictionsInspection", "checkClass"));
        }
        if (!GwtOverlayTypeRestrictionsInspection.shouldCheck((PsiElement)aClass) || aClass instanceof PsiTypeParameter) {
            return null;
        }
        if (!InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)true, (String)JAVASCRIPT_OBJECT_CLASS_NAME)) {
            return null;
        }
        SmartList problems = new SmartList();
        GwtOverlayTypeRestrictionsInspection.checkConstructors(aClass, manager, isOnTheFly, (List<ProblemDescriptor>)problems);
        GwtOverlayTypeRestrictionsInspection.checkFields(aClass, manager, isOnTheFly, (List<ProblemDescriptor>)problems);
        GwtOverlayTypeRestrictionsInspection.checkInnerClasses(aClass, manager, isOnTheFly, (List<ProblemDescriptor>)problems);
        GwtOverlayTypeRestrictionsInspection.checkMethods(aClass, manager, isOnTheFly, (List<ProblemDescriptor>)problems);
        return !problems.isEmpty() ? problems.toArray(new ProblemDescriptor[problems.size()]) : null;
    }

    private static void checkMethods(PsiClass aClass, InspectionManager manager, boolean isOnTheFly, List<ProblemDescriptor> problems) {
        if (!aClass.hasModifierProperty("final")) {
            for (PsiMethod method : aClass.getMethods()) {
                if (method.isConstructor() || method.hasModifierProperty("static") || method.hasModifierProperty("final") || method.hasModifierProperty("private")) continue;
                String message = GwtBundle.message("problem.description.instance.methods.in.overlay.type.must.be.final", new Object[0]);
                LocalQuickFixAndIntentionActionOnPsiElement fix = QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)method, "final", true, false);
                problems.add(manager.createProblemDescriptor(GwtOverlayTypeRestrictionsInspection.getElementToHighlight(method), message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
            }
        }
    }

    private static void checkInnerClasses(PsiClass aClass, InspectionManager manager, boolean isOnTheFly, List<ProblemDescriptor> problems) {
        for (PsiClass innerClass : aClass.getInnerClasses()) {
            if (innerClass.hasModifierProperty("static")) continue;
            String message = GwtBundle.message("problem.description.inner.classes.in.overlay.type.must.be.static", new Object[0]);
            LocalQuickFixAndIntentionActionOnPsiElement fix = QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)innerClass, "static", true, false);
            problems.add(manager.createProblemDescriptor(GwtOverlayTypeRestrictionsInspection.getElementToHighlight(innerClass), message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
        }
    }

    private static void checkFields(PsiClass aClass, InspectionManager manager, boolean isOnTheFly, List<ProblemDescriptor> problems) {
        for (PsiField field : aClass.getFields()) {
            if (field.hasModifierProperty("static")) continue;
            String message = GwtBundle.message("problem.description.overlay.type.cannot.have.instance.fields", new Object[0]);
            LocalQuickFixAndIntentionActionOnPsiElement fix = QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)field, "static", true, false);
            problems.add(manager.createProblemDescriptor((PsiElement)field.getNameIdentifier(), message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
        }
    }

    private static void checkConstructors(PsiClass aClass, InspectionManager manager, boolean isOnTheFly, List<ProblemDescriptor> problems) {
        for (PsiMethod constructor : aClass.getConstructors()) {
            LocalQuickFixAndIntentionActionOnPsiElement fix;
            String message;
            PsiCodeBlock body = constructor.getBody();
            if (constructor.getParameterList().getParametersCount() > 0) {
                message = GwtBundle.message("problem.description.constructor.in.overlay.type.cannot.have.parameters", new Object[0]);
                fix = null;
                problems.add(manager.createProblemDescriptor(GwtOverlayTypeRestrictionsInspection.getElementToHighlight(constructor), message, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
                continue;
            }
            if (!constructor.hasModifierProperty("protected")) {
                message = GwtBundle.message("problem.description.constructor.in.overlay.type.must.be.protected", new Object[0]);
                fix = QuickFixFactory.getInstance().createModifierListFix((PsiModifierListOwner)constructor, "protected", true, false);
                problems.add(manager.createProblemDescriptor(GwtOverlayTypeRestrictionsInspection.getElementToHighlight(constructor), message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
                continue;
            }
            if (body == null || body.getStatements().length <= 0) continue;
            message = GwtBundle.message("problem.description.constructor.in.overlay.type.must.have.empty.body", new Object[0]);
            fix = null;
            problems.add(manager.createProblemDescriptor(GwtOverlayTypeRestrictionsInspection.getElementToHighlight(constructor), message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
        }
        if (aClass.getConstructors().length == 0) {
            LocalQuickFixAndIntentionActionOnPsiElement fix = QuickFixFactory.getInstance().createAddConstructorFix(aClass, "protected");
            String message = GwtBundle.message("problem.description.overlay.type.must.have.protected.empty.no.arg.constructor", new Object[0]);
            problems.add(manager.createProblemDescriptor(GwtOverlayTypeRestrictionsInspection.getElementToHighlight(aClass), message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.overlay.type.restrictions.violated", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtOverlayTypeRestrictionsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("GwtOverlayTypeRestrictionsViolated" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtOverlayTypeRestrictionsInspection", "getShortName"));
        }
        return "GwtOverlayTypeRestrictionsViolated";
    }
}

