/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.i18n;

import com.intellij.gwt.i18n.GwtI18nManager;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PropertiesFileToInterfaceItemProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/gwt/i18n/PropertiesFileToInterfaceItemProvider", "getItems"));
        }
        PsiFile file = context.getContainingFile();
        if (file instanceof PropertiesFile) {
            PsiMethod method;
            GwtI18nManager manager = GwtI18nManager.getInstance(context.getProject());
            IProperty property = (IProperty)PsiTreeUtil.getParentOfType((PsiElement)context, Property.class, (boolean)false);
            if (property != null && (method = manager.getMethod(property)) != null) {
                List<GotoRelatedItem> list = Collections.singletonList(new GotoRelatedItem((PsiElement)method));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/i18n/PropertiesFileToInterfaceItemProvider", "getItems"));
                }
                return list;
            }
            PsiClass anInterface = manager.getPropertiesInterface((PropertiesFile)file);
            if (anInterface != null) {
                List<GotoRelatedItem> list = Collections.singletonList(new GotoRelatedItem((PsiElement)anInterface));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/i18n/PropertiesFileToInterfaceItemProvider", "getItems"));
                }
                return list;
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/i18n/PropertiesFileToInterfaceItemProvider", "getItems"));
        }
        return list;
    }
}

