/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.conversion;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionContext;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ModuleSettings;
import com.intellij.ide.impl.convert.JDomConvertingUtil;
import com.intellij.javaee.converting.artifacts.AbstractPackagingConverter;
import com.intellij.javaee.converting.artifacts.PackagingConversionUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.jps.model.serialization.artifact.ArtifactState;

public class GwtPackagingConverter
extends AbstractPackagingConverter {
    @NonNls
    private static final String COMPILER_OUTPUT_PATH_ATTRIBUTE = "compilerOutputPath";
    @NonNls
    private static final String RUN_GWT_COMPILER_ON_MAKE_ATTRIBUTE = "runGwtCompilerOnMake";
    private final List<ArtifactState> myArtifactStates = new ArrayList<ArtifactState>();

    public GwtPackagingConverter(ConversionContext context) {
        super(context);
    }

    public ConversionProcessor<ModuleSettings> createModuleFileConverter() {
        return new GwtFacetConversionProcessor();
    }

    public void processingFinished() throws CannotConvertException {
        this.saveArtifacts(this.myArtifactStates);
    }

    private class GwtFacetConversionProcessor
    extends ConversionProcessor<ModuleSettings> {
        private GwtFacetConversionProcessor() {
        }

        public boolean isConversionNeeded(ModuleSettings moduleSettings) {
            Element facetElement = moduleSettings.getFacetElement("gwt");
            if (facetElement != null) {
                Element configuration = facetElement.getChild("configuration");
                Element outputElement = JDomConvertingUtil.getSettingsElement((Element)configuration, (String)GwtPackagingConverter.COMPILER_OUTPUT_PATH_ATTRIBUTE);
                return !StringUtil.isEmpty((String)JDomConvertingUtil.getSettingsValue((Element)outputElement));
            }
            return false;
        }

        public void process(ModuleSettings moduleSettings) throws CannotConvertException {
            Element runOnMakeElement;
            Element facetElement = moduleSettings.getFacetElement("gwt");
            if (facetElement == null) {
                return;
            }
            Element configuration = facetElement.getChild("configuration");
            if (configuration == null) {
                return;
            }
            Element outputElement = JDomConvertingUtil.getSettingsElement((Element)configuration, (String)GwtPackagingConverter.COMPILER_OUTPUT_PATH_ATTRIBUTE);
            String outputPath = JDomConvertingUtil.getSettingsValue((Element)outputElement);
            if (!StringUtil.isEmpty((String)outputPath)) {
                ArtifactState state = new ArtifactState();
                state.setName(moduleSettings.getModuleName() + ":gwt");
                state.setArtifactType("plain");
                state.setOutputPath(GwtPackagingConverter.this.expandModuleMacros(outputPath, moduleSettings));
                Element root = PackagingConversionUtil.createArtifactRoot();
                Element gwtElement = PackagingConversionUtil.createPackagingElement((String)"gwt-compiler-output");
                gwtElement.setAttribute("facet", PackagingConversionUtil.getFacetPointer((ModuleSettings)moduleSettings, (Element)facetElement));
                root.addContent(gwtElement);
                state.setRootElement(root);
                GwtPackagingConverter.this.myArtifactStates.add(state);
            }
            if (outputElement != null) {
                configuration.removeContent((Content)outputElement);
            }
            if ((runOnMakeElement = JDomConvertingUtil.getSettingsElement((Element)configuration, (String)GwtPackagingConverter.RUN_GWT_COMPILER_ON_MAKE_ATTRIBUTE)) != null) {
                configuration.removeContent((Content)runOnMakeElement);
            }
        }
    }
}

