/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.codeInsight;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GwtMethodGenerationUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.codeInsight.GwtMethodGenerationUtil");

    private GwtMethodGenerationUtil() {
    }

    public static String addPrefixIfNeeded(String id, @NonNls String prefix, PsiNameHelper nameHelper, LanguageLevel languageLevel) {
        if (!nameHelper.isIdentifier(id, languageLevel) && !nameHelper.isIdentifier(id = prefix + StringUtil.capitalize((String)id), languageLevel)) {
            id = prefix;
        }
        return id;
    }

    public static String convertStringToMethodName(String string, PsiNameHelper nameHelper, LanguageLevel languageLevel, String prefix) {
        if (nameHelper.isIdentifier(string, languageLevel)) {
            return string;
        }
        String[] words = string.split("[\\.-]");
        StringBuilder builder = new StringBuilder();
        for (String word : words) {
            String id = GwtMethodGenerationUtil.convert2Id(word);
            if (id.length() <= 0) continue;
            if (builder.length() > 0) {
                id = StringUtil.capitalize((String)id);
            }
            builder.append(id);
        }
        return GwtMethodGenerationUtil.addPrefixIfNeeded(builder.toString(), prefix, nameHelper, languageLevel);
    }

    private static String convert2Id(String word) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if ((builder.length() != 0 || !Character.isJavaIdentifierStart(c)) && (builder.length() <= 0 || !Character.isJavaIdentifierPart(c))) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public static PsiMethod addStringMethod(@NotNull PsiClass aClass, @NotNull String methodName) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/codeInsight/GwtMethodGenerationUtil", "addStringMethod"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/gwt/codeInsight/GwtMethodGenerationUtil", "addStringMethod"));
        }
        PsiManager psiManager = aClass.getManager();
        PsiClassType javaLangString = PsiType.getJavaLangString((PsiManager)psiManager, (GlobalSearchScope)aClass.getResolveScope());
        PsiMethod method = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createMethod(methodName, (PsiType)javaLangString);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"public", (boolean)false);
        PsiCodeBlock body = method.getBody();
        LOG.assertTrue(body != null);
        body.delete();
        return (PsiMethod)aClass.add((PsiElement)method);
    }
}

