/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.clientBundle.jam;

import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourceFileJamConverter
extends JamConverter<PsiFile> {
    private final Condition<PsiFileSystemItem> myCompletionFilter;

    public SourceFileJamConverter(Condition<PsiFileSystemItem> completionFilter) {
        this.myCompletionFilter = completionFilter;
    }

    public PsiFile fromString(@Nullable String s, JamStringAttributeElement<PsiFile> context) {
        PsiFileSystemItem resolved;
        FileReference lastReference;
        PsiLiteral literal = context.getPsiLiteral();
        if (literal == null) {
            return SourceFileJamConverter.findFile(context);
        }
        FileReferenceSet set = this.getReferenceSet(context);
        if (set != null && (lastReference = set.getLastReference()) != null && (resolved = lastReference.resolve()) instanceof PsiFile) {
            return (PsiFile)resolved;
        }
        return null;
    }

    @Nullable
    private static PsiFile findFile(JamStringAttributeElement<PsiFile> context) {
        String path = context.getStringValue();
        PsiAnnotationMemberValue psiElement = context.getPsiElement();
        if (path == null || psiElement == null) {
            return null;
        }
        PsiFile file = psiElement.getContainingFile();
        if (file == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile target = virtualFile.getParent().findFileByRelativePath(path);
        if (target == null) {
            return null;
        }
        return context.getPsiManager().findFile(target);
    }

    @NotNull
    public PsiReference[] createReferences(JamStringAttributeElement<PsiFile> context) {
        FileReferenceSet set = this.getReferenceSet(context);
        Object[] objectArray = set != null ? set.getAllReferences() : PsiReference.EMPTY_ARRAY;
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/clientBundle/jam/SourceFileJamConverter", "createReferences"));
        }
        return objectArray;
    }

    @Nullable
    private FileReferenceSet getReferenceSet(JamStringAttributeElement<PsiFile> context) {
        String text = context.getStringValue();
        if (text == null) {
            return null;
        }
        PsiLiteral literal = context.getPsiLiteral();
        if (literal == null) {
            return null;
        }
        return new FileReferenceSet(text, (PsiElement)literal, 1, null, SystemInfo.isFileSystemCaseSensitive, true){

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return SourceFileJamConverter.this.myCompletionFilter;
            }
        };
    }
}

