/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.actions;

import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.actions.CreateGwtModuleDialog;
import com.intellij.gwt.actions.GwtCreateActionBase;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.util.PackageUtil;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.css.CssFileType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateGwtModuleAction
extends GwtCreateActionBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.actions.CreateGwtModuleAction");
    private final Ref<String> myHtmlDirectory = Ref.create(null);

    public CreateGwtModuleAction() {
        super(GwtBundle.message("new.module.menu.action.text", new Object[0]), GwtBundle.message("new.module.menu.action.description", new Object[0]));
    }

    @Override
    protected boolean requireGwtModule() {
        return false;
    }

    @Override
    protected String getDialogPrompt() {
        return GwtBundle.message("new.module.dlg.prompt", new Object[0]);
    }

    @Override
    protected String getDialogTitle() {
        return GwtBundle.message("new.module.dlg.title", new Object[0]);
    }

    @Override
    protected void doCheckBeforeCreate(String name, PsiDirectory directory) throws IncorrectOperationException {
        String[] names;
        for (String id : names = name.split("\\.")) {
            PsiUtil.checkIsIdentifier((PsiManager)directory.getManager(), (String)id);
        }
    }

    @Override
    protected void showDialog(@NotNull GwtFacet facet, @NotNull PsiDirectory directory, @NotNull CreateElementActionBase.MyInputValidator validator) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/gwt/actions/CreateGwtModuleAction", "showDialog"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/gwt/actions/CreateGwtModuleAction", "showDialog"));
        }
        if (validator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validator", "com/intellij/gwt/actions/CreateGwtModuleAction", "showDialog"));
        }
        if (!facet.getSdkVersion().isHtmlFilesOutsideSourcesAreAllowed()) {
            super.showDialog(facet, directory, validator);
            return;
        }
        CreateGwtModuleDialog dialog = new CreateGwtModuleDialog(this.getDialogTitle(), facet, (InputValidator)validator, directory, this.myHtmlDirectory);
        dialog.show();
    }

    @Override
    @NotNull
    protected PsiElement[] doCreate(String name, PsiDirectory directory, GwtModule gwtModule) throws Exception {
        JavaDirectoryService javaDirectoryService = JavaDirectoryService.getInstance();
        PsiPackage psiPackage = javaDirectoryService.getPackage(directory);
        if (psiPackage == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/actions/CreateGwtModuleAction", "doCreate"));
            }
            return PsiElement.EMPTY_ARRAY;
        }
        int dot = name.indexOf(46);
        if (dot != -1) {
            directory = CreateGwtModuleAction.getRootDirectory(directory);
            while (dot != -1) {
                String directoryName = name.substring(0, dot);
                directory = PackageUtil.findOrCreateSubdirectory((PsiDirectory)directory, (String)directoryName);
                name = name.substring(dot + 1);
                dot = name.indexOf(46);
            }
            psiPackage = javaDirectoryService.getPackage(directory);
            if (psiPackage == null) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/actions/CreateGwtModuleAction", "doCreate"));
                }
                return PsiElement.EMPTY_ARRAY;
            }
        }
        String moduleName = StringUtil.capitalize((String)name);
        ArrayList<Object> res = new ArrayList<Object>();
        GwtFacet gwtFacet = GwtFacet.findFacetBySourceFile(directory.getProject(), directory.getVirtualFile());
        LOG.assertTrue(gwtFacet != null);
        PsiDirectory client = PackageUtil.findOrCreateSubdirectory((PsiDirectory)directory, (String)"client");
        res.add(client);
        PsiClass entryPointClass = CreateGwtModuleAction.createClassFromTemplate(client, moduleName, (FileType)StdFileTypes.JAVA, "GwtEntryPoint.java", new Object[0]);
        GwtVersion version = gwtFacet.getSdkVersion();
        String appPackageName = psiPackage.getQualifiedName();
        res.add(CreateGwtModuleAction.createFromTemplateInternal(directory, moduleName, moduleName + ".gwt.xml", (FileType)StdFileTypes.XML, version.getGwtModuleXmlTemplate(), "GWT_MODULE_DOCTYPE", version.getGwtModuleDocTypeString(), "ENTRY_POINT_CLASS", entryPointClass.getQualifiedName()));
        PsiDirectory server = PackageUtil.findOrCreateSubdirectory((PsiDirectory)directory, (String)"server");
        res.add(server);
        PsiDirectory htmlDirectory = null;
        String htmlDirectoryPath = (String)this.myHtmlDirectory.get();
        if (version.isHtmlFilesOutsideSourcesAreAllowed()) {
            if (htmlDirectoryPath != null) {
                VirtualFile virtualHtmlDirectory = VfsUtil.createDirectoryIfMissing((String)htmlDirectoryPath);
                if (virtualHtmlDirectory == null) {
                    throw new Exception("Cannot create directory '" + this.myHtmlDirectory + "'");
                }
                htmlDirectory = PsiManager.getInstance((Project)gwtFacet.getModule().getProject()).findDirectory(virtualHtmlDirectory);
                if (htmlDirectory == null) {
                    throw new Exception("Cannot find directory '" + virtualHtmlDirectory.getPath() + "'");
                }
            }
        } else {
            htmlDirectory = PackageUtil.findOrCreateSubdirectory((PsiDirectory)directory, (String)"public");
        }
        if (htmlDirectory != null) {
            WebRoot webRoot;
            WebFacet webFacet;
            String gwtModuleName = appPackageName.length() > 0 ? appPackageName + "." + moduleName : moduleName;
            String gwtModuleHtml = version.getGwtModuleHtmlTemplate();
            String gwtModulePath = gwtModuleName;
            if (version.isHtmlFilesOutsideSourcesAreAllowed() && (webFacet = gwtFacet.getWebFacet()) != null && (webRoot = WebUtil.findParentWebRoot((VirtualFile)htmlDirectory.getVirtualFile(), (List)webFacet.getWebRoots())) != null) {
                gwtModulePath = gwtModuleName + "/" + gwtModuleName;
            }
            res.add(CreateGwtModuleAction.createFromTemplate(htmlDirectory, moduleName + "." + StdFileTypes.HTML.getDefaultExtension(), (FileType)StdFileTypes.HTML, gwtModuleHtml, "GWT_MODULE_NAME", gwtModuleName, "GWT_MODULE_PATH", gwtModulePath));
            res.add(CreateGwtModuleAction.createFromTemplate(htmlDirectory, moduleName + ".css", (FileType)CssFileType.INSTANCE, "GwtAppCss.css", new Object[0]));
        }
        res.add(entryPointClass);
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(res);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/actions/CreateGwtModuleAction", "doCreate"));
        }
        return psiElementArray;
    }

    @NotNull
    public static PsiDirectory getRootDirectory(@NotNull PsiDirectory directory) {
        PsiDirectory parentDirectory;
        PsiPackage aPackage;
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/gwt/actions/CreateGwtModuleAction", "getRootDirectory"));
        }
        JavaDirectoryService service = JavaDirectoryService.getInstance();
        while ((aPackage = service.getPackage(directory)) != null && aPackage.getParentPackage() != null && (parentDirectory = directory.getParentDirectory()) != null) {
            directory = parentDirectory;
        }
        PsiDirectory psiDirectory = directory;
        if (psiDirectory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/actions/CreateGwtModuleAction", "getRootDirectory"));
        }
        return psiDirectory;
    }

    protected String getCommandName() {
        return GwtBundle.message("new.module.command.name", new Object[0]);
    }

    protected String getActionName(PsiDirectory directory, String newName) {
        return GwtBundle.message("new.module.progress.text", newName);
    }
}

