/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.eclipse.importer;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.spring.eclipse.importer.SpringBeansConfigImporter;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.eclipse.importWizard.EclipseNatureImporter;

public class EclipseSpringNatureImporter
extends EclipseNatureImporter {
    private static final String NOTIFICATION_GROUP_ID = "Eclipse Spring Nature Import";

    @NotNull
    public String getNatureName() {
        if ("org.springframework.ide.eclipse.core.springnature" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/eclipse/importer/EclipseSpringNatureImporter", "getNatureName"));
        }
        return "org.springframework.ide.eclipse.core.springnature";
    }

    public Set<String> getProvidedCons() {
        return Collections.emptySet();
    }

    public void doImport(@NotNull Project project, @NotNull List<Module> modules) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/eclipse/importer/EclipseSpringNatureImporter", "doImport"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/spring/eclipse/importer/EclipseSpringNatureImporter", "doImport"));
        }
        for (Module module : modules) {
            if (!module.isDisposed()) continue;
            SpringBeansConfigImporter importer = new SpringBeansConfigImporter(module);
            importer.perform();
            if (!importer.errorsOccurred()) continue;
            EclipseSpringNatureImporter.reportError(module, importer.getErrorMessage());
        }
    }

    private static void reportError(Module module, String message) {
        Notification notification = new Notification(NOTIFICATION_GROUP_ID, "Error importing module '" + module.getName() + "'", message, NotificationType.ERROR);
        Notifications.Bus.notify((Notification)notification, (Project)module.getProject());
    }
}

