/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.groovy.grails.compiler;

import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovyResourceLoader;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.grails.compiler.injection.ClassInjector;
import org.codehaus.groovy.grails.compiler.injection.GrailsAwareInjectionOperation;
import org.jetbrains.groovy.compiler.rt.CompilationUnitPatcher;

public class GrailsJUnitPatcher
extends CompilationUnitPatcher {
    public void patchCompilationUnit(CompilationUnit compilationUnit, GroovyResourceLoader resourceLoader, File[] srcFiles) {
        Object instance;
        ClassInjector[] injectors = new ClassInjector[]{new GrailsJUnitInjector()};
        try {
            try {
                Constructor c = GrailsAwareInjectionOperation.class.getConstructor(ClassInjector[].class);
                instance = c.newInstance(new Object[]{injectors});
            }
            catch (NoSuchMethodException e) {
                Constructor c = GrailsAwareInjectionOperation.class.getConstructor(GroovyResourceLoader.class, ClassInjector[].class);
                instance = c.newInstance(resourceLoader, injectors);
            }
        }
        catch (Exception ee) {
            throw new RuntimeException(ee);
        }
        compilationUnit.addPhaseOperation((CompilationUnit.PrimaryClassNodeOperation)((GrailsAwareInjectionOperation)instance), 6);
    }

    public static boolean isReturnNonVoid(MethodNode method) {
        Statement code = method.getCode();
        if (code == null) {
            return false;
        }
        final boolean[] res = new boolean[1];
        code.visit((GroovyCodeVisitor)new CodeVisitorSupport(){

            public void visitReturnStatement(ReturnStatement statement) {
                if (!statement.isReturningNullOrVoid()) {
                    res[0] = true;
                }
            }
        });
        return res[0];
    }

    public static boolean isTestMethod(MethodNode methodNode) {
        return methodNode.getParameters().length == 0 && methodNode.getName().startsWith("test") && (methodNode.getModifiers() & 0x406) == 0;
    }

    private static class GrailsJUnitInjector
    implements ClassInjector {
        private static final Pattern URL_PATTERN = Pattern.compile(".+/test/(.+/)?.+Tests?\\.groovy");

        private GrailsJUnitInjector() {
        }

        public void performInjection(SourceUnit sourceUnit, GeneratorContext generatorContext, ClassNode classNode) {
            GrailsJUnitInjector.addEnableGlobally(classNode);
            if (GrailsJUnitInjector.isExtendsGrailsUnitTestCace(classNode)) {
                GrailsJUnitInjector.patchReturnType(classNode);
            }
        }

        private static void addEnableGlobally(ClassNode classNode) {
            ArrayList<ExpressionStatement> initializer = new ArrayList<ExpressionStatement>();
            initializer.add(new ExpressionStatement((Expression)new StaticMethodCallExpression(new ClassNode(ExpandoMetaClass.class), "enableGlobally", (Expression)new ArgumentListExpression())));
            initializer.add(new ExpressionStatement((Expression)new StaticMethodCallExpression(new ClassNode(System.class), "setProperty", (Expression)new ArgumentListExpression((Expression)new ConstantExpression((Object)"net.sf.ehcache.skipUpdateCheck"), (Expression)new ConstantExpression((Object)"true")))));
            classNode.addStaticInitializerStatements(initializer, true);
        }

        private static void patchReturnType(ClassNode classNode) {
            List methods = classNode.getMethods();
            for (MethodNode method : methods) {
                if (!GrailsJUnitPatcher.isTestMethod(method) || !"java.lang.Object".equals(method.getReturnType().getName()) || GrailsJUnitPatcher.isReturnNonVoid(method)) continue;
                method.setReturnType(ClassHelper.VOID_TYPE);
            }
        }

        private static boolean isExtendsGrailsUnitTestCace(ClassNode classNode) {
            for (ClassNode parent = classNode.getSuperClass(); parent != null; parent = parent.getSuperClass()) {
                if (!"grails.test.GrailsUnitTestCase".equals(parent.getName())) continue;
                return true;
            }
            return false;
        }

        public void performInjection(SourceUnit sourceUnit, ClassNode classNode) {
            this.performInjection(sourceUnit, null, classNode);
        }

        public boolean shouldInject(URL url) {
            if (url == null) {
                return false;
            }
            return URL_PATTERN.matcher(url.getFile()).find();
        }
    }
}

