/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.client.api;

import com.android.tools.klint.client.api.XmlParser;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.ResourceContext;
import com.android.tools.klint.detector.api.XmlContext;
import com.google.common.annotations.Beta;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Beta
class ResourceVisitor {
    private final Map<String, List<Detector.XmlScanner>> mElementToCheck = new HashMap<String, List<Detector.XmlScanner>>();
    private final Map<String, List<Detector.XmlScanner>> mAttributeToCheck = new HashMap<String, List<Detector.XmlScanner>>();
    private final List<Detector.XmlScanner> mDocumentDetectors = new ArrayList<Detector.XmlScanner>();
    private final List<Detector.XmlScanner> mAllElementDetectors = new ArrayList<Detector.XmlScanner>();
    private final List<Detector.XmlScanner> mAllAttributeDetectors = new ArrayList<Detector.XmlScanner>();
    private final List<? extends Detector> mAllDetectors;
    private final List<? extends Detector> mBinaryDetectors;
    private final XmlParser mParser;

    ResourceVisitor(XmlParser parser, List<? extends Detector> xmlDetectors, List<Detector> binaryDetectors) {
        this.mParser = parser;
        this.mAllDetectors = xmlDetectors;
        this.mBinaryDetectors = binaryDetectors;
        for (Detector detector : xmlDetectors) {
            Detector.XmlScanner xmlDetector = (Detector.XmlScanner)((Object)detector);
            Collection<String> attributes = xmlDetector.getApplicableAttributes();
            if (attributes == Detector.XmlScanner.ALL) {
                this.mAllAttributeDetectors.add(xmlDetector);
            } else if (attributes != null) {
                for (String attribute : attributes) {
                    List<Detector.XmlScanner> list = this.mAttributeToCheck.get(attribute);
                    if (list == null) {
                        list = new ArrayList<Detector.XmlScanner>();
                        this.mAttributeToCheck.put(attribute, list);
                    }
                    list.add(xmlDetector);
                }
            }
            Collection<String> elements = xmlDetector.getApplicableElements();
            if (elements == Detector.XmlScanner.ALL) {
                this.mAllElementDetectors.add(xmlDetector);
            } else if (elements != null) {
                for (String element : elements) {
                    List<Detector.XmlScanner> list = this.mElementToCheck.get(element);
                    if (list == null) {
                        list = new ArrayList<Detector.XmlScanner>();
                        this.mElementToCheck.put(element, list);
                    }
                    list.add(xmlDetector);
                }
            }
            if (attributes != null && (!attributes.isEmpty() || attributes == Detector.XmlScanner.ALL) || elements != null && (!elements.isEmpty() || elements == Detector.XmlScanner.ALL)) continue;
            this.mDocumentDetectors.add(xmlDetector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visitFile(XmlContext context, File file) {
        assert (LintUtils.isXmlFile(file));
        try {
            if (context.document == null) {
                context.document = this.mParser.parseXml(context);
                if (context.document == null) {
                    return;
                }
                if (context.document.getDocumentElement() == null) {
                    return;
                }
            }
            for (Detector detector : this.mAllDetectors) {
                detector.beforeCheckFile(context);
            }
            for (Detector.XmlScanner xmlScanner : this.mDocumentDetectors) {
                xmlScanner.visitDocument(context, context.document);
            }
            if (!(this.mElementToCheck.isEmpty() && this.mAttributeToCheck.isEmpty() && this.mAllAttributeDetectors.isEmpty() && this.mAllElementDetectors.isEmpty())) {
                this.visitElement(context, context.document.getDocumentElement());
            }
            for (Detector detector : this.mAllDetectors) {
                detector.afterCheckFile(context);
            }
        }
        finally {
            if (context.document != null) {
                this.mParser.dispose(context, context.document);
                context.document = null;
            }
        }
    }

    private void visitElement(XmlContext context, Element element) {
        int n;
        List<Detector.XmlScanner> elementChecks = this.mElementToCheck.get(element.getTagName());
        if (elementChecks != null) {
            assert (elementChecks instanceof RandomAccess);
            for (Detector.XmlScanner check : elementChecks) {
                check.visitElement(context, element);
            }
        }
        if (!this.mAllElementDetectors.isEmpty()) {
            for (Detector.XmlScanner check : this.mAllElementDetectors) {
                check.visitElement(context, element);
            }
        }
        if (!this.mAttributeToCheck.isEmpty() || !this.mAllAttributeDetectors.isEmpty()) {
            NamedNodeMap attributes = element.getAttributes();
            n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                List<Detector.XmlScanner> list;
                Attr attribute = (Attr)attributes.item(i);
                String name = attribute.getLocalName();
                if (name == null) {
                    name = attribute.getName();
                }
                if ((list = this.mAttributeToCheck.get(name)) != null) {
                    for (Detector.XmlScanner check : list) {
                        check.visitAttribute(context, attribute);
                    }
                }
                if (this.mAllAttributeDetectors.isEmpty()) continue;
                for (Detector.XmlScanner check : this.mAllAttributeDetectors) {
                    check.visitAttribute(context, attribute);
                }
            }
        }
        NodeList childNodes = element.getChildNodes();
        n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1) continue;
            this.visitElement(context, (Element)child);
        }
        if (elementChecks != null) {
            for (Detector.XmlScanner check : elementChecks) {
                check.visitElementAfter(context, element);
            }
        }
        if (!this.mAllElementDetectors.isEmpty()) {
            for (Detector.XmlScanner check : this.mAllElementDetectors) {
                check.visitElementAfter(context, element);
            }
        }
    }

    public XmlParser getParser() {
        return this.mParser;
    }

    public void visitBinaryResource(ResourceContext context) {
        if (this.mBinaryDetectors == null) {
            return;
        }
        for (Detector detector : this.mBinaryDetectors) {
            detector.beforeCheckFile(context);
            detector.checkBinaryResource(context);
            detector.afterCheckFile(context);
        }
    }
}

