/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.client.api;

import com.android.tools.klint.client.api.Configuration;
import com.android.tools.klint.client.api.LintClient;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.google.common.annotations.Beta;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Beta
public abstract class IssueRegistry {
    private static volatile List<Category> sCategories;
    private static volatile Map<String, Issue> sIdToIssue;
    private static Map<EnumSet<Scope>, List<Issue>> sScopeIssues;
    private static final Implementation DUMMY_IMPLEMENTATION;
    public static final Issue PARSER_ERROR;
    public static final Issue LINT_ERROR;
    public static final Issue CANCELLED;

    protected IssueRegistry() {
    }

    public abstract List<Issue> getIssues();

    protected int getIssueCapacity(EnumSet<Scope> scope) {
        return 20;
    }

    protected List<Issue> getIssuesForScope(EnumSet<Scope> scope) {
        List<Issue> list = sScopeIssues.get(scope);
        if (list == null) {
            List<Issue> issues = this.getIssues();
            if (scope.equals(Scope.ALL)) {
                list = issues;
            } else {
                list = new ArrayList<Issue>(this.getIssueCapacity(scope));
                for (Issue issue : issues) {
                    if (!issue.getImplementation().isAdequate(scope)) continue;
                    list.add(issue);
                }
            }
            sScopeIssues.put(scope, list);
        }
        return list;
    }

    final List<? extends Detector> createDetectors(LintClient client, Configuration configuration, EnumSet<Scope> scope, Map<Scope, List<Detector>> scopeToDetectors) {
        List<Issue> issues = this.getIssuesForScope(scope);
        if (issues.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Class<? extends Detector>> detectorClasses = new HashSet<Class<? extends Detector>>();
        HashMap<Class<? extends Detector>, EnumSet<Scope>> detectorToScope = new HashMap<Class<? extends Detector>, EnumSet<Scope>>();
        for (Issue issue : issues) {
            Implementation implementation = issue.getImplementation();
            Class<? extends Detector> detectorClass = implementation.getDetectorClass();
            EnumSet<Scope> issueScope = implementation.getScope();
            if (!detectorClasses.contains(detectorClass)) {
                if (!configuration.isEnabled(issue)) continue;
                assert (implementation.isAdequate(scope));
                detectorClass = client.replaceDetector(detectorClass);
                assert (detectorClass != null) : issue.getId();
                detectorClasses.add(detectorClass);
            }
            if (scopeToDetectors == null) continue;
            EnumSet s = (EnumSet)detectorToScope.get(detectorClass);
            if (s == null) {
                detectorToScope.put(detectorClass, issueScope);
                continue;
            }
            if (s.containsAll(issueScope)) continue;
            EnumSet<Scope> union = EnumSet.copyOf(s);
            union.addAll(issueScope);
            detectorToScope.put(detectorClass, union);
        }
        ArrayList<Detector> detectors = new ArrayList<Detector>(detectorClasses.size());
        for (Class clazz : detectorClasses) {
            try {
                Detector detector = (Detector)clazz.newInstance();
                detectors.add(detector);
                if (scopeToDetectors == null) continue;
                EnumSet union = (EnumSet)detectorToScope.get(clazz);
                for (Scope s : union) {
                    List<Detector> list = scopeToDetectors.get((Object)s);
                    if (list == null) {
                        list = new ArrayList<Detector>();
                        scopeToDetectors.put(s, list);
                    }
                    list.add(detector);
                }
            }
            catch (Throwable t) {
                client.log(t, "Can't initialize detector %1$s", clazz.getName());
            }
        }
        return detectors;
    }

    public final boolean isIssueId(String id) {
        return this.getIssue(id) != null;
    }

    public final boolean isCategoryName(String name) {
        for (Category category : this.getCategories()) {
            if (!category.getName().equals(name) && !category.getFullName().equals(name)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Category> getCategories() {
        List<Category> categories = sCategories;
        if (categories != null) return categories;
        Class<IssueRegistry> clazz = IssueRegistry.class;
        synchronized (IssueRegistry.class) {
            categories = sCategories;
            if (categories != null) return categories;
            sCategories = categories = Collections.unmodifiableList(this.createCategoryList());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return categories;
        }
    }

    private List<Category> createCategoryList() {
        HashSet categorySet = Sets.newHashSetWithExpectedSize((int)20);
        for (Issue issue : this.getIssues()) {
            categorySet.add(issue.getCategory());
        }
        ArrayList<Category> sorted = new ArrayList<Category>(categorySet);
        Collections.sort(sorted);
        return sorted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Issue getIssue(String id) {
        Map<String, Issue> map2 = sIdToIssue;
        if (map2 != null) return map2.get(id);
        Class<IssueRegistry> clazz = IssueRegistry.class;
        synchronized (IssueRegistry.class) {
            map2 = sIdToIssue;
            if (map2 != null) return map2.get(id);
            sIdToIssue = map2 = this.createIdToIssueMap();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return map2.get(id);
        }
    }

    private Map<String, Issue> createIdToIssueMap() {
        List<Issue> issues = this.getIssues();
        HashMap map2 = Maps.newHashMapWithExpectedSize((int)(issues.size() + 2));
        for (Issue issue : issues) {
            map2.put(issue.getId(), issue);
        }
        map2.put(PARSER_ERROR.getId(), PARSER_ERROR);
        map2.put(LINT_ERROR.getId(), LINT_ERROR);
        return map2;
    }

    protected static void reset() {
        sIdToIssue = null;
        sCategories = null;
        sScopeIssues = Maps.newHashMap();
    }

    static {
        sScopeIssues = Maps.newHashMap();
        DUMMY_IMPLEMENTATION = new Implementation(Detector.class, EnumSet.noneOf(Scope.class));
        PARSER_ERROR = Issue.create("ParserError", "Parser Errors", "Lint will ignore any files that contain fatal parsing errors. These may contain other errors, or contain code which affects issues in other files.", Category.CORRECTNESS, 10, Severity.ERROR, DUMMY_IMPLEMENTATION);
        LINT_ERROR = Issue.create("LintError", "Lint Failure", "This issue type represents a problem running lint itself. Examples include failure to find bytecode for source files (which means certain detectors could not be run), parsing errors in lint configuration files, etc.\nThese errors are not errors in your own code, but they are shown to make it clear that some checks were not completed.", Category.LINT, 10, Severity.ERROR, DUMMY_IMPLEMENTATION);
        CANCELLED = Issue.create("LintCanceled", "Lint Canceled", "Lint canceled by user; the issue report may not be complete.", Category.LINT, 0, Severity.INFORMATIONAL, DUMMY_IMPLEMENTATION);
    }
}

