/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.repository.GradleVersion;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.klint.checks.ApiLookup;
import com.android.tools.klint.checks.ControlFlowGraph;
import com.android.tools.klint.checks.RtlDetector;
import com.android.tools.klint.checks.SupportAnnotationDetector;
import com.android.tools.klint.client.api.IssueRegistry;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.client.api.LintDriver;
import com.android.tools.klint.client.api.UastLintUtils;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.ClassContext;
import com.android.tools.klint.detector.api.Context;
import com.android.tools.klint.detector.api.DefaultPosition;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Position;
import com.android.tools.klint.detector.api.ResourceXmlDetector;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.TextFormat;
import com.android.tools.klint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.AnnotationNode;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.IntInsnNode;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UReferenceExpression;
import org.jetbrains.uast.expressions.UTypeReferenceExpression;
import org.jetbrains.uast.java.JavaUAnnotation;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApiDetector
extends ResourceXmlDetector
implements Detector.ClassScanner,
Detector.UastScanner {
    private static final boolean CHECK_DECLARATIONS = false;
    private static final String ATTR_WIDTH = "width";
    private static final String ATTR_HEIGHT = "height";
    private static final String ATTR_SUPPORTS_RTL = "supportsRtl";
    private static final boolean AOSP_BUILD = System.getenv("ANDROID_BUILD_TOP") != null;
    public static final String REQUIRES_API_ANNOTATION = "android.support.annotation.RequiresApi";
    public static final Issue UNSUPPORTED = Issue.create("NewApi", "Calling new methods on older versions", "This check scans through all the Android API calls in the application and warns about any calls that are not available on *all* versions targeted by this application (according to its minimum SDK attribute in the manifest).\n\nIf you really want to use this API and don't need to support older devices just set the `minSdkVersion` in your `build.gradle` or `AndroidManifest.xml` files.\n\nIf your code is *deliberately* accessing newer APIs, and you have ensured (e.g. with conditional execution) that this code will only ever be called on a supported platform, then you can annotate your class or method with the `@TargetApi` annotation specifying the local minimum SDK to apply, such as `@TargetApi(11)`, such that this check considers 11 rather than your manifest file's minimum SDK as the required API level.\n\nIf you are deliberately setting `android:` attributes in style definitions, make sure you place this in a `values-vNN` folder in order to avoid running into runtime conflicts on certain devices where manufacturers have added custom attributes whose ids conflict with the new ones on later platforms.\n\nSimilarly, you can use tools:targetApi=\"11\" in an XML file to indicate that the element will only be inflated in an adequate context.", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(ApiDetector.class, EnumSet.of(Scope.CLASS_FILE, Scope.RESOURCE_FILE, Scope.MANIFEST), Scope.RESOURCE_FILE_SCOPE, Scope.CLASS_FILE_SCOPE, Scope.MANIFEST_SCOPE));
    public static final Issue INLINED = Issue.create("InlinedApi", "Using inlined constants on older versions", "This check scans through all the Android API field references in the application and flags certain constants, such as static final integers and Strings, which were introduced in later versions. These will actually be copied into the class files rather than being referenced, which means that the value is available even when running on older devices. In some cases that's fine, and in other cases it can result in a runtime crash or incorrect behavior. It depends on the context, so consider the code carefully and device whether it's safe and can be suppressed or whether the code needs tbe guarded.\n\nIf you really want to use this API and don't need to support older devices just set the `minSdkVersion` in your `build.gradle` or `AndroidManifest.xml` files.\nIf your code is *deliberately* accessing newer APIs, and you have ensured (e.g. with conditional execution) that this code will only ever be called on a supported platform, then you can annotate your class or method with the `@TargetApi` annotation specifying the local minimum SDK to apply, such as `@TargetApi(11)`, such that this check considers 11 rather than your manifest file's minimum SDK as the required API level.\n", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(ApiDetector.class, Scope.JAVA_FILE_SCOPE));
    public static final Issue OVERRIDE = Issue.create("Override", "Method conflicts with new inherited method", "Suppose you are building against Android API 8, and you've subclassed Activity. In your subclass you add a new method called `isDestroyed`(). At some later point, a method of the same name and signature is added to Android. Your method will now override the Android method, and possibly break its contract. Your method is not calling `super.isDestroyed()`, since your compilation target doesn't know about the method.\n\nThe above scenario is what this lint detector looks for. The above example is real, since `isDestroyed()` was added in API 17, but it will be true for *any* method you have added to a subclass of an Android class where your build target is lower than the version the method was introduced in.\n\nTo fix this, either rename your method, or if you are really trying to augment the builtin method if available, switch to a higher build target where you can deliberately add `@Override` on your overriding method, and call `super` if appropriate etc.\n", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(ApiDetector.class, Scope.CLASS_FILE_SCOPE));
    public static final Issue UNUSED = Issue.create("UnusedAttribute", "Attribute unused on older versions", "This check finds attributes set in XML files that were introduced in a version newer than the oldest version targeted by your application (with the `minSdkVersion` attribute).\n\nThis is not an error; the application will simply ignore the attribute. However, if the attribute is important to the appearance of functionality of your application, you should consider finding an alternative way to achieve the same result with only available attributes, and then you can optionally create a copy of the layout in a layout-vNN folder which will be used on API NN or higher where you can take advantage of the newer attribute.\n\nNote: This check does not only apply to attributes. For example, some tags can be unused too, such as the new `<tag>` element in layouts introduced in API 21.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(ApiDetector.class, Scope.RESOURCE_FILE_SCOPE));
    private static final String TARGET_API_VMSIG = "/TargetApi;";
    private static final String REQ_API_VMSIG = "/RequiresApi;";
    private static final String SWITCH_TABLE_PREFIX = "$SWITCH_TABLE$";
    private static final String ORDINAL_METHOD = "ordinal";
    public static final String ENUM_SWITCH_PREFIX = "$SwitchMap$";
    private static final String TAG_RIPPLE = "ripple";
    private static final String TAG_VECTOR = "vector";
    private static final String TAG_ANIMATED_VECTOR = "animated-vector";
    private static final String TAG_ANIMATED_SELECTOR = "animated-selector";
    private static final String SDK_INT = "SDK_INT";
    private static final String ANDROID_OS_BUILD_VERSION = "android/os/Build$VERSION";
    private static final String REFLECTIVE_OPERATION_EXCEPTION = "java.lang.ReflectiveOperationException";
    protected ApiLookup mApiDatabase;
    private boolean mWarnedMissingDb;
    private int mMinApi = -1;

    @Override
    public void beforeCheckProject(@NonNull Context context) {
        if (this.mApiDatabase == null) {
            this.mApiDatabase = ApiLookup.get(context.getClient());
            if (this.mApiDatabase == null && !this.mWarnedMissingDb) {
                this.mWarnedMissingDb = true;
                context.report(IssueRegistry.LINT_ERROR, Location.create(context.file), "Can't find API database; API check not performed");
            } else {
                Location location;
                AndroidSdkHandler sdk = context.getClient().getSdk();
                if (sdk == null) {
                    return;
                }
                LocalPackage pkgInfo = sdk.getLocalPackage("platform-tools", context.getClient().getRepositoryLogger());
                if (pkgInfo == null) {
                    return;
                }
                Revision revision = pkgInfo.getVersion();
                int compileSdkVersion = context.getProject().getBuildSdk();
                if (compileSdkVersion == 23 ? revision.getMajor() > 23 || revision.getMajor() == 23 && (revision.getMinor() > 0 || revision.getMicro() > 0) : compileSdkVersion <= revision.getMajor()) {
                    return;
                }
                List<File> currentFiles = context.getProject().getSubset();
                if (currentFiles != null && currentFiles.size() == 1) {
                    File file = currentFiles.get(0);
                    String contents = context.getClient().readFile(file);
                    int firstLineEnd = contents.indexOf(10);
                    if (firstLineEnd == -1) {
                        firstLineEnd = contents.length();
                    }
                    location = Location.create(file, new DefaultPosition(0, 0, 0), new DefaultPosition(0, firstLineEnd, firstLineEnd));
                } else {
                    location = Location.create(context.file);
                }
                context.report(UNSUPPORTED, location, String.format("The SDK platform-tools version (%1$s) is too old  to check APIs compiled with API %2$d; please update", revision.toShortString(), compileSdkVersion));
            }
        }
    }

    @Override
    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return true;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return ALL;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    @Override
    public void visitAttribute(@NonNull XmlContext context, @NonNull Attr attribute) {
        int api;
        int minSdk;
        String prefix;
        String message2;
        Location location;
        String owner;
        if (this.mApiDatabase == null) {
            return;
        }
        int attributeApiLevel = -1;
        if ("http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
            int minSdk2;
            String name = attribute.getLocalName();
            if (!(name.equals("layout_width") && !name.equals("layout_height") && !name.equals("id") || (attributeApiLevel = this.mApiDatabase.getFieldVersion(owner = "android/R$attr", name)) <= (minSdk2 = this.getMinSdk(context)) || attributeApiLevel <= context.getFolderVersion() || attributeApiLevel <= ApiDetector.getLocalMinSdk(attribute.getOwnerElement()) || ApiDetector.isBenignUnusedAttribute(name) || ApiDetector.isAlreadyWarnedDrawableFile(context, attribute, attributeApiLevel))) {
                if (RtlDetector.isRtlAttributeName(name) || ATTR_SUPPORTS_RTL.equals(name)) {
                    if (name.equals("paddingStart")) {
                        boolean isOldBuildTools;
                        BuildToolInfo buildToolInfo = context.getProject().getBuildTools();
                        Revision buildTools = buildToolInfo != null ? buildToolInfo.getRevision() : null;
                        boolean bl = isOldBuildTools = buildTools != null && (buildTools.getMajor() < 23 || buildTools.getMajor() == 23 && buildTools.getMinor() == 0 && buildTools.getMicro() == 0);
                        if ((buildTools == null || isOldBuildTools) && ApiDetector.viewMayExtendTextView(attribute.getOwnerElement())) {
                            location = context.getLocation(attribute);
                            message2 = String.format("Attribute `%1$s` referenced here can result in a crash on some specific devices older than API %2$d (current min is %3$d)", attribute.getLocalName(), attributeApiLevel, minSdk2);
                            if (buildTools != null) {
                                message2 = String.format("Upgrade `buildToolsVersion` from `%1$s` to at least `23.0.1`; if not, ", buildTools.toShortString()) + Character.toLowerCase(message2.charAt(0)) + message2.substring(1);
                            }
                            context.report(UNSUPPORTED, attribute, location, message2);
                        }
                    }
                } else {
                    Location location2 = context.getLocation(attribute);
                    String message3 = String.format("Attribute `%1$s` is only used in API level %2$d and higher (current min is %3$d)", attribute.getLocalName(), attributeApiLevel, minSdk2);
                    context.report(UNUSED, attribute, location2, message3);
                }
            }
            if (name.equals("divider")) {
                return;
            }
        }
        String value2 = attribute.getValue();
        owner = null;
        String name = null;
        if (value2.startsWith("@android:")) {
            prefix = "@android:";
        } else if (value2.startsWith("?android:")) {
            int api2;
            prefix = "?android:";
            if (context.getResourceFolderType() == ResourceFolderType.DRAWABLE && (api2 = 21) > (minSdk = this.getMinSdk(context)) && api2 > context.getFolderVersion() && api2 > ApiDetector.getLocalMinSdk(attribute.getOwnerElement())) {
                location = context.getLocation(attribute);
                message2 = String.format("Using theme references in XML drawables requires API level %1$d (current min is %2$d)", api2, minSdk);
                context.report(UNSUPPORTED, attribute, location, message2);
                return;
            }
        } else if (value2.startsWith("android:") && "name".equals(attribute.getName()) && "item".equals(attribute.getOwnerElement().getTagName()) && attribute.getOwnerElement().getParentNode() != null && "style".equals(attribute.getOwnerElement().getParentNode().getNodeName())) {
            owner = "android/R$attr";
            name = value2.substring("android:".length());
            prefix = null;
        } else if (value2.startsWith("android:") && "parent".equals(attribute.getName()) && "style".equals(attribute.getOwnerElement().getTagName())) {
            owner = "android/R$style";
            name = SdkUtils.getResourceFieldName((String)value2.substring("android:".length()));
            prefix = null;
        } else {
            return;
        }
        if (owner == null) {
            int index = value2.indexOf(47, prefix.length());
            if (index != -1) {
                owner = "android/R$" + value2.substring(prefix.length(), index);
                name = SdkUtils.getResourceFieldName((String)value2.substring(index + 1));
            } else if (value2.startsWith("?android:")) {
                owner = "android/R$attr";
                name = value2.substring("?android:".length());
            } else {
                return;
            }
        }
        if ((api = this.mApiDatabase.getFieldVersion(owner, name)) > (minSdk = this.getMinSdk(context)) && api > context.getFolderVersion() && api > ApiDetector.getLocalMinSdk(attribute.getOwnerElement())) {
            if ("http://schemas.android.com/tools".equals(attribute.getNamespaceURI())) {
                return;
            }
            if (attributeApiLevel < api) {
                if (attributeApiLevel > minSdk) {
                    String attributeName = attribute.getLocalName();
                    Location location3 = context.getLocation(attribute);
                    String message4 = String.format("`%1$s` requires API level %2$d (current min is %3$d), but note that attribute `%4$s` is only used in API level %5$d and higher", name, api, minSdk, attributeName, attributeApiLevel);
                    context.report(UNSUPPORTED, attribute, location3, message4);
                } else {
                    location = context.getLocation(attribute);
                    message2 = String.format("`%1$s` requires API level %2$d (current min is %3$d)", value2, api, minSdk);
                    context.report(UNSUPPORTED, attribute, location, message2);
                }
            }
        }
    }

    private static boolean viewMayExtendTextView(@NonNull Element element) {
        String tag = element.getTagName();
        if (tag.equals("view") && ((tag = element.getAttribute("class")) == null || tag.isEmpty())) {
            return false;
        }
        if (tag.indexOf(46) != -1) {
            return true;
        }
        return tag.contains("Text") || tag.contains("Button") || tag.equals("DigitalClock") || tag.equals("Chronometer") || tag.equals("CheckBox") || tag.equals("Switch");
    }

    private static boolean isAlreadyWarnedDrawableFile(@NonNull XmlContext context, @NonNull Attr attribute, int attributeApiLevel) {
        String root;
        return context.getResourceFolderType() == ResourceFolderType.DRAWABLE && attributeApiLevel == 21 && (TAG_RIPPLE.equals(root = attribute.getOwnerDocument().getDocumentElement().getTagName()) || TAG_VECTOR.equals(root) || TAG_ANIMATED_VECTOR.equals(root) || TAG_ANIMATED_SELECTOR.equals(root));
    }

    public static boolean isBenignUnusedAttribute(@NonNull String name) {
        return "labelFor".equals(name) || "textIsSelectable".equals(name) || "textAlignment".equals(name) || "fullBackupContent".equals(name);
    }

    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        if (this.mApiDatabase == null) {
            return;
        }
        String tag = element.getTagName();
        ResourceFolderType folderType = context.getResourceFolderType();
        if (folderType != ResourceFolderType.LAYOUT) {
            if (folderType == ResourceFolderType.DRAWABLE) {
                this.checkElement(context, element, TAG_VECTOR, 21, "1.4", UNSUPPORTED);
                this.checkElement(context, element, TAG_RIPPLE, 21, null, UNSUPPORTED);
                this.checkElement(context, element, TAG_ANIMATED_SELECTOR, 21, null, UNSUPPORTED);
                this.checkElement(context, element, TAG_ANIMATED_VECTOR, 21, null, UNSUPPORTED);
                this.checkElement(context, element, "drawable", 24, null, UNSUPPORTED);
                if ("layer-list".equals(tag)) {
                    this.checkLevelList(context, element);
                } else if (tag.contains(".")) {
                    this.checkElement(context, element, tag, 24, null, UNSUPPORTED);
                }
            }
            if (element.getParentNode().getNodeType() != 1) {
                return;
            }
            NodeList childNodes = element.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                int minSdk;
                String name;
                String owner;
                int api;
                String typeString;
                int index;
                String text;
                Node textNode = childNodes.item(i);
                if (textNode.getNodeType() != 3 || !(text = textNode.getNodeValue()).contains("@android:") || (index = (text = text.trim()).indexOf(47, "@android:".length())) == -1 || ResourceType.getEnum((String)(typeString = text.substring("@android:".length(), index))) == null || (api = this.mApiDatabase.getFieldVersion(owner = "android/R$" + typeString, name = SdkUtils.getResourceFieldName((String)text.substring(index + 1)))) <= (minSdk = this.getMinSdk(context)) || api <= context.getFolderVersion() || api <= ApiDetector.getLocalMinSdk(element)) continue;
                Location location = context.getLocation(textNode);
                String message2 = String.format("`%1$s` requires API level %2$d (current min is %3$d)", text, api, minSdk);
                context.report(UNSUPPORTED, element, location, message2);
            }
        } else {
            int minSdk;
            int api;
            if ("view".equals(tag)) {
                tag = element.getAttribute("class");
                if (tag == null || tag.isEmpty()) {
                    return;
                }
            } else {
                this.checkElement(context, element, "tag", 21, null, UNUSED);
            }
            if (tag.indexOf(46) != -1) {
                return;
            }
            String fqn = "android/widget/" + tag;
            if (tag.equals("TextureView")) {
                fqn = "android/view/TextureView";
            }
            if ((api = this.mApiDatabase.getClassVersion(fqn)) > (minSdk = this.getMinSdk(context)) && api > context.getFolderVersion() && api > ApiDetector.getLocalMinSdk(element)) {
                Location location = context.getLocation(element);
                String message3 = String.format("View requires API level %1$d (current min is %2$d): `<%3$s>`", api, minSdk, tag);
                context.report(UNSUPPORTED, element, location, message3);
            }
        }
    }

    private void checkLevelList(@NonNull XmlContext context, @NonNull Element element) {
        for (Node curr = element.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
            int minSdk;
            int attributeApiLevel;
            Element e;
            if (curr.getNodeType() != 1 || !"item".equals(curr.getNodeName()) || !(e = (Element)curr).hasAttributeNS("http://schemas.android.com/apk/res/android", ATTR_WIDTH) && !e.hasAttributeNS("http://schemas.android.com/apk/res/android", ATTR_HEIGHT) || (attributeApiLevel = 23) <= (minSdk = this.getMinSdk(context)) || attributeApiLevel <= context.getFolderVersion() || attributeApiLevel <= ApiDetector.getLocalMinSdk(element)) continue;
            for (String attributeName : new String[]{ATTR_WIDTH, ATTR_HEIGHT}) {
                Attr attribute = e.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
                if (attribute == null) continue;
                Location location = context.getLocation(attribute);
                String message2 = String.format("Attribute `%1$s` is only used in API level %2$d and higher (current min is %3$d)", attribute.getLocalName(), attributeApiLevel, minSdk);
                context.report(UNUSED, attribute, location, message2);
            }
        }
    }

    private void checkElement(@NonNull XmlContext context, @NonNull Element element, @NonNull String tag, int api, @Nullable String gradleVersion, @NonNull Issue issue) {
        int minSdk;
        if (tag.equals(element.getTagName()) && api > (minSdk = this.getMinSdk(context)) && api > context.getFolderVersion() && api > ApiDetector.getLocalMinSdk(element) && !ApiDetector.featureProvidedByGradle(context, gradleVersion)) {
            String message2;
            Location location = context.getLocation(element);
            if ("drawable".equals(tag)) {
                Attr attribute = element.getAttributeNode("class");
                if (attribute == null) {
                    return;
                }
                location = context.getLocation(attribute);
                tag = "class";
            }
            if (issue == UNSUPPORTED) {
                message2 = String.format("`<%1$s>` requires API level %2$d (current min is %3$d)", tag, api, minSdk);
                if (gradleVersion != null) {
                    message2 = message2 + String.format(" or building with Android Gradle plugin %1$s or higher", gradleVersion);
                } else if (tag.contains(".")) {
                    message2 = String.format("Custom drawables requires API level %1$d (current min is %2$d)", api, minSdk);
                }
            } else {
                assert (issue == UNUSED) : issue;
                message2 = String.format("`<%1$s>` is only used in API level %2$d and higher (current min is %3$d)", tag, api, minSdk);
            }
            context.report(issue, element, location, message2);
        }
    }

    protected int getMinSdk(Context context) {
        if (this.mMinApi == -1) {
            AndroidVersion minSdkVersion = context.getMainProject().getMinSdkVersion();
            this.mMinApi = minSdkVersion.getFeatureLevel();
        }
        return this.mMinApi;
    }

    @Override
    public void checkClass(@NonNull ClassContext context, @NonNull ClassNode classNode) {
        List methodList;
        if (this.mApiDatabase == null) {
            return;
        }
        if (AOSP_BUILD && classNode.name.startsWith("android/support/")) {
            return;
        }
        int classMinSdk = ApiDetector.getClassMinSdk(context, classNode);
        if (classMinSdk == -1) {
            classMinSdk = this.getMinSdk(context);
        }
        if ((methodList = classNode.methods).isEmpty()) {
            return;
        }
        boolean checkCalls = context.isEnabled(UNSUPPORTED) || context.isEnabled(INLINED);
        boolean checkMethods = context.isEnabled(OVERRIDE) && context.getMainProject().getBuildSdk() >= 1;
        Object frameworkParent = null;
        if (checkMethods) {
            LintDriver driver = context.getDriver();
            Object owner = classNode.superName;
            while (owner != null) {
                if (((String)owner).startsWith("android/") && !((String)owner).startsWith("android/support/") || ((String)owner).startsWith("java/") || ((String)owner).startsWith("javax/")) {
                    frameworkParent = owner;
                    break;
                }
                owner = driver.getSuperClass((String)owner);
            }
            if (frameworkParent == null) {
                checkMethods = false;
            }
        }
        if (checkCalls) {
            if (classNode.superName != null) {
                String signature = classNode.superName;
                this.checkExtendsClass(context, classNode, classMinSdk, signature);
            }
            if (classNode.interfaces != null) {
                List interfaceList = classNode.interfaces;
                for (String signature : interfaceList) {
                    this.checkExtendsClass(context, classNode, classMinSdk, signature);
                }
            }
        }
        for (Object m : methodList) {
            MethodNode method = (MethodNode)m;
            int minSdk = ApiDetector.getLocalMinSdk(method.invisibleAnnotations);
            if (minSdk == -1) {
                minSdk = classMinSdk;
            }
            InsnList nodes = method.instructions;
            if (checkMethods && Character.isJavaIdentifierStart(method.name.charAt(0))) {
                int buildSdk = context.getMainProject().getBuildSdk();
                String name = method.name;
                assert (frameworkParent != null);
                int api = this.mApiDatabase.getCallVersion((String)frameworkParent, name, method.desc);
                if (api > buildSdk && buildSdk != -1) {
                    String owner = classNode.name;
                    String fqcn = "<init>".equals(name) ? "new " + ClassContext.getFqcn(owner) : ClassContext.getFqcn(owner) + '#' + name;
                    String message2 = String.format("This method is not overriding anything with the current build target, but will in API level %1$d (current target is %2$d): `%3$s`", api, buildSdk, fqcn);
                    Location location = context.getLocation(method, classNode);
                    context.report(OVERRIDE, method, null, location, message2);
                }
            }
            if (!checkCalls) continue;
            int n = nodes.size();
            block3: for (int i = 0; i < n; ++i) {
                Type t;
                String className;
                int api;
                String owner;
                String name;
                MethodInsnNode node;
                AbstractInsnNode instruction = nodes.get(i);
                int type2 = instruction.getType();
                if (type2 == 5) {
                    node = (MethodInsnNode)instruction;
                    name = node.name;
                    owner = node.owner;
                    String desc = node.desc;
                    if (node.getOpcode() == 182 && owner.equals(classNode.name)) {
                        owner = classNode.superName;
                    }
                    boolean checkingSuperClass = false;
                    while (owner != null) {
                        int api2 = this.mApiDatabase.getCallVersion(owner, name, desc);
                        if (api2 > minSdk) {
                            if (method.name.startsWith(SWITCH_TABLE_PREFIX) || !checkingSuperClass && node.getOpcode() == 182 && ApiDetector.methodDefinedLocally(classNode, name, desc)) continue block3;
                            String fqcn = "<init>".equals(name) ? "new " + ClassContext.getFqcn(owner) : ClassContext.getFqcn(owner) + '#' + name;
                            String message3 = String.format("Call requires API level %1$d (current min is %2$d): `%3$s`", api2, minSdk, fqcn);
                            if (name.equals(ORDINAL_METHOD) && instruction.getNext() != null && instruction.getNext().getNext() != null && instruction.getNext().getOpcode() == 46 && instruction.getNext().getNext().getOpcode() == 170) {
                                message3 = String.format("Enum for switch requires API level %1$d (current min is %2$d): `%3$s`", api2, minSdk, ClassContext.getFqcn(owner));
                            }
                            if (instruction.getOpcode() == 183 && name.equals(method.name) && desc.equals(method.desc) && !name.equals("<init>") || ApiDetector.isWithinSdkConditional(context, classNode, method, instruction, api2)) continue block3;
                            if (api2 == 19 && owner.equals("java/lang/ReflectiveOperationException") && !method.tryCatchBlocks.isEmpty()) {
                                boolean direct = false;
                                for (Object o : method.tryCatchBlocks) {
                                    if (!((TryCatchBlockNode)o).type.equals("java/lang/ReflectiveOperationException")) continue;
                                    direct = true;
                                    break;
                                }
                                if (!direct) {
                                    message3 = String.format("Multi-catch with these reflection exceptions requires API level 19 (current min is %2$d) because they get compiled to the common but new super type `ReflectiveOperationException`. As a workaround either create individual catch statements, or catch `Exception`.", api2, minSdk);
                                }
                            }
                            if (api2 == 24 && "java.util.concurrent.ConcurrentHashMap.KeySetView#iterator".equals(fqcn)) {
                                message3 = message3 + ". The `keySet()` method in `ConcurrentHashMap` changed in a backwards incompatible way in Java 8; to work around this issue, add an explicit cast to `(Map)` before the `keySet()` call.";
                            }
                            ApiDetector.report(context, message3, (AbstractInsnNode)node, method, name, null, Location.SearchHints.create(Location.SearchDirection.FORWARD).matchJavaSymbol());
                            continue block3;
                        }
                        if (owner.startsWith("android/") || owner.startsWith("javax/")) {
                            owner = owner.startsWith("android/support/") && api2 == -1 ? context.getDriver().getSuperClass(owner) : null;
                        } else if (owner.startsWith("java/")) {
                            if (owner.equals("java/text/SimpleDateFormat")) {
                                ApiDetector.checkSimpleDateFormat(context, method, node, minSdk);
                            }
                            owner = null;
                        } else {
                            owner = node.getOpcode() == 182 ? context.getDriver().getSuperClass(owner) : (node.getOpcode() == 184 && api2 == -1 ? context.getDriver().getSuperClass(owner) : null);
                        }
                        checkingSuperClass = true;
                    }
                    continue;
                }
                if (type2 == 4) {
                    node = (FieldInsnNode)instruction;
                    owner = node.owner;
                    name = node.name;
                    int api3 = this.mApiDatabase.getFieldVersion(owner, name);
                    if (api3 <= minSdk) continue;
                    if (method.name.startsWith(SWITCH_TABLE_PREFIX)) {
                        ApiDetector.checkSwitchBlock(context, classNode, (FieldInsnNode)node, method, name, owner, api3, minSdk);
                        continue;
                    }
                    if (ApiDetector.isSkippedEnumSwitch(context, classNode, method, (FieldInsnNode)node, owner, api3) || ApiDetector.isWithinSdkConditional(context, classNode, method, instruction, api3)) continue;
                    String fqcn = ClassContext.getFqcn(owner) + '#' + name;
                    String message4 = String.format("Field requires API level %1$d (current min is %2$d): `%3$s`", api3, minSdk, fqcn);
                    ApiDetector.report(context, message4, (AbstractInsnNode)node, method, name, null, Location.SearchHints.create(Location.SearchDirection.FORWARD).matchJavaSymbol());
                    continue;
                }
                if (type2 != 9) continue;
                node = (LdcInsnNode)instruction;
                if (!(node.cst instanceof Type) || (api = this.mApiDatabase.getClassVersion(className = (t = (Type)node.cst).getInternalName())) <= minSdk) continue;
                String fqcn = ClassContext.getFqcn(className);
                String message5 = String.format("Class requires API level %1$d (current min is %2$d): `%3$s`", api, minSdk, fqcn);
                ApiDetector.report(context, message5, (AbstractInsnNode)node, method, className.substring(className.lastIndexOf(47) + 1), null, Location.SearchHints.create(Location.SearchDirection.FORWARD).matchJavaSymbol());
            }
        }
    }

    private void checkExtendsClass(ClassContext context, ClassNode classNode, int classMinSdk, String signature) {
        int api = this.mApiDatabase.getClassVersion(signature);
        if (api > classMinSdk) {
            String fqcn = ClassContext.getFqcn(signature);
            String message2 = String.format("Class requires API level %1$d (current min is %2$d): `%3$s`", api, classMinSdk, fqcn);
            String name = signature.substring(signature.lastIndexOf(47) + 1);
            name = name.substring(name.lastIndexOf(36) + 1);
            Location.SearchHints hints = Location.SearchHints.create(Location.SearchDirection.BACKWARD).matchJavaSymbol();
            int lineNumber = ClassContext.findLineNumber(classNode);
            Location location = context.getLocationForLine(lineNumber, name, null, hints);
            context.report(UNSUPPORTED, location, message2);
        }
    }

    private static void checkSimpleDateFormat(ClassContext context, MethodNode method, MethodInsnNode node, int minSdk) {
        if (minSdk >= 9) {
            return;
        }
        if (node.name.equals("<init>") && !node.desc.equals("()V")) {
            AbstractInsnNode prev = LintUtils.getPrevInstruction((AbstractInsnNode)node);
            if (prev != null && !node.desc.equals("(Ljava/lang/String;)V")) {
                prev = LintUtils.getPrevInstruction(prev);
            }
            if (prev != null && prev.getOpcode() == 18) {
                LdcInsnNode ldc = (LdcInsnNode)prev;
                Object cst = ldc.cst;
                if (cst instanceof String) {
                    String pattern = (String)cst;
                    boolean isEscaped = false;
                    for (int i = 0; i < pattern.length(); ++i) {
                        char c = pattern.charAt(i);
                        if (c == '\'') {
                            isEscaped = !isEscaped;
                            continue;
                        }
                        if (isEscaped || c != 'L' && c != 'c') continue;
                        String message2 = String.format("The pattern character '%1$c' requires API level 9 (current min is %2$d) : \"`%3$s`\"", Character.valueOf(c), minSdk, pattern);
                        ApiDetector.report(context, message2, (AbstractInsnNode)node, method, pattern, null, Location.SearchHints.create(Location.SearchDirection.FORWARD));
                        return;
                    }
                }
            }
        }
    }

    private static boolean methodDefinedLocally(ClassNode classNode, String name, String desc) {
        List methodList = classNode.methods;
        for (Object m : methodList) {
            MethodNode method = (MethodNode)m;
            if (!name.equals(method.name) || !desc.equals(method.desc)) continue;
            return true;
        }
        return false;
    }

    private static void checkSwitchBlock(ClassContext context, ClassNode classNode, FieldInsnNode field, MethodNode method, String name, String owner, int api, int minSdk) {
        int ordinal;
        AbstractInsnNode next = field.getNext();
        if (next == null || next.getOpcode() != 182) {
            return;
        }
        if ((next = next.getNext()) == null) {
            return;
        }
        switch (next.getOpcode()) {
            case 3: {
                ordinal = 0;
                break;
            }
            case 4: {
                ordinal = 1;
                break;
            }
            case 5: {
                ordinal = 2;
                break;
            }
            case 6: {
                ordinal = 3;
                break;
            }
            case 7: {
                ordinal = 4;
                break;
            }
            case 8: {
                ordinal = 5;
                break;
            }
            case 16: {
                IntInsnNode iin = (IntInsnNode)next;
                ordinal = iin.operand;
                break;
            }
            default: {
                return;
            }
        }
        List methodList = classNode.methods;
        for (Object m : methodList) {
            InsnList nodes = ((MethodNode)m).instructions;
            int n = nodes.size();
            block10: for (int i = 0; i < n; ++i) {
                AbstractInsnNode instruction = nodes.get(i);
                if (instruction.getOpcode() != 184) continue;
                MethodInsnNode node = (MethodInsnNode)instruction;
                if (!node.name.equals(method.name) || !node.desc.equals(method.desc) || !node.owner.equals(classNode.name)) continue;
                AbstractInsnNode target = LintUtils.getNextInstruction((AbstractInsnNode)node);
                while (target != null) {
                    if (target.getOpcode() == 171) {
                        LookupSwitchInsnNode lookup = (LookupSwitchInsnNode)target;
                        List keys = lookup.keys;
                        if (keys != null && keys.contains(ordinal)) {
                            String fqcn = ClassContext.getFqcn(owner) + '#' + name;
                            String message2 = String.format("Enum value requires API level %1$d (current min is %2$d): `%3$s`", api, minSdk, fqcn);
                            ApiDetector.report(context, message2, (AbstractInsnNode)lookup, (MethodNode)m, name, null, Location.SearchHints.create(Location.SearchDirection.FORWARD).matchJavaSymbol());
                            continue block10;
                        }
                    }
                    target = LintUtils.getNextInstruction(target);
                }
            }
        }
    }

    private static boolean isEnumSwitchInitializer(ClassNode classNode) {
        List fieldList = classNode.fields;
        for (Object f : fieldList) {
            FieldNode field = (FieldNode)f;
            if (!field.name.startsWith(ENUM_SWITCH_PREFIX)) continue;
            return true;
        }
        return false;
    }

    private static MethodNode findEnumSwitchUsage(ClassNode classNode, String owner) {
        String target = ENUM_SWITCH_PREFIX + owner.replace('/', '$');
        List methodList = classNode.methods;
        for (Object f : methodList) {
            MethodNode method = (MethodNode)f;
            InsnList nodes = method.instructions;
            int n = nodes.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode instruction = nodes.get(i);
                if (instruction.getOpcode() != 178) continue;
                FieldInsnNode field = (FieldInsnNode)instruction;
                if (!field.name.equals(target)) continue;
                return method;
            }
        }
        return null;
    }

    private static boolean isSkippedEnumSwitch(ClassContext context, ClassNode classNode, MethodNode method, FieldInsnNode node, String owner, int api) {
        MethodNode switchUser;
        LintDriver driver;
        ClassNode outer;
        AbstractInsnNode next = LintUtils.getNextInstruction((AbstractInsnNode)node);
        if (next != null && next.getOpcode() == 182 && "<clinit>".equals(method.name) && ORDINAL_METHOD.equals(((MethodInsnNode)next).name) && classNode.outerClass != null && ApiDetector.isEnumSwitchInitializer(classNode) && (outer = (driver = context.getDriver()).getOuterClassNode(classNode)) != null && (switchUser = ApiDetector.findEnumSwitchUsage(outer, owner)) != null) {
            if (driver.isSuppressed(UNSUPPORTED, outer, switchUser, null)) {
                return true;
            }
            if (ApiDetector.getLocalMinSdk(switchUser.invisibleAnnotations) >= api || ApiDetector.getLocalMinSdk(outer.invisibleAnnotations) >= api) {
                return true;
            }
        }
        return false;
    }

    private static int getClassMinSdk(ClassContext context, ClassNode classNode) {
        int classMinSdk = ApiDetector.getLocalMinSdk(classNode.invisibleAnnotations);
        if (classMinSdk != -1) {
            return classMinSdk;
        }
        LintDriver driver = context.getDriver();
        while (classNode != null) {
            ClassNode prev = classNode;
            if ((classNode = driver.getOuterClassNode(classNode)) == null) continue;
            if (prev.outerMethod != null) {
                List methods = classNode.methods;
                for (Object m : methods) {
                    MethodNode method = (MethodNode)m;
                    if (!method.name.equals(prev.outerMethod) || !method.desc.equals(prev.outerMethodDesc)) continue;
                    int methodMinSdk = ApiDetector.getLocalMinSdk(method.invisibleAnnotations);
                    if (methodMinSdk == -1) break;
                    return methodMinSdk;
                }
            }
            if ((classMinSdk = ApiDetector.getLocalMinSdk(classNode.invisibleAnnotations)) == -1) continue;
            return classMinSdk;
        }
        return -1;
    }

    private static int getLocalMinSdk(List annotations2) {
        if (annotations2 != null) {
            for (AnnotationNode annotation : annotations2) {
                Object value2;
                String key;
                int i;
                int n;
                String desc = annotation.desc;
                if (desc.endsWith(TARGET_API_VMSIG)) {
                    if (annotation.values == null) continue;
                    n = annotation.values.size();
                    for (i = 0; i < n; i += 2) {
                        key = (String)annotation.values.get(i);
                        if (!key.equals("value") || !((value2 = annotation.values.get(i + 1)) instanceof Integer)) continue;
                        return (Integer)value2;
                    }
                    continue;
                }
                if (!desc.endsWith(REQ_API_VMSIG) || annotation.values == null) continue;
                n = annotation.values.size();
                for (i = 0; i < n; i += 2) {
                    int api;
                    key = (String)annotation.values.get(i);
                    if (!key.equals("value") && !key.equals("api") || !((value2 = annotation.values.get(i + 1)) instanceof Integer) || (api = ((Integer)value2).intValue()) <= 1) continue;
                    return api;
                }
            }
        }
        return -1;
    }

    private static int getLocalMinSdk(@NonNull Element element) {
        while (element != null) {
            String targetApi = element.getAttributeNS("http://schemas.android.com/tools", "targetApi");
            if (targetApi != null && !targetApi.isEmpty()) {
                if (Character.isDigit(targetApi.charAt(0))) {
                    try {
                        return Integer.parseInt(targetApi);
                    }
                    catch (NumberFormatException e) {
                        break;
                    }
                }
                return SdkVersionInfo.getApiByBuildCode((String)targetApi, (boolean)true);
            }
            Node parent = element.getParentNode();
            if (parent == null || parent.getNodeType() != 1) break;
            element = (Element)parent;
        }
        return -1;
    }

    private static boolean featureProvidedByGradle(@NonNull XmlContext context, @Nullable String minGradleVersionString) {
        GradleVersion minVersion;
        if (minGradleVersionString == null) {
            return false;
        }
        GradleVersion gradleModelVersion = context.getProject().getGradleModelVersion();
        return gradleModelVersion != null && (minVersion = GradleVersion.tryParse((String)minGradleVersionString)) != null && gradleModelVersion.compareIgnoringQualifiers(minVersion) >= 0;
    }

    private static void report(ClassContext context, String message2, AbstractInsnNode node, MethodNode method, String patternStart, String patternEnd, Location.SearchHints hints) {
        int lineNumber;
        int n = lineNumber = node != null ? ClassContext.findLineNumber(node) : -1;
        if (patternStart != null && patternStart.equals("<init>") && node instanceof MethodInsnNode) {
            if (hints != null) {
                hints = hints.matchConstructor();
            }
            patternStart = ((MethodInsnNode)node).owner;
        }
        if (patternStart != null) {
            int index = patternStart.lastIndexOf(36);
            if (index != -1) {
                patternStart = patternStart.substring(index + 1);
            }
            if ((index = patternStart.lastIndexOf(47)) != -1) {
                patternStart = patternStart.substring(index + 1);
            }
        }
        Location location = context.getLocationForLine(lineNumber, patternStart, patternEnd, hints);
        context.report(UNSUPPORTED, method, node, location, message2);
    }

    @Override
    @Nullable
    public UastVisitor createUastVisitor(@NonNull JavaContext context) {
        if (this.mApiDatabase == null) {
            return new AbstractUastVisitor(){

                @Override
                public boolean visitElement(UElement element) {
                    return super.visitElement(element);
                }
            };
        }
        return new ApiVisitor(context);
    }

    @Override
    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        ArrayList<Class<? extends UElement>> types = new ArrayList<Class<? extends UElement>>(9);
        types.add(UImportStatement.class);
        types.add(USimpleNameReferenceExpression.class);
        types.add(UVariable.class);
        types.add(UTryExpression.class);
        types.add(UBinaryExpressionWithType.class);
        types.add(UBinaryExpression.class);
        types.add(UCallExpression.class);
        types.add(UClass.class);
        types.add(UMethod.class);
        return types;
    }

    public static boolean isBenignConstantUsage(@Nullable UElement node, @NonNull String name, @NonNull String owner) {
        if (owner.equals("android/os/Build$VERSION_CODES")) {
            return true;
        }
        if (owner.equals("android/view/ViewGroup$LayoutParams") && name.equals("MATCH_PARENT")) {
            return true;
        }
        if (owner.equals("android/widget/AbsListView") && (name.equals("CHOICE_MODE_NONE") || name.equals("CHOICE_MODE_MULTIPLE") || name.equals("CHOICE_MODE_SINGLE"))) {
            return true;
        }
        if ("android/view/Gravity".equals(owner) && ("START".equals(name) || "END".equals(name))) {
            return true;
        }
        if (node == null) {
            return false;
        }
        for (UElement curr = node.getContainingElement(); curr != null; curr = curr.getContainingElement()) {
            if (curr instanceof USwitchClauseExpression) {
                List<UExpression> caseValues2 = ((USwitchClauseExpression)curr).getCaseValues();
                if (caseValues2 != null) {
                    for (UExpression condition2 : caseValues2) {
                        if (condition2 == null || !UastUtils.isChildOf(node, condition2, false)) continue;
                        return true;
                    }
                }
                return false;
            }
            if (curr instanceof UIfExpression) {
                UExpression condition3 = ((UIfExpression)curr).getCondition();
                return UastUtils.isChildOf(node, condition3, false);
            }
            if (curr instanceof UMethod || curr instanceof UClass) break;
        }
        return false;
    }

    private static boolean isSuppressed(int api, UElement element, int minSdk, JavaContext context) {
        if (api <= minSdk) {
            return true;
        }
        int target = ApiDetector.getTargetApi(element);
        if (target != -1 && api <= target) {
            return true;
        }
        if (ApiDetector.isWithinVersionCheckConditional(element, api, context)) {
            return true;
        }
        return ApiDetector.isPrecededByVersionCheckExit(element, api, context);
    }

    private static int getTargetApi(@Nullable UElement scope) {
        while (scope != null) {
            PsiModifierList modifierList;
            int targetApi;
            if (scope instanceof PsiModifierListOwner && (targetApi = ApiDetector.getTargetApi(modifierList = ((PsiModifierListOwner)scope).getModifierList())) != -1) {
                return targetApi;
            }
            if (!((scope = scope.getContainingElement()) instanceof PsiFile)) continue;
            break;
        }
        return -1;
    }

    public static int getTargetApi(@Nullable PsiModifierList modifierList) {
        if (modifierList == null) {
            return -1;
        }
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            String fqcn = annotation.getQualifiedName();
            if (fqcn == null || !fqcn.equals("android.annotation.TargetApi") && !fqcn.equals(REQUIRES_API_ANNOTATION) && !fqcn.equals("TargetApi")) continue;
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            for (PsiNameValuePair pair : parameterList.getAttributes()) {
                PsiAnnotationMemberValue v = pair.getValue();
                if (v instanceof PsiLiteral) {
                    PsiLiteral literal = (PsiLiteral)v;
                    Object value2 = literal.getValue();
                    if (value2 instanceof Integer) {
                        return (Integer)value2;
                    }
                    if (!(value2 instanceof String)) continue;
                    return ApiDetector.codeNameToApi((String)value2);
                }
                if (v instanceof PsiArrayInitializerMemberValue) {
                    PsiArrayInitializerMemberValue mv = (PsiArrayInitializerMemberValue)v;
                    for (PsiAnnotationMemberValue mmv : mv.getInitializers()) {
                        if (!(mmv instanceof PsiLiteral)) continue;
                        PsiLiteral literal = (PsiLiteral)mmv;
                        Object value3 = literal.getValue();
                        if (value3 instanceof Integer) {
                            return (Integer)value3;
                        }
                        if (!(value3 instanceof String)) continue;
                        return ApiDetector.codeNameToApi((String)value3);
                    }
                    continue;
                }
                if (!(v instanceof PsiExpression)) continue;
                if (v instanceof PsiReferenceExpression) {
                    String name = ((PsiReferenceExpression)v).getQualifiedName();
                    return ApiDetector.codeNameToApi(name);
                }
                return ApiDetector.codeNameToApi(v.getText());
            }
        }
        return -1;
    }

    public static int codeNameToApi(@NonNull String text) {
        int dotIndex = text.lastIndexOf(46);
        if (dotIndex != -1) {
            text = text.substring(dotIndex + 1);
        }
        return SdkVersionInfo.getApiByBuildCode((String)text, (boolean)true);
    }

    public static int getRequiredVersion(@NonNull Issue issue, @NonNull String errorMessage, @NonNull TextFormat format) {
        Pattern pattern;
        Matcher matcher;
        errorMessage = format.toText(errorMessage);
        if ((issue == UNSUPPORTED || issue == INLINED) && (matcher = (pattern = Pattern.compile("\\s(\\d+)\\s")).matcher(errorMessage)).find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    private static boolean isWithinSdkConditional(@NonNull ClassContext context, @NonNull ClassNode classNode, @NonNull MethodNode method, @NonNull AbstractInsnNode call, int requiredApi) {
        assert (requiredApi != -1);
        if (!ApiDetector.containsSimpleSdkCheck(method)) {
            return false;
        }
        try {
            ApiCheckGraph graph = new ApiCheckGraph(requiredApi);
            ControlFlowGraph.create(graph, classNode, method);
            AbstractInsnNode first = method.instructions.get(0);
            return !graph.isConnected(first, call);
        }
        catch (AnalyzerException e) {
            context.log(e, null, new Object[0]);
            return false;
        }
    }

    private static boolean containsSimpleSdkCheck(@NonNull MethodNode method) {
        InsnList nodes = method.instructions;
        int n = nodes.size();
        for (int i = 0; i < n; ++i) {
            AbstractInsnNode ifNode;
            AbstractInsnNode bipush;
            AbstractInsnNode instruction = nodes.get(i);
            if (!ApiDetector.isSdkVersionLookup(instruction) || (bipush = LintUtils.getNextInstruction(instruction)) == null || bipush.getOpcode() != 16 || (ifNode = LintUtils.getNextInstruction(bipush)) == null || ifNode.getType() != 7) continue;
            return true;
        }
        return false;
    }

    private static boolean isSdkVersionLookup(@NonNull AbstractInsnNode instruction) {
        if (instruction.getOpcode() == 178) {
            FieldInsnNode fieldNode = (FieldInsnNode)instruction;
            return SDK_INT.equals(fieldNode.name) && ANDROID_OS_BUILD_VERSION.equals(fieldNode.owner);
        }
        return false;
    }

    protected static boolean isPrecededByVersionCheckExit(UElement element, int api, JavaContext context) {
        UExpression currentExpression = (UExpression)UastUtils.getParentOfType(element, UExpression.class, true, UMethod.class, UClass.class);
        while (currentExpression != null) {
            VersionCheckWithExitFinder visitor = new VersionCheckWithExitFinder(currentExpression, element, api, context);
            currentExpression.accept(visitor);
            if (visitor.found()) {
                return true;
            }
            element = currentExpression;
            currentExpression = (UExpression)UastUtils.getParentOfType((UElement)currentExpression, UExpression.class, true, UMethod.class, UClass.class);
        }
        return false;
    }

    private static boolean isUnconditionalReturn(UExpression statement) {
        List<UExpression> expressions2;
        if (statement instanceof UBlockExpression && (expressions2 = ((UBlockExpression)statement).getExpressions()).size() == 1 && expressions2.get(0) instanceof UReturnExpression) {
            return true;
        }
        return statement instanceof UReturnExpression;
    }

    public static boolean isWithinVersionCheckConditional(UElement element, int api, JavaContext context) {
        UElement prev = element;
        for (UElement current = element.getContainingElement(); current != null; current = current.getContainingElement()) {
            if (current instanceof UIfExpression) {
                UIfExpression ifStatement = (UIfExpression)current;
                Boolean isConditional = ApiDetector.isVersionCheckConditional(api, prev, ifStatement, context);
                if (isConditional != null) {
                    return isConditional;
                }
            } else if (current instanceof UMethod || current instanceof UFile) {
                return false;
            }
            prev = current;
        }
        return false;
    }

    @Nullable
    private static Boolean isVersionCheckConditional(int api, UElement prev, UIfExpression ifStatement, @NonNull JavaContext context) {
        Boolean isConditional;
        UReturnExpression returnStatement;
        UExpression returnValue;
        UExpression statement;
        UExpression body2;
        List<UExpression> expressions2;
        UCallExpression call;
        PsiMethod method;
        UExpression condition2 = ifStatement.getCondition();
        if (condition2 != prev && condition2 instanceof UBinaryExpression) {
            Boolean isConditional2 = ApiDetector.isVersionCheckConditional(api, prev, ifStatement, (UBinaryExpression)condition2);
            if (isConditional2 != null) {
                return isConditional2;
            }
        } else if (condition2 instanceof UCallExpression && (method = (call = (UCallExpression)condition2).resolve()) != null && !method.hasModifierProperty("abstract") && (expressions2 = (body2 = context.getUastContext().getMethodBody(method)) instanceof UBlockExpression ? ((UBlockExpression)body2).getExpressions() : Collections.singletonList(body2)).size() == 1 && (statement = expressions2.get(0)) instanceof UReturnExpression && (returnValue = (returnStatement = (UReturnExpression)statement).getReturnExpression()) instanceof UBinaryExpression && (isConditional = ApiDetector.isVersionCheckConditional(api, null, null, (UBinaryExpression)returnValue)) != null) {
            return isConditional;
        }
        return null;
    }

    @Nullable
    private static Boolean isVersionCheckConditional(int api, @Nullable UElement prev, @Nullable UIfExpression ifStatement, @NonNull UBinaryExpression binary) {
        UastBinaryOperator tokenType = binary.getOperator();
        if (tokenType == UastBinaryOperator.GREATER || tokenType == UastBinaryOperator.GREATER_OR_EQUAL || tokenType == UastBinaryOperator.LESS_OR_EQUAL || tokenType == UastBinaryOperator.LESS || tokenType == UastBinaryOperator.EQUALS || tokenType == UastBinaryOperator.IDENTITY_EQUALS) {
            UReferenceExpression ref;
            UExpression left = binary.getLeftOperand();
            if (left instanceof UReferenceExpression && SDK_INT.equals((ref = (UReferenceExpression)left).getResolvedName())) {
                ULiteralExpression lit;
                Object value2;
                UExpression right = binary.getRightOperand();
                int level = -1;
                if (right instanceof UReferenceExpression) {
                    UReferenceExpression ref2 = (UReferenceExpression)right;
                    String codeName = ref2.getResolvedName();
                    if (codeName == null) {
                        return false;
                    }
                    level = SdkVersionInfo.getApiByBuildCode((String)codeName, (boolean)true);
                } else if (right instanceof ULiteralExpression && (value2 = (lit = (ULiteralExpression)right).getValue()) instanceof Integer) {
                    level = (Integer)value2;
                }
                if (level != -1) {
                    boolean fromElse;
                    boolean fromThen = ifStatement == null || prev == ifStatement.getThenExpression();
                    boolean bl = fromElse = ifStatement != null && prev == ifStatement.getElseExpression();
                    assert (fromThen == !fromElse);
                    if (tokenType == UastBinaryOperator.GREATER_OR_EQUAL) {
                        return level >= api && fromThen;
                    }
                    if (tokenType == UastBinaryOperator.GREATER) {
                        return level >= api - 1 && fromThen;
                    }
                    if (tokenType == UastBinaryOperator.LESS_OR_EQUAL) {
                        return level >= api - 1 && fromElse;
                    }
                    if (tokenType == UastBinaryOperator.LESS) {
                        return level >= api && fromElse;
                    }
                    if (tokenType == UastBinaryOperator.EQUALS || tokenType == UastBinaryOperator.IDENTITY_EQUALS) {
                        return level >= api && fromThen;
                    }
                    assert (false) : tokenType;
                }
            }
        } else if (tokenType == UastBinaryOperator.LOGICAL_AND && ifStatement != null && prev == ifStatement.getThenExpression() && ApiDetector.isAndedWithConditional(ifStatement.getCondition(), api, prev)) {
            return true;
        }
        return null;
    }

    private static boolean isAndedWithConditional(UElement element, int api, @Nullable UElement before) {
        if (element instanceof UBinaryExpression) {
            UBinaryExpression inner = (UBinaryExpression)element;
            if (inner.getOperator() == UastBinaryOperator.LOGICAL_AND) {
                return ApiDetector.isAndedWithConditional(inner.getLeftOperand(), api, before) || inner.getRightOperand() != before && ApiDetector.isAndedWithConditional(inner.getRightOperand(), api, before);
            }
            if (inner.getLeftOperand() instanceof UReferenceExpression && SDK_INT.equals(((UReferenceExpression)inner.getLeftOperand()).getResolvedName())) {
                ULiteralExpression lit;
                Object value2;
                int level = -1;
                UastBinaryOperator tokenType = inner.getOperator();
                UExpression right = inner.getRightOperand();
                if (right instanceof UReferenceExpression) {
                    UReferenceExpression ref2 = (UReferenceExpression)right;
                    String codeName = ref2.getResolvedName();
                    if (codeName == null) {
                        return false;
                    }
                    level = SdkVersionInfo.getApiByBuildCode((String)codeName, (boolean)true);
                } else if (right instanceof ULiteralExpression && (value2 = (lit = (ULiteralExpression)right).getValue()) instanceof Integer) {
                    level = (Integer)value2;
                }
                if (level != -1) {
                    if (tokenType == UastBinaryOperator.GREATER_OR_EQUAL) {
                        return level >= api;
                    }
                    if (tokenType == UastBinaryOperator.GREATER) {
                        return level >= api - 1;
                    }
                    if (tokenType == UastBinaryOperator.EQUALS || tokenType == UastBinaryOperator.IDENTITY_EQUALS) {
                        return level >= api;
                    }
                }
            }
        }
        return false;
    }

    private static class VersionCheckWithExitFinder
    extends AbstractUastVisitor {
        private final UExpression mExpression;
        private final UElement mEndElement;
        private final int mApi;
        private final JavaContext mContext;
        private boolean mFound = false;
        private boolean mDone = false;

        public VersionCheckWithExitFinder(UExpression expression2, UElement endElement, int api, JavaContext context) {
            this.mExpression = expression2;
            this.mEndElement = endElement;
            this.mApi = api;
            this.mContext = context;
        }

        @Override
        public boolean visitElement(UElement node) {
            if (this.mDone) {
                return true;
            }
            if (node.equals(this.mEndElement)) {
                this.mDone = true;
            }
            return this.mDone || !this.mExpression.equals(node);
        }

        @Override
        public boolean visitIfExpression(UIfExpression ifStatement) {
            Boolean level;
            if (this.mDone) {
                return true;
            }
            UExpression thenBranch = ifStatement.getThenExpression();
            UExpression elseBranch = ifStatement.getElseExpression();
            if (thenBranch != null && (level = ApiDetector.isVersionCheckConditional(this.mApi, thenBranch, ifStatement, this.mContext)) != null && ApiDetector.isUnconditionalReturn(thenBranch)) {
                this.mFound = true;
                this.mDone = true;
            }
            if (elseBranch != null && (level = ApiDetector.isVersionCheckConditional(this.mApi, elseBranch, ifStatement, this.mContext)) != null && ApiDetector.isUnconditionalReturn(elseBranch)) {
                this.mFound = true;
                this.mDone = true;
            }
            return true;
        }

        public boolean found() {
            return this.mFound;
        }
    }

    private static class ApiCheckGraph
    extends ControlFlowGraph {
        private final int mRequiredApi;

        public ApiCheckGraph(int requiredApi) {
            this.mRequiredApi = requiredApi;
        }

        @Override
        protected void add(@NonNull AbstractInsnNode from, @NonNull AbstractInsnNode to) {
            IntInsnNode intNode;
            if (from.getType() == 7 && from.getPrevious() != null && from.getPrevious().getType() == 1 && (intNode = (IntInsnNode)from.getPrevious()).getPrevious() != null && ApiDetector.isSdkVersionLookup(intNode.getPrevious())) {
                boolean includeEdge;
                JumpInsnNode jumpNode = (JumpInsnNode)from;
                int api = intNode.operand;
                boolean isJumpEdge = to == jumpNode.label;
                switch (from.getOpcode()) {
                    case 160: {
                        includeEdge = api < this.mRequiredApi || isJumpEdge;
                        break;
                    }
                    case 164: {
                        includeEdge = api < this.mRequiredApi - 1 || isJumpEdge;
                        break;
                    }
                    case 161: {
                        includeEdge = api < this.mRequiredApi || isJumpEdge;
                        break;
                    }
                    case 162: {
                        includeEdge = api < this.mRequiredApi || !isJumpEdge;
                        break;
                    }
                    case 163: {
                        includeEdge = api < this.mRequiredApi - 1 || !isJumpEdge;
                        break;
                    }
                    default: {
                        includeEdge = true;
                    }
                }
                if (!includeEdge) {
                    return;
                }
            }
            super.add(from, to);
        }
    }

    private final class ApiVisitor
    extends AbstractUastVisitor {
        private final JavaContext mContext;

        private ApiVisitor(JavaContext context) {
            this.mContext = context;
        }

        @Override
        public boolean visitImportStatement(UImportStatement statement) {
            PsiElement resolved;
            if (!statement.isOnDemand() && (resolved = statement.resolve()) instanceof PsiField) {
                this.checkField(statement, (PsiField)resolved);
            }
            return super.visitImportStatement(statement);
        }

        @Override
        public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
            PsiElement resolved = node.resolve();
            if (resolved instanceof PsiField) {
                this.checkField(node, (PsiField)resolved);
            }
            return super.visitSimpleNameReferenceExpression(node);
        }

        @Override
        public boolean visitBinaryExpressionWithType(UBinaryExpressionWithType node) {
            if (UastExpressionUtils.isTypeCast(node)) {
                this.visitTypeCastExpression(node);
            }
            return super.visitBinaryExpressionWithType(node);
        }

        private void visitTypeCastExpression(UBinaryExpressionWithType expression2) {
            UExpression operand2 = expression2.getOperand();
            PsiType operandType = operand2.getExpressionType();
            PsiType castType = expression2.getType();
            if (castType.equals(operandType)) {
                return;
            }
            if (!(operandType instanceof PsiClassType)) {
                return;
            }
            if (!(castType instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)operandType;
            PsiClassType interfaceType = (PsiClassType)castType;
            this.checkCast(expression2, classType, interfaceType);
        }

        private void checkCast(@NonNull UElement node, @NonNull PsiClassType classType, @NonNull PsiClassType interfaceType) {
            if (classType.equals((Object)interfaceType)) {
                return;
            }
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            String classTypeInternal = evaluator.getInternalName(classType);
            String interfaceTypeInternal = evaluator.getInternalName(interfaceType);
            if ("java/lang/Object".equals(interfaceTypeInternal)) {
                return;
            }
            int api = ApiDetector.this.mApiDatabase.getValidCastVersion(classTypeInternal, interfaceTypeInternal);
            if (api == -1) {
                return;
            }
            int minSdk = ApiDetector.this.getMinSdk(this.mContext);
            if (api <= minSdk) {
                return;
            }
            if (ApiDetector.isSuppressed(api, node, minSdk, this.mContext)) {
                return;
            }
            Location location = this.mContext.getUastLocation(node);
            String message2 = String.format("Cast from %1$s to %2$s requires API level %3$d (current min is %4$d)", UastLintUtils.getClassName(classType), UastLintUtils.getClassName(interfaceType), api, minSdk);
            this.mContext.report(UNSUPPORTED, location, message2);
        }

        @Override
        public boolean visitMethod(UMethod method) {
            int minSdk;
            int api;
            if (method.getModifierList().hasExplicitModifier("default") && !ApiDetector.isSuppressed(api = 24, method, minSdk = ApiDetector.this.getMinSdk(this.mContext), this.mContext)) {
                Location location = this.mContext.getLocation((PsiElement)method);
                String message2 = String.format("Default method requires API level %1$d (current min is %2$d)", api, minSdk);
                this.mContext.reportUast(UNSUPPORTED, method, location, message2);
            }
            return super.visitMethod(method);
        }

        @Override
        public boolean visitClass(UClass aClass) {
            PsiModifierList modifierList;
            if (aClass.isAnnotationType() && (modifierList = aClass.getModifierList()) != null) {
                for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                    PsiNameValuePair[] attributes;
                    String name = annotation.getQualifiedName();
                    if ("java.lang.annotation.Repeatable".equals(name)) {
                        int api = 24;
                        int minSdk = ApiDetector.this.getMinSdk(this.mContext);
                        if (ApiDetector.isSuppressed(api, aClass, minSdk, this.mContext)) continue;
                        Location location = this.mContext.getLocation((PsiElement)annotation);
                        String message2 = String.format("Repeatable annotation requires API level %1$d (current min is %2$d)", api, minSdk);
                        this.mContext.report(UNSUPPORTED, (PsiElement)annotation, location, message2);
                        continue;
                    }
                    if (!"java.lang.annotation.Target".equals(name)) continue;
                    for (PsiNameValuePair pair : attributes = annotation.getParameterList().getAttributes()) {
                        PsiAnnotationMemberValue value2 = pair.getValue();
                        if (value2 instanceof PsiArrayInitializerMemberValue) {
                            PsiArrayInitializerMemberValue array = (PsiArrayInitializerMemberValue)value2;
                            for (PsiAnnotationMemberValue t : array.getInitializers()) {
                                this.checkAnnotationTarget(t, modifierList);
                            }
                            continue;
                        }
                        if (value2 == null) continue;
                        this.checkAnnotationTarget(value2, modifierList);
                    }
                }
            }
            return super.visitClass(aClass);
        }

        private void checkAnnotationTarget(@NonNull PsiAnnotationMemberValue element, PsiModifierList modifierList) {
            PsiAnnotation retention;
            UReferenceExpression ref;
            String referenceName;
            if (element instanceof UReferenceExpression && ("TYPE_PARAMETER".equals(referenceName = UastLintUtils.getReferenceName(ref = (UReferenceExpression)element)) || "TYPE_USE".equals(referenceName)) && ((retention = modifierList.findAnnotation("java.lang.annotation.Retention")) == null || retention.getText().contains("RUNTIME"))) {
                Location location = this.mContext.getLocation((PsiElement)element);
                String message2 = String.format("Type annotations are not supported in Android: %1$s", referenceName);
                this.mContext.report(UNSUPPORTED, (PsiElement)element, location, message2);
            }
        }

        @Override
        public boolean visitCallExpression(UCallExpression expression2) {
            PsiMethod method = expression2.resolve();
            if (method != null) {
                PsiClass containingClass;
                PsiModifierList modifierList;
                List<UAnnotation> annotations2;
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() > 0) {
                    PsiParameter[] parameters2 = parameterList.getParameters();
                    List<UExpression> arguments = expression2.getValueArguments();
                    for (int i = 0; i < parameters2.length; ++i) {
                        PsiType parameterType = parameters2[i].getType();
                        if (!(parameterType instanceof PsiClassType)) continue;
                        if (i >= arguments.size()) break;
                        UExpression argument = arguments.get(i);
                        PsiType argumentType = argument.getExpressionType();
                        if (argumentType == null || parameterType.equals(argumentType) || !(argumentType instanceof PsiClassType)) continue;
                        this.checkCast(argument, (PsiClassType)argumentType, (PsiClassType)parameterType);
                    }
                }
                if (!this.checkRequiresApi(expression2, method, annotations2 = JavaUAnnotation.wrap((modifierList = method.getModifierList()).getAnnotations())) && (containingClass = method.getContainingClass()) != null && (modifierList = containingClass.getModifierList()) != null) {
                    this.checkRequiresApi(expression2, method, annotations2);
                }
            }
            return super.visitCallExpression(expression2);
        }

        private boolean checkRequiresApi(UCallExpression expression2, PsiMethod method, List<UAnnotation> annotations2) {
            for (UAnnotation annotation : annotations2) {
                int target;
                int minSdk;
                if (!ApiDetector.REQUIRES_API_ANNOTATION.equals(annotation.getQualifiedName())) continue;
                int api = (int)SupportAnnotationDetector.getLongAttribute(annotation, "value", -1L);
                if (api <= 1) {
                    api = (int)SupportAnnotationDetector.getLongAttribute(annotation, "api", -1L);
                }
                if (api > (minSdk = ApiDetector.this.getMinSdk(this.mContext)) && ((target = ApiDetector.getTargetApi(expression2)) == -1 || api > target)) {
                    if (ApiDetector.isWithinVersionCheckConditional(expression2, api, this.mContext)) {
                        return true;
                    }
                    if (ApiDetector.isPrecededByVersionCheckExit(expression2, api, this.mContext)) {
                        return true;
                    }
                    Location location = this.mContext.getUastLocation(expression2);
                    String fqcn = method.getName();
                    String message2 = String.format("Call requires API level %1$d (current min is %2$d): `%3$s`", api, minSdk, fqcn);
                    this.mContext.report(UNSUPPORTED, location, message2);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean visitVariable(UVariable node) {
            if (node instanceof ULocalVariable) {
                this.visitLocalVariable((ULocalVariable)node);
            }
            return super.visitVariable(node);
        }

        private void visitLocalVariable(ULocalVariable variable2) {
            UExpression initializer = variable2.getUastInitializer();
            if (initializer == null) {
                return;
            }
            PsiType initializerType = initializer.getExpressionType();
            if (!(initializerType instanceof PsiClassType)) {
                return;
            }
            PsiType interfaceType = variable2.getType();
            if (initializerType.equals(interfaceType)) {
                return;
            }
            if (!(interfaceType instanceof PsiClassType)) {
                return;
            }
            this.checkCast(initializer, (PsiClassType)initializerType, (PsiClassType)interfaceType);
        }

        @Override
        public boolean visitBinaryExpression(UBinaryExpression node) {
            if (UastExpressionUtils.isAssignment(node)) {
                this.visitAssignmentExpression(node);
            }
            return super.visitBinaryExpression(node);
        }

        private void visitAssignmentExpression(UBinaryExpression expression2) {
            UExpression rExpression = expression2.getRightOperand();
            PsiType rhsType = rExpression.getExpressionType();
            if (!(rhsType instanceof PsiClassType)) {
                return;
            }
            PsiType interfaceType = expression2.getLeftOperand().getExpressionType();
            if (rhsType.equals(interfaceType)) {
                return;
            }
            if (!(interfaceType instanceof PsiClassType)) {
                return;
            }
            this.checkCast(rExpression, (PsiClassType)rhsType, (PsiClassType)interfaceType);
        }

        @Override
        public boolean visitTryExpression(UTryExpression statement) {
            String message2;
            int minSdk;
            int api;
            List<PsiResourceListElement> resourceList = statement.getResources();
            if (!resourceList.isEmpty() && (api = 19) > (minSdk = ApiDetector.this.getMinSdk(this.mContext)) && api > ApiDetector.getTargetApi(statement)) {
                Location location = this.mContext.getUastLocation(statement);
                message2 = String.format("Try-with-resources requires API level %1$d (current min is %2$d)", api, minSdk);
                LintDriver driver = this.mContext.getDriver();
                if (!driver.isSuppressed(this.mContext, UNSUPPORTED, statement)) {
                    this.mContext.report(UNSUPPORTED, statement, location, message2);
                }
            }
            for (UCatchClause catchClause : statement.getCatchClauses()) {
                int minSdk2 = ApiDetector.this.getMinSdk(this.mContext);
                if (minSdk2 < 19 && this.isMultiCatchReflectiveOperationException(catchClause)) {
                    message2 = String.format("Multi-catch with these reflection exceptions requires API level 19 (current min is %d) because they get compiled to the common but new super type `ReflectiveOperationException`. As a workaround either create individual catch statements, or catch `Exception`.", minSdk2);
                    this.mContext.report(UNSUPPORTED, this.getCatchParametersLocation(this.mContext, catchClause), message2);
                    continue;
                }
                for (UTypeReferenceExpression typeReference2 : catchClause.getTypeReferences()) {
                    this.checkCatchTypeElement(statement, typeReference2, typeReference2.getType());
                }
            }
            return super.visitTryExpression(statement);
        }

        private Location getCatchParametersLocation(JavaContext context, UCatchClause catchClause) {
            List<UTypeReferenceExpression> types = catchClause.getTypeReferences();
            if (types.isEmpty()) {
                return Location.NONE;
            }
            Location first = context.getUastLocation(types.get(0));
            if (types.size() < 2) {
                return first;
            }
            Location last = context.getUastLocation(types.get(types.size() - 1));
            File file = first.getFile();
            Position start = first.getStart();
            Position end = last.getEnd();
            if (start == null) {
                return Location.create(file);
            }
            return Location.create(file, start, end);
        }

        private boolean isMultiCatchReflectiveOperationException(UCatchClause catchClause) {
            List<PsiType> types = catchClause.getTypes();
            if (types.size() < 2) {
                return false;
            }
            for (PsiType t : types) {
                if (this.isSubclassOfReflectiveOperationException(t)) continue;
                return false;
            }
            return true;
        }

        private boolean isSubclassOfReflectiveOperationException(PsiType type2) {
            for (PsiType t : type2.getSuperTypes()) {
                if (!ApiDetector.REFLECTIVE_OPERATION_EXCEPTION.equals(t.getCanonicalText())) continue;
                return true;
            }
            return false;
        }

        private void checkCatchTypeElement(@NonNull UTryExpression statement, @NonNull UTypeReferenceExpression typeReference2, @Nullable PsiType type2) {
            PsiClass resolved = null;
            if (type2 instanceof PsiClassType) {
                resolved = ((PsiClassType)type2).resolve();
            }
            if (resolved != null) {
                String signature = this.mContext.getEvaluator().getInternalName(resolved);
                int api = ApiDetector.this.mApiDatabase.getClassVersion(signature);
                if (api == -1) {
                    return;
                }
                int minSdk = ApiDetector.this.getMinSdk(this.mContext);
                if (api <= minSdk) {
                    return;
                }
                int target = ApiDetector.getTargetApi(statement);
                if (target != -1 && api <= target) {
                    return;
                }
                Location location = this.mContext.getUastLocation(typeReference2);
                String fqcn = resolved.getQualifiedName();
                String message2 = String.format("Class requires API level %1$d (current min is %2$d): %3$s", api, minSdk, fqcn);
                this.mContext.report(UNSUPPORTED, location, message2);
            }
        }

        private boolean checkField(@NonNull UElement node, @NonNull PsiField field) {
            PsiType type2 = field.getType();
            if (!(type2 instanceof PsiPrimitiveType) && !LintUtils.isString(type2)) {
                return false;
            }
            String name = field.getName();
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null || name == null) {
                return false;
            }
            String owner = this.mContext.getEvaluator().getInternalName(containingClass);
            int api = ApiDetector.this.mApiDatabase.getFieldVersion(owner, name);
            if (api != -1) {
                int minSdk = ApiDetector.this.getMinSdk(this.mContext);
                if (api > minSdk && api > ApiDetector.getTargetApi(node)) {
                    LintDriver driver;
                    UElement reference;
                    if (ApiDetector.isBenignConstantUsage(node, name, owner)) {
                        return true;
                    }
                    String fqcn = ClassContext.getFqcn(owner) + '#' + name;
                    if (node instanceof UImportStatement && (reference = ((UImportStatement)node).getImportReference()) != null) {
                        node = reference;
                    }
                    if ((driver = this.mContext.getDriver()).isSuppressed(this.mContext, INLINED, node)) {
                        return true;
                    }
                    if (driver.isSuppressed(this.mContext, UNSUPPORTED, node)) {
                        return true;
                    }
                    if (ApiDetector.isWithinVersionCheckConditional(node, api, this.mContext)) {
                        return true;
                    }
                    if (ApiDetector.isPrecededByVersionCheckExit(node, api, this.mContext)) {
                        return true;
                    }
                    String message2 = String.format("Field requires API level %1$d (current min is %2$d): `%3$s`", api, minSdk, fqcn);
                    Location location = this.mContext.getUastLocation(node);
                    this.mContext.report(INLINED, node, location, message2);
                }
                return true;
            }
            return false;
        }
    }
}

