/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.checks.ApiDetector;
import com.android.tools.klint.checks.PermissionRequirement;
import com.android.tools.klint.checks.SupportAnnotationDetector;
import com.android.tools.klint.client.api.ExternalReferenceExpression;
import com.android.tools.klint.client.api.IssueRegistry;
import com.android.tools.klint.client.api.UastLintUtils;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.ConstantEvaluator;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UVariableDeclarationsExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UReferenceExpression;
import org.jetbrains.uast.java.JavaUAnnotation;
import org.jetbrains.uast.java.JavaUTypeCastExpression;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class AnnotationDetector
extends Detector
implements Detector.UastScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(AnnotationDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue INSIDE_METHOD = Issue.create("LocalSuppress", "@SuppressLint on invalid element", "The `@SuppressAnnotation` is used to suppress Lint warnings in Java files. However, while many lint checks analyzes the Java source code, where they can find annotations on (for example) local variables, some checks are analyzing the `.class` files. And in class files, annotations only appear on classes, fields and methods. Annotations placed on local variables disappear. If you attempt to suppress a lint error for a class-file based lint check, the suppress annotation not work. You must move the annotation out to the surrounding method.", Category.CORRECTNESS, 3, Severity.ERROR, IMPLEMENTATION);
    public static final Issue ANNOTATION_USAGE = Issue.create("SupportAnnotationUsage", "Incorrect support annotation usage", "This lint check makes sure that the support annotations (such as `@IntDef` and `@ColorInt`) are used correctly. For example, it's an error to specify an `@IntRange` where the `from` value is higher than the `to` value.", Category.CORRECTNESS, 2, Severity.ERROR, IMPLEMENTATION);
    public static final Issue UNIQUE = Issue.create("UniqueConstants", "Overlapping Enumeration Constants", "The `@IntDef` annotation allows you to create a light-weight \"enum\" or type definition. However, it's possible to accidentally specify the same value for two or more of the values, which can lead to hard-to-detect bugs. This check looks for this scenario and flags any repeated constants.\n\nIn some cases, the repeated constant is intentional (for example, renaming a constant to a more intuitive name, and leaving the old name in place for compatibility purposes.)  In that case, simply suppress this check by adding a `@SuppressLint(\"UniqueConstants\")` annotation.", Category.CORRECTNESS, 3, Severity.ERROR, IMPLEMENTATION);
    public static final Issue FLAG_STYLE = Issue.create("ShiftFlags", "Dangerous Flag Constant Declaration", "When defining multiple constants for use in flags, the recommended style is to use the form `1 << 2`, `1 << 3`, `1 << 4` and so on to ensure that the constants are unique and non-overlapping.", Category.CORRECTNESS, 3, Severity.WARNING, IMPLEMENTATION);
    public static final Issue SWITCH_TYPE_DEF = Issue.create("SwitchIntDef", "Missing @IntDef in Switch", "This check warns if a `switch` statement does not explicitly include all the values declared by the typedef `@IntDef` declaration.", Category.CORRECTNESS, 3, Severity.WARNING, IMPLEMENTATION);
    private Set<PsiElement> mWarnedFlags;

    @Override
    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        ArrayList<Class<? extends UElement>> types = new ArrayList<Class<? extends UElement>>(2);
        types.add(UAnnotation.class);
        types.add(USwitchExpression.class);
        return types;
    }

    @Override
    @Nullable
    public UastVisitor createUastVisitor(@NonNull JavaContext context) {
        return new AnnotationChecker(context);
    }

    private static List<String> computeFieldNames(@NonNull USwitchExpression node, Iterable<?> allowedValues) {
        ArrayList list = Lists.newArrayList();
        for (Object o : allowedValues) {
            PsiClass containingClass;
            if (o instanceof ExternalReferenceExpression) {
                ExternalReferenceExpression externalRef = (ExternalReferenceExpression)o;
                PsiElement resolved = UastLintUtils.resolve(externalRef, node);
                if (resolved != null) {
                    o = resolved;
                }
            } else if (o instanceof PsiReferenceExpression) {
                PsiElement resolved = ((PsiReferenceExpression)o).resolve();
                if (resolved != null) {
                    o = resolved;
                }
            } else if (o instanceof PsiLiteral) {
                list.add("`" + ((PsiLiteral)o).getValue() + '`');
                continue;
            }
            if (!(o instanceof PsiField)) continue;
            PsiField field = (PsiField)o;
            String name = field.getName();
            UClass clz = (UClass)UastUtils.getParentOfType(node, UClass.class, true);
            if (clz != null && (containingClass = field.getContainingClass()) != null && !containingClass.equals(clz.getPsi())) {
                name = containingClass.getName() + '.' + field.getName();
            }
            list.add('`' + name + '`');
        }
        Collections.sort(list);
        return list;
    }

    @NonNull
    private static UElement getAnnotationScope(@NonNull UAnnotation node) {
        Object scope = UastUtils.getParentOfType(node, UAnnotation.class, true);
        if (scope == null) {
            scope = node;
        }
        return scope;
    }

    private class AnnotationChecker
    extends AbstractUastVisitor {
        private final JavaContext mContext;

        private AnnotationChecker(JavaContext context) {
            this.mContext = context;
        }

        @Override
        public boolean visitAnnotation(@NonNull UAnnotation annotation) {
            block13: {
                PsiClass cls;
                String type2;
                block15: {
                    block23: {
                        int set;
                        block24: {
                            block22: {
                                block21: {
                                    block18: {
                                        long min;
                                        long exact;
                                        int unset;
                                        block20: {
                                            long multiple;
                                            block19: {
                                                block17: {
                                                    boolean invalid;
                                                    block16: {
                                                        UMethod method;
                                                        block12: {
                                                            UExpression value2;
                                                            block14: {
                                                                type2 = annotation.getQualifiedName();
                                                                if (type2 == null || type2.startsWith("java.lang.")) {
                                                                    return false;
                                                                }
                                                                if (!"android.annotation.SuppressLint".equals(type2)) break block12;
                                                                UElement parent = annotation.getContainingElement();
                                                                if (parent == null) {
                                                                    return false;
                                                                }
                                                                if (!(parent instanceof UVariableDeclarationsExpression || parent instanceof ULocalVariable || parent instanceof UParameter)) {
                                                                    return false;
                                                                }
                                                                List<UNamedExpression> attributes = annotation.getAttributeValues();
                                                                if (attributes.size() != 1) break block13;
                                                                UNamedExpression attribute = attributes.get(0);
                                                                value2 = attribute.getExpression();
                                                                if (!(value2 instanceof ULiteralExpression)) break block14;
                                                                Object v = ((ULiteralExpression)value2).getValue();
                                                                if (!(v instanceof String)) break block13;
                                                                String id = (String)v;
                                                                this.checkSuppressLint(annotation, id);
                                                                break block13;
                                                            }
                                                            if (!(value2 instanceof PsiArrayInitializerMemberValue)) break block13;
                                                            PsiArrayInitializerMemberValue initializer = (PsiArrayInitializerMemberValue)value2;
                                                            for (PsiAnnotationMemberValue expression2 : initializer.getInitializers()) {
                                                                String id;
                                                                Object v;
                                                                if (!(expression2 instanceof PsiLiteral) || !((v = ((PsiLiteral)expression2).getValue()) instanceof String) || this.checkSuppressLint(annotation, id = (String)v)) continue;
                                                                return false;
                                                            }
                                                            break block13;
                                                        }
                                                        if (!type2.startsWith("android.support.annotation.")) break block15;
                                                        if (!"android.support.annotation.CheckResult".equals(type2)) break block16;
                                                        if (!(annotation.getContainingElement() instanceof UMethod) || (method = (UMethod)annotation.getContainingElement()).isConstructor() || !PsiType.VOID.equals((Object)method.getReturnType())) break block13;
                                                        this.mContext.report(ANNOTATION_USAGE, annotation.getPsi(), this.mContext.getLocation(annotation.getPsi()), "@CheckResult should not be specified on `void` methods");
                                                        break block13;
                                                    }
                                                    if (!"android.support.annotation.IntRange".equals(type2) && !"android.support.annotation.FloatRange".equals(type2)) break block17;
                                                    if ("android.support.annotation.IntRange".equals(type2)) {
                                                        this.checkTargetType(annotation, "int", "long", true);
                                                        long from = SupportAnnotationDetector.getLongAttribute(annotation, "from", Long.MIN_VALUE);
                                                        long to = SupportAnnotationDetector.getLongAttribute(annotation, "to", Long.MAX_VALUE);
                                                        invalid = from > to;
                                                    } else {
                                                        this.checkTargetType(annotation, "float", "double", true);
                                                        double from = SupportAnnotationDetector.getDoubleAttribute(annotation, "from", Double.NEGATIVE_INFINITY);
                                                        double to = SupportAnnotationDetector.getDoubleAttribute(annotation, "to", Double.POSITIVE_INFINITY);
                                                        boolean bl = invalid = from > to;
                                                    }
                                                    if (!invalid) break block13;
                                                    this.mContext.report(ANNOTATION_USAGE, annotation.getPsi(), this.mContext.getLocation(annotation.getPsi()), "Invalid range: the `from` attribute must be less than the `to` attribute");
                                                    break block13;
                                                }
                                                if (!"android.support.annotation.Size".equals(type2)) break block18;
                                                unset = -42;
                                                exact = SupportAnnotationDetector.getLongAttribute(annotation, "value", unset);
                                                min = SupportAnnotationDetector.getLongAttribute(annotation, "min", Long.MIN_VALUE);
                                                long max = SupportAnnotationDetector.getLongAttribute(annotation, "max", Long.MAX_VALUE);
                                                multiple = SupportAnnotationDetector.getLongAttribute(annotation, "multiple", 1L);
                                                if (min <= max) break block19;
                                                this.mContext.report(ANNOTATION_USAGE, annotation.getPsi(), this.mContext.getLocation(annotation.getPsi()), "Invalid size range: the `min` attribute must be less than the `max` attribute");
                                                break block13;
                                            }
                                            if (multiple >= 1L) break block20;
                                            this.mContext.report(ANNOTATION_USAGE, annotation.getPsi(), this.mContext.getLocation(annotation.getPsi()), "The size multiple must be at least 1");
                                            break block13;
                                        }
                                        if ((exact >= 0L || exact == (long)unset) && (min >= 0L || min == Long.MIN_VALUE)) break block13;
                                        this.mContext.report(ANNOTATION_USAGE, annotation.getPsi(), this.mContext.getLocation(annotation.getPsi()), "The size can't be negative");
                                        break block13;
                                    }
                                    if (!"android.support.annotation.ColorInt".equals(type2) && !"android.support.annotation.Px".equals(type2)) break block21;
                                    this.checkTargetType(annotation, "int", "long", true);
                                    break block13;
                                }
                                if (!"android.support.annotation.IntDef".equals(type2)) break block22;
                                this.ensureUniqueValues(annotation);
                                break block13;
                            }
                            if (!"android.support.annotation.RequiresPermission".equals(type2) && !"android.support.annotation.RequiresPermission.Read".equals(type2) && !"android.support.annotation.RequiresPermission.Write".equals(type2)) break block23;
                            if (!(annotation.getContainingElement() instanceof UMethod)) break block13;
                            String value3 = PermissionRequirement.getAnnotationStringValue(annotation, "value");
                            String[] anyOf = PermissionRequirement.getAnnotationStringValues(annotation, "anyOf");
                            String[] allOf = PermissionRequirement.getAnnotationStringValues(annotation, "allOf");
                            set = 0;
                            if (value3 != null) {
                                ++set;
                            }
                            if (allOf != null) {
                                ++set;
                            }
                            if (anyOf != null) {
                                ++set;
                            }
                            if (set != 0) break block24;
                            this.mContext.report(ANNOTATION_USAGE, annotation.getPsi(), this.mContext.getLocation(annotation.getPsi()), "For methods, permission annotation should specify one of `value`, `anyOf` or `allOf`");
                            break block13;
                        }
                        if (set <= 1) break block13;
                        this.mContext.report(ANNOTATION_USAGE, annotation.getPsi(), this.mContext.getLocation(annotation.getPsi()), "Only specify one of `value`, `anyOf` or `allOf`");
                        break block13;
                    }
                    if (!type2.endsWith("Res")) break block13;
                    this.checkTargetType(annotation, "int", "long", true);
                    break block13;
                }
                PsiClass resolved = annotation.resolve();
                if (resolved != null && (cls = resolved).isAnnotationType() && cls.getModifierList() != null) {
                    for (PsiAnnotation a : cls.getModifierList().getAnnotations()) {
                        String name = a.getQualifiedName();
                        if ("android.support.annotation.IntDef".equals(name)) {
                            this.checkTargetType(annotation, "int", "long", true);
                            continue;
                        }
                        if (!"android.support.annotation.StringDef".equals(type2)) continue;
                        this.checkTargetType(annotation, "java.lang.String", null, true);
                    }
                }
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void checkTargetType(@NonNull UAnnotation node, @NonNull String type1, @Nullable String type2, boolean allowCollection) {
            String expectedTypes;
            String typeName;
            PsiType type3;
            UElement parent = node.getContainingElement();
            if (parent instanceof UVariableDeclarationsExpression) {
                List<UVariable> elements = ((UVariableDeclarationsExpression)parent).getVariables();
                if (elements.isEmpty()) return;
                UVariable element = elements.get(0);
                if (!(element instanceof ULocalVariable)) return;
                type3 = element.getType();
            } else if (parent instanceof UMethod) {
                UMethod method = (UMethod)parent;
                type3 = method.isConstructor() ? this.mContext.getEvaluator().getClassType(method.getContainingClass()) : method.getReturnType();
            } else {
                if (!(parent instanceof UVariable)) return;
                type3 = ((UVariable)parent).getType();
            }
            if (type3 == null) {
                return;
            }
            if (allowCollection) {
                PsiClass resolved;
                PsiClassType classType;
                if (type3 instanceof PsiArrayType) {
                    type3 = type3.getDeepComponentType();
                } else if (type3 instanceof PsiClassType && (classType = (PsiClassType)type3).getParameters().length == 1 && (resolved = classType.resolve()) != null && InheritanceUtil.isInheritor((PsiClass)resolved, (boolean)false, (String)"java.util.Collection")) {
                    type3 = classType.getParameters()[0];
                }
            }
            if ((typeName = type3.getCanonicalText()).equals(type1) || type2 != null && typeName.equals(type2)) return;
            if (typeName.equals(LintUtils.getAutoBoxedType(type1)) || type2 != null && typeName.equals(LintUtils.getAutoBoxedType(type2))) {
                return;
            }
            String string = expectedTypes = type2 == null ? type1 : type1 + " or " + type2;
            if (typeName.equals("java.lang.String")) {
                typeName = "String";
            }
            String message2 = String.format("This annotation does not apply for type %1$s; expected %2$s", typeName, expectedTypes);
            Location location = this.mContext.getUastLocation(node);
            this.mContext.report(ANNOTATION_USAGE, node, location, message2);
        }

        @Override
        public boolean visitSwitchExpression(USwitchExpression switchExpression) {
            UAnnotation annotation;
            UExpression condition2 = switchExpression.getExpression();
            if (condition2 != null && PsiType.INT.equals((Object)condition2.getExpressionType()) && (annotation = this.findIntDefAnnotation(condition2)) != null) {
                UExpression value2;
                UNamedExpression namedValue = annotation.findDeclaredAttributeValue("value");
                if (namedValue == null) {
                    namedValue = annotation.findDeclaredAttributeValue(null);
                }
                UExpression uExpression = value2 = namedValue != null ? namedValue.getExpression() : null;
                if (UastExpressionUtils.isArrayInitializer(value2)) {
                    List<UExpression> allowedValues = ((UCallExpression)value2).getValueArguments();
                    switchExpression.accept(new SwitchChecker(switchExpression, allowedValues));
                }
            }
            return false;
        }

        @Nullable
        private Integer getConstantValue(@NonNull PsiField intDefConstantRef) {
            Object constant = intDefConstantRef.computeConstantValue();
            if (constant instanceof Number) {
                return ((Number)constant).intValue();
            }
            return null;
        }

        @Nullable
        private UAnnotation findIntDefAnnotation(@NonNull UExpression expression2) {
            if (expression2 instanceof UReferenceExpression) {
                PsiLocalVariable variable2;
                UExpression lastAssignment;
                PsiElement resolved = ((UReferenceExpression)expression2).resolve();
                if (resolved instanceof PsiModifierListOwner) {
                    PsiAnnotation[] annotations2 = this.mContext.getEvaluator().getAllAnnotations((PsiModifierListOwner)resolved);
                    PsiAnnotation[] relevantAnnotations = SupportAnnotationDetector.filterRelevantAnnotations(this.mContext.getEvaluator(), annotations2);
                    UAnnotation annotation = SupportAnnotationDetector.findIntDef(JavaUAnnotation.wrap(relevantAnnotations));
                    if (annotation != null) {
                        return annotation;
                    }
                }
                if (resolved instanceof PsiLocalVariable && (lastAssignment = UastLintUtils.findLastAssignment((PsiVariable)(variable2 = (PsiLocalVariable)resolved), expression2, this.mContext)) != null) {
                    return this.findIntDefAnnotation(lastAssignment);
                }
            } else if (expression2 instanceof UCallExpression) {
                PsiMethod method = ((UCallExpression)expression2).resolve();
                if (method != null) {
                    PsiAnnotation[] annotations3 = this.mContext.getEvaluator().getAllAnnotations((PsiModifierListOwner)method);
                    PsiAnnotation[] relevantAnnotations = SupportAnnotationDetector.filterRelevantAnnotations(this.mContext.getEvaluator(), annotations3);
                    List<UAnnotation> uAnnotations = JavaUAnnotation.wrap(relevantAnnotations);
                    UAnnotation annotation = SupportAnnotationDetector.findIntDef(uAnnotations);
                    if (annotation != null) {
                        return annotation;
                    }
                }
            } else if (expression2 instanceof UIfExpression) {
                UAnnotation result;
                UIfExpression ifExpression = (UIfExpression)expression2;
                if (ifExpression.getThenExpression() != null && (result = this.findIntDefAnnotation(ifExpression.getThenExpression())) != null) {
                    return result;
                }
                if (ifExpression.getElseExpression() != null && (result = this.findIntDefAnnotation(ifExpression.getElseExpression())) != null) {
                    return result;
                }
            } else {
                if (expression2 instanceof JavaUTypeCastExpression) {
                    return this.findIntDefAnnotation(((JavaUTypeCastExpression)expression2).getOperand());
                }
                if (expression2 instanceof UParenthesizedExpression) {
                    return this.findIntDefAnnotation(((UParenthesizedExpression)expression2).getExpression());
                }
            }
            return null;
        }

        private void ensureUniqueValues(@NonNull UAnnotation node) {
            boolean flag;
            UNamedExpression namedValue = node.findAttributeValue("value");
            if (namedValue == null) {
                namedValue = node.findAttributeValue(null);
            }
            if (namedValue == null) {
                return;
            }
            UExpression value2 = namedValue.getExpression();
            if (!UastExpressionUtils.isArrayInitializer(value2)) {
                return;
            }
            PsiArrayInitializerMemberValue array = (PsiArrayInitializerMemberValue)value2;
            PsiAnnotationMemberValue[] initializers = array.getInitializers();
            HashMap valueToIndex = Maps.newHashMapWithExpectedSize((int)initializers.length);
            boolean bl = flag = PermissionRequirement.getAnnotationBooleanValue(node, "flag") == Boolean.TRUE;
            if (flag) {
                this.ensureUsingFlagStyle(initializers);
            }
            ConstantEvaluator constantEvaluator = new ConstantEvaluator(this.mContext);
            for (int index = 0; index < initializers.length; ++index) {
                PsiAnnotationMemberValue expression2 = initializers[index];
                Object o = constantEvaluator.evaluate((PsiElement)expression2);
                if (!(o instanceof Number)) continue;
                Number number = (Number)o;
                if (valueToIndex.containsKey(number)) {
                    Number repeatedValue = number;
                    int prevIndex = (Integer)valueToIndex.get(number);
                    PsiAnnotationMemberValue prevConstant = initializers[prevIndex];
                    String message2 = String.format("Constants `%1$s` and `%2$s` specify the same exact value (%3$s); this is usually a cut & paste or merge error", expression2.getText(), prevConstant.getText(), repeatedValue.toString());
                    Location location = this.mContext.getLocation((PsiElement)expression2);
                    Location secondary = this.mContext.getLocation((PsiElement)prevConstant);
                    secondary.setMessage("Previous same value");
                    location.setSecondary(secondary);
                    UElement scope = AnnotationDetector.getAnnotationScope(node);
                    this.mContext.reportUast(UNIQUE, scope, location, message2);
                    break;
                }
                valueToIndex.put(number, index);
            }
        }

        private void ensureUsingFlagStyle(@NonNull PsiAnnotationMemberValue[] constants) {
            if (constants.length < 3) {
                return;
            }
            for (PsiAnnotationMemberValue constant : constants) {
                long value2;
                PsiLiteral literal;
                Object o;
                PsiExpression initializer;
                PsiElement resolved;
                if (!(constant instanceof PsiReferenceExpression) || !((resolved = ((PsiReferenceExpression)constant).resolve()) instanceof PsiField) || !((initializer = ((PsiField)resolved).getInitializer()) instanceof PsiLiteral) || !((o = (literal = (PsiLiteral)initializer).getValue()) instanceof Number) || Math.abs(value2 = ((Number)o).longValue()) <= 1L || Long.bitCount(value2) != 1) continue;
                int shift = Long.numberOfTrailingZeros(value2);
                if (AnnotationDetector.this.mWarnedFlags == null) {
                    AnnotationDetector.this.mWarnedFlags = Sets.newHashSet();
                }
                if (!AnnotationDetector.this.mWarnedFlags.add(resolved)) {
                    return;
                }
                String message2 = String.format("Consider declaring this constant using 1 << %1$d instead", shift);
                Location location = this.mContext.getLocation((PsiElement)initializer);
                this.mContext.report(FLAG_STYLE, (PsiElement)initializer, location, message2);
            }
        }

        private boolean checkSuppressLint(@NonNull UAnnotation node, @NonNull String id) {
            IssueRegistry registry = this.mContext.getDriver().getRegistry();
            Issue issue = registry.getIssue(id);
            if (issue != null && !issue.getImplementation().getScope().contains((Object)Scope.JAVA_FILE) || issue == ApiDetector.UNSUPPORTED) {
                UElement scope = AnnotationDetector.getAnnotationScope(node);
                this.mContext.report(INSIDE_METHOD, scope, this.mContext.getUastLocation(node), String.format("The `@SuppressLint` annotation cannot be used on a local variable with the lint check '%1$s': move out to the surrounding method", id));
                return false;
            }
            return true;
        }

        private class SwitchChecker
        extends AbstractUastVisitor {
            private final USwitchExpression mSwitchExpression;
            private final List<UExpression> mAllowedValues;
            private final List<Object> mFields;
            private final List<Integer> mSeenValues;
            private boolean mReported = false;

            private SwitchChecker(USwitchExpression switchExpression, List<UExpression> allowedValues) {
                this.mSwitchExpression = switchExpression;
                this.mAllowedValues = allowedValues;
                this.mFields = Lists.newArrayListWithCapacity((int)allowedValues.size());
                for (UExpression allowedValue : allowedValues) {
                    if (allowedValue instanceof ExternalReferenceExpression) {
                        ExternalReferenceExpression externalRef = (ExternalReferenceExpression)((Object)allowedValue);
                        PsiElement resolved = UastLintUtils.resolve(externalRef, switchExpression);
                        if (!(resolved instanceof PsiField)) continue;
                        this.mFields.add(resolved);
                        continue;
                    }
                    if (allowedValue instanceof UReferenceExpression) {
                        PsiElement resolved = ((UReferenceExpression)allowedValue).resolve();
                        if (resolved == null) continue;
                        this.mFields.add(resolved);
                        continue;
                    }
                    if (!(allowedValue instanceof ULiteralExpression)) continue;
                    this.mFields.add(allowedValue);
                }
                this.mSeenValues = Lists.newArrayListWithCapacity((int)allowedValues.size());
            }

            @Override
            public boolean visitSwitchClauseExpression(USwitchClauseExpression node) {
                if (this.mReported) {
                    return true;
                }
                if (this.mAllowedValues == null) {
                    return true;
                }
                List<UExpression> caseValues2 = node.getCaseValues();
                if (caseValues2 == null) {
                    return true;
                }
                for (UExpression caseValue : caseValues2) {
                    UExpression initializer;
                    if (caseValue instanceof ULiteralExpression) {
                        List list = AnnotationDetector.computeFieldNames(this.mSwitchExpression, Arrays.asList(this.mAllowedValues));
                        String message2 = "Don't use a constant here; expected one of: " + Joiner.on((String)", ").join((Iterable)list);
                        AnnotationChecker.this.mContext.report(SWITCH_TYPE_DEF, caseValue, AnnotationChecker.this.mContext.getUastLocation(caseValue), message2);
                        this.mReported = true;
                        continue;
                    }
                    if (!(caseValue instanceof UReferenceExpression)) continue;
                    PsiElement resolved = ((UReferenceExpression)caseValue).resolve();
                    if (resolved == null) {
                        return true;
                    }
                    if (!(resolved instanceof PsiField)) continue;
                    boolean found = false;
                    ListIterator<Object> iterator = this.mFields.listIterator();
                    while (iterator.hasNext()) {
                        Object field = iterator.next();
                        if (!field.equals(resolved)) continue;
                        iterator.remove();
                        found = true;
                        break;
                    }
                    if (!found && (initializer = AnnotationChecker.this.mContext.getUastContext().getInitializerBody((PsiVariable)((PsiField)resolved))) instanceof UReferenceExpression && (resolved = ((UReferenceExpression)initializer).resolve()) instanceof PsiField) {
                        iterator = this.mFields.listIterator();
                        while (iterator.hasNext()) {
                            Object field = iterator.next();
                            if (!field.equals(resolved)) continue;
                            iterator.remove();
                            found = true;
                            break;
                        }
                    }
                    if (found) {
                        Integer cv = AnnotationChecker.this.getConstantValue((PsiField)resolved);
                        if (cv == null) continue;
                        this.mSeenValues.add(cv);
                        continue;
                    }
                    List list = AnnotationDetector.computeFieldNames(this.mSwitchExpression, Collections.singletonList(this.mAllowedValues));
                    String message3 = "Unexpected constant; expected one of: " + Joiner.on((String)", ").join((Iterable)list);
                    Location location = AnnotationChecker.this.mContext.getUastNameLocation(caseValue);
                    AnnotationChecker.this.mContext.report(SWITCH_TYPE_DEF, caseValue, location, message3);
                }
                return true;
            }

            @Override
            public void afterVisitSwitchExpression(USwitchExpression node) {
                this.reportMissingSwitchCases();
                super.afterVisitSwitchExpression(node);
            }

            private void reportMissingSwitchCases() {
                if (this.mReported) {
                    return;
                }
                if (this.mAllowedValues == null) {
                    return;
                }
                if (!this.mFields.isEmpty()) {
                    ListIterator<Object> iterator = this.mFields.listIterator();
                    while (iterator.hasNext()) {
                        Integer cv;
                        Object next = iterator.next();
                        if (!(next instanceof PsiField) || !this.mSeenValues.contains(cv = AnnotationChecker.this.getConstantValue((PsiField)next))) continue;
                        iterator.remove();
                    }
                }
                if (!this.mFields.isEmpty()) {
                    List list = AnnotationDetector.computeFieldNames(this.mSwitchExpression, this.mFields);
                    String message2 = "Switch statement on an `int` with known associated constant missing case " + Joiner.on((String)", ").join((Iterable)list);
                    Location location = AnnotationChecker.this.mContext.getUastLocation(this.mSwitchExpression.getSwitchIdentifier());
                    AnnotationChecker.this.mContext.report(SWITCH_TYPE_DEF, this.mSwitchExpression, location, message2);
                }
            }
        }
    }
}

