/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.ConstantEvaluator;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.intellij.psi.PsiMember;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.UastVisitor;

public class AlarmDetector
extends Detector
implements Detector.UastScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(AlarmDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("ShortAlarm", "Short or Frequent Alarm", "Frequent alarms are bad for battery life. As of API 22, the `AlarmManager` will override near-future and high-frequency alarm requests, delaying the alarm at least 5 seconds into the future and ensuring that the repeat interval is at least 60 seconds.\n\nIf you really need to do work sooner than 5 seconds, post a delayed message or runnable to a Handler.", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("setRepeating");
    }

    @Override
    public void visitMethod(@NonNull JavaContext context, @Nullable UastVisitor visitor, @NonNull UCallExpression node, @NonNull UMethod method) {
        JavaEvaluator evaluator = context.getEvaluator();
        if (JavaEvaluator.isMemberInClass((PsiMember)method, "android.app.AlarmManager") && evaluator.getParameterCount(method) == 4) {
            AlarmDetector.ensureAtLeast(context, node, 1, 5000L);
            AlarmDetector.ensureAtLeast(context, node, 2, 60000L);
        }
    }

    private static void ensureAtLeast(@NonNull JavaContext context, @NonNull UCallExpression node, int parameter, long min) {
        UExpression argument = node.getValueArguments().get(parameter);
        long value2 = AlarmDetector.getLongValue(context, argument);
        if (value2 < min) {
            String message2 = String.format("Value will be forced up to %1$d as of Android 5.1; don't rely on this to be exact", min);
            context.report(ISSUE, argument, context.getUastLocation(argument), message2);
        }
    }

    private static long getLongValue(@NonNull JavaContext context, @NonNull UExpression argument) {
        Object value2 = ConstantEvaluator.evaluate(context, argument);
        if (value2 instanceof Number) {
            return ((Number)value2).longValue();
        }
        return Long.MAX_VALUE;
    }
}

