/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util.locks;

import com.jogamp.common.util.locks.Lock;
import java.io.File;
import jogamp.common.util.locks.SingletonInstanceFileLock;
import jogamp.common.util.locks.SingletonInstanceServerSocket;

public abstract class SingletonInstance
implements Lock {
    protected static final boolean DEBUG = true;
    private final long poll_ms;
    private boolean locked = false;

    public static SingletonInstance createFileLock(long l, String string) {
        return new SingletonInstanceFileLock(l, string);
    }

    public static SingletonInstance createFileLock(long l, File file) {
        return new SingletonInstanceFileLock(l, file);
    }

    public static SingletonInstance createServerSocket(long l, int n) {
        return new SingletonInstanceServerSocket(l, n);
    }

    protected SingletonInstance(long l) {
        this.poll_ms = Math.max(10L, l);
    }

    public final long getPollPeriod() {
        return this.poll_ms;
    }

    public abstract String getName();

    public final String toString() {
        return this.getName();
    }

    @Override
    public synchronized void lock() throws RuntimeException {
        try {
            while (!this.tryLock(TIMEOUT)) {
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException(runtimeException);
        }
    }

    @Override
    public synchronized boolean tryLock(long l) throws RuntimeException {
        String string;
        String string2;
        long l2;
        if (this.locked) {
            return true;
        }
        long l3 = System.currentTimeMillis();
        int n = 0;
        try {
            do {
                l2 = System.currentTimeMillis();
                this.locked = this.tryLockImpl();
                if (this.locked) {
                    long l4 = System.currentTimeMillis();
                    String string3 = this.infoPrefix(l4);
                    String string4 = this.getName();
                    long l5 = l4 - l3;
                    int n2 = n + 1;
                    System.err.println(new StringBuilder(67 + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string3).append(" +++ ").append(string4).append(" - Locked within ").append(l5).append(" ms, ").append(n2).append(" attempts").toString());
                    return true;
                }
                if (0 == n) {
                    string2 = this.infoPrefix(System.currentTimeMillis());
                    string = this.getName();
                    System.err.println(new StringBuilder(21 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(" III ").append(string).append(" - Wait for lock").toString());
                }
                Thread.sleep(this.poll_ms);
                ++n;
            } while (0L < (l -= System.currentTimeMillis() - l2));
        }
        catch (InterruptedException interruptedException) {
            long l6 = System.currentTimeMillis();
            String string5 = this.infoPrefix(l6);
            String string6 = this.getName();
            long l7 = l6 - l3;
            int n3 = n;
            throw new RuntimeException(new StringBuilder(82 + String.valueOf(string5).length() + String.valueOf(string6).length()).append(string5).append(" EEE (1) ").append(string6).append(" - couldn't get lock within ").append(l7).append(" ms, ").append(n3).append(" attempts").toString(), interruptedException);
        }
        l2 = System.currentTimeMillis();
        string2 = this.infoPrefix(l2);
        string = this.getName();
        long l8 = l2 - l3;
        int n4 = n;
        System.err.println(new StringBuilder(86 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(" +++ EEE (2) ").append(string).append(" - couldn't get lock within ").append(l8).append(" ms, ").append(n4).append(" attempts").toString());
        return false;
    }

    protected abstract boolean tryLockImpl();

    @Override
    public void unlock() throws RuntimeException {
        long l = System.currentTimeMillis();
        if (this.locked) {
            this.locked = !this.unlockImpl();
            long l2 = System.currentTimeMillis();
            String string = this.infoPrefix(l2);
            String string2 = this.getName();
            String string3 = this.locked ? "failed" : "ok";
            long l3 = l2 - l;
            System.err.println(new StringBuilder(46 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(" --- ").append(string2).append(" - Unlock ").append(string3).append(" within ").append(l3).append(" ms").toString());
        }
    }

    protected abstract boolean unlockImpl();

    @Override
    public synchronized boolean isLocked() {
        return this.locked;
    }

    protected String infoPrefix(long l) {
        String string = String.valueOf(Thread.currentThread().getName());
        return new StringBuilder(35 + String.valueOf(string).length()).append("SLOCK [T ").append(string).append(" @ ").append(l).append(" ms").toString();
    }

    protected String infoPrefix() {
        return this.infoPrefix(System.currentTimeMillis());
    }
}

