/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.net.AssetURLContext;
import com.jogamp.common.net.Uri;
import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.CustomCompress;
import com.jogamp.common.util.InterruptSource;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.SecurityUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.SyncFailedException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.security.Permission;
import java.util.regex.Pattern;
import jogamp.common.Debug;
import jogamp.common.os.AndroidUtils;
import jogamp.common.os.PlatformPropsImpl;

public class IOUtil {
    public static final boolean DEBUG;
    private static final boolean DEBUG_EXE;
    private static final boolean DEBUG_EXE_NOSTREAM;
    private static final boolean DEBUG_EXE_EXISTING_FILE;
    private static final String java_io_tmpdir_propkey = "java.io.tmpdir";
    private static final String user_home_propkey = "user.home";
    private static final String XDG_CACHE_HOME_envkey = "XDG_CACHE_HOME";
    public static final String tmpSubDir = "jogamp";
    private static final Pattern patternSingleBS;
    public static final Pattern patternSpaceEnc;
    private static final Object exeTestLock;
    private static WeakReference<byte[]> exeTestCodeRef;
    private static File tempRootExec;
    private static File tempRootNoexec;
    private static volatile boolean tempRootSet;

    private IOUtil() {
    }

    private static final Constructor<?> getFOSCtor() {
        Throwable throwable;
        Constructor<?> constructor;
        try {
            constructor = ReflectionUtil.getConstructor("java.io.FileOutputStream", new Class[]{File.class}, true, IOUtil.class.getClassLoader());
            throwable = null;
        }
        catch (Throwable throwable2) {
            constructor = null;
            throwable = throwable2;
        }
        if (DEBUG) {
            boolean bl = null != constructor;
            System.err.println(new StringBuilder(49).append("IOUtil: java.io.FileOutputStream available: ").append(bl).toString());
            if (null != throwable) {
                throwable.printStackTrace();
            }
        }
        return constructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyURLConn2File(URLConnection uRLConnection, File file) throws IOException {
        uRLConnection.connect();
        int n = 0;
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());){
            n = IOUtil.copyStream2File(bufferedInputStream, file, uRLConnection.getContentLength());
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyStream2File(InputStream inputStream, File file, int n) throws IOException {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
            n = IOUtil.copyStream2Stream(inputStream, bufferedOutputStream, n);
        }
        return n;
    }

    public static int copyStream2Stream(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        return IOUtil.copyStream2Stream(Platform.getMachineDataInfo().pageSizeInBytes(), inputStream, outputStream, n);
    }

    public static int copyStream2Stream(int n, InputStream inputStream, OutputStream outputStream, int n2) throws IOException {
        int n3;
        byte[] byArray = new byte[n];
        int n4 = 0;
        while ((n3 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n3);
            n4 += n3;
        }
        return n4;
    }

    public static StringBuilder appendCharStream(StringBuilder stringBuilder, Reader reader) throws IOException {
        int n;
        char[] cArray = new char[1024];
        while (0 < (n = reader.read(cArray))) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder;
    }

    public static byte[] copyStream2ByteArray(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        int n = 0;
        int n2 = inputStream.available();
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        do {
            if (n + n2 > byArray2.length) {
                byArray = new byte[n + n2];
                System.arraycopy(byArray2, 0, byArray, 0, n);
                byArray2 = byArray;
            }
            if ((n3 = inputStream.read(byArray2, n, n2)) < 0) continue;
            n += n3;
        } while ((n2 = inputStream.available()) > 0 && n3 >= 0);
        if (n != byArray2.length) {
            byArray = new byte[n];
            System.arraycopy(byArray2, 0, byArray, 0, n);
            byArray2 = byArray;
        }
        return byArray2;
    }

    public static ByteBuffer copyStream2ByteBuffer(InputStream inputStream) throws IOException {
        return IOUtil.copyStream2ByteBuffer(inputStream, -1);
    }

    public static ByteBuffer copyStream2ByteBuffer(InputStream inputStream, int n) throws IOException {
        int n2;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (n < (n2 = inputStream.available())) {
            n = n2;
        }
        MachineDataInfo machineDataInfo = Platform.getMachineDataInfo();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(machineDataInfo.pageAlignedSize(n));
        byte[] byArray = new byte[machineDataInfo.pageSizeInBytes()];
        int n3 = Math.min(machineDataInfo.pageSizeInBytes(), n2);
        int n4 = 0;
        do {
            if (n2 > byteBuffer.remaining()) {
                ByteBuffer byteBuffer2 = Buffers.newDirectByteBuffer(machineDataInfo.pageAlignedSize(byteBuffer.position() + n2));
                byteBuffer2.put(byteBuffer);
                byteBuffer = byteBuffer2;
            }
            if ((n4 = inputStream.read(byArray, 0, n3)) > 0) {
                byteBuffer.put(byArray, 0, n4);
            }
            n2 = inputStream.available();
            n3 = Math.min(machineDataInfo.pageSizeInBytes(), n2);
        } while (n4 > 0);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static String slashify(String string, boolean bl, boolean bl2) throws URISyntaxException {
        String string2 = patternSingleBS.matcher(string).replaceAll("/");
        if (bl && !string2.startsWith("/")) {
            String string3 = String.valueOf(string2);
            String string4 = string2 = string3.length() != 0 ? "/".concat(string3) : new String("/");
        }
        if (bl2 && !string2.endsWith("/")) {
            string2 = String.valueOf(string2).concat("/");
        }
        return IOUtil.cleanPathString(string2);
    }

    public static String getFileSuffix(File file) {
        return IOUtil.getFileSuffix(file.getName());
    }

    public static String getFileSuffix(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return IOUtil.toLowerCase(string.substring(n + 1));
    }

    private static String toLowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    public static FileOutputStream getFileOutputStream(File file, boolean bl) throws IOException {
        Constructor<?> constructor = IOUtil.getFOSCtor();
        if (null == constructor) {
            String string = String.valueOf(file);
            throw new IOException(new StringBuilder(72 + String.valueOf(string).length()).append("Cannot open file (").append(string).append(") for writing, FileOutputStream feature not available.").toString());
        }
        if (file.exists() && !bl) {
            String string = String.valueOf(file);
            throw new IOException(new StringBuilder(42 + String.valueOf(string).length()).append("File already exists (").append(string).append(") and overwrite=false").toString());
        }
        try {
            return (FileOutputStream)constructor.newInstance(file);
        }
        catch (Exception exception) {
            String string = String.valueOf(file);
            throw new IOException(new StringBuilder(26 + String.valueOf(string).length()).append("error opening ").append(string).append(" for write. ").toString(), exception);
        }
    }

    public static String getClassFileName(String string) {
        return String.valueOf(string.replace('.', '/')).concat(".class");
    }

    public static URL getClassURL(String string, ClassLoader classLoader) throws IOException {
        URL uRL = classLoader.getResource(IOUtil.getClassFileName(string));
        if (null == uRL) {
            String string2 = String.valueOf(string);
            throw new IOException(string2.length() != 0 ? "Cannot not find: ".concat(string2) : new String("Cannot not find: "));
        }
        return uRL;
    }

    public static String getBasename(String string) throws URISyntaxException {
        int n = (string = IOUtil.slashify(string, false, false)).lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String getDirname(String string) throws URISyntaxException {
        int n = (string = IOUtil.slashify(string, false, false)).lastIndexOf(47);
        if (n >= 0) {
            string = string.substring(0, n + 1);
        }
        return string;
    }

    public static URLConnection getResource(Class<?> clazz, String string) {
        ClassLoader classLoader = null != clazz ? clazz.getClassLoader() : IOUtil.class.getClassLoader();
        return IOUtil.getResource(string, classLoader, clazz);
    }

    public static URLConnection getResource(String string, ClassLoader classLoader, Class<?> clazz) {
        if (null == string) {
            return null;
        }
        URLConnection uRLConnection = null;
        if (null != clazz) {
            String string2 = clazz.getName().replace('.', '/');
            int n = string2.lastIndexOf(47);
            if (n >= 0) {
                String string3 = string2.substring(0, n + 1);
                String string4 = String.valueOf(string3);
                String string5 = String.valueOf(string);
                uRLConnection = IOUtil.getResource(string5.length() != 0 ? string4.concat(string5) : new String(string4), classLoader);
                if (DEBUG) {
                    String string6 = String.valueOf(clazz.getName());
                    boolean bl = null != uRLConnection;
                    System.err.println(new StringBuilder(65 + String.valueOf(string).length() + String.valueOf(string3).length() + String.valueOf(string6).length()).append("IOUtil: found <").append(string).append("> within class package <").append(string3).append("> of given class <").append(string6).append(">: ").append(bl).toString());
                }
            }
        } else if (DEBUG) {
            System.err.println("IOUtil: null context, skip rel. lookup");
        }
        if (null == uRLConnection) {
            uRLConnection = IOUtil.getResource(string, classLoader);
            if (DEBUG) {
                boolean bl = null != uRLConnection;
                System.err.println(new StringBuilder(38 + String.valueOf(string).length()).append("IOUtil: found <").append(string).append("> by classloader: ").append(bl).toString());
            }
        }
        return uRLConnection;
    }

    public static URLConnection getResource(String string, ClassLoader classLoader) {
        if (null == string) {
            return null;
        }
        if (DEBUG) {
            boolean bl = null != classLoader;
            System.err.println(new StringBuilder(34 + String.valueOf(string).length()).append("IOUtil: locating <").append(string).append(">, has cl: ").append(bl).toString());
        }
        if (string.startsWith("asset:")) {
            try {
                return AssetURLContext.createURL(string, classLoader).openConnection();
            }
            catch (IOException iOException) {
                if (DEBUG) {
                    ExceptionUtils.dumpThrowable("IOUtil", iOException);
                }
                return null;
            }
        }
        try {
            return AssetURLContext.resolve(string, classLoader);
        }
        catch (IOException iOException) {
            if (DEBUG) {
                ExceptionUtils.dumpThrowable("IOUtil", iOException);
            }
            return null;
        }
    }

    public static String getRelativeOf(File file, String string) throws URISyntaxException {
        if (null == string) {
            return null;
        }
        if (file != null) {
            File file2 = new File(file, string);
            return IOUtil.slashify(file2.getPath(), false, false);
        }
        return null;
    }

    public static String getParentOf(String string) throws URISyntaxException {
        int n;
        int n2 = n = null != string ? string.length() : 0;
        if (n == 0) {
            throw new IllegalArgumentException(new StringBuilder(16 + String.valueOf(string).length()).append("path is empty <").append(string).append(">").toString());
        }
        int n3 = string.lastIndexOf("/");
        if (n3 < 0) {
            throw new URISyntaxException(string, new StringBuilder(24 + String.valueOf(string).length()).append("path contains no '/': <").append(string).append(">").toString());
        }
        if (n3 == 0) {
            throw new URISyntaxException(string, new StringBuilder(23 + String.valueOf(string).length()).append("path has no parents: <").append(string).append(">").toString());
        }
        if (n3 < n - 1) {
            return string.substring(0, n3 + 1);
        }
        int n4 = string.lastIndexOf("!") + 1;
        int n5 = string.lastIndexOf("/", n3 - 1);
        if (n5 >= n4) {
            return string.substring(0, n5 + 1);
        }
        String string2 = string.substring(n4, n3);
        if (string2.equals("..")) {
            throw new URISyntaxException(string, new StringBuilder(24 + String.valueOf(string).length()).append("parent is unresolved: <").append(string).append(">").toString());
        }
        return string.substring(0, n4);
    }

    public static String cleanPathString(String string) throws URISyntaxException {
        int n = string.length() - 1;
        while (n >= 1 && (n = string.lastIndexOf("./", n)) >= 0) {
            if (0 < n && string.charAt(n - 1) == '.') {
                n -= 2;
                continue;
            }
            String string2 = String.valueOf(string.substring(0, n));
            String string3 = String.valueOf(string.substring(n + 2));
            string = string3.length() != 0 ? string2.concat(string3) : new String(string2);
            --n;
        }
        n = 0;
        while ((n = string.indexOf("../", n)) >= 0) {
            if (0 == n) {
                n += 3;
                continue;
            }
            String string4 = String.valueOf(IOUtil.getParentOf(string.substring(0, n)));
            String string5 = String.valueOf(string.substring(n + 3));
            string = string5.length() != 0 ? string4.concat(string5) : new String(string4);
            n = 0;
        }
        return string;
    }

    public static String getUriFilePathOrASCII(Uri uri) {
        if (uri.isFileScheme()) {
            return uri.toFile().getPath();
        }
        return uri.toASCIIString().get();
    }

    public static URLConnection openURL(URL uRL) {
        return IOUtil.openURL(uRL, ".");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static URLConnection openURL(URL uRL, String string) {
        if (null != uRL) {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.connect();
                if (!DEBUG) return uRLConnection;
                String string2 = String.valueOf(uRL);
                System.err.println(new StringBuilder(29 + String.valueOf(string2).length() + String.valueOf(string).length()).append("IOUtil: urlExists(").append(string2).append(") [").append(string).append("] - true").toString());
                return uRLConnection;
            }
            catch (IOException iOException) {
                if (!DEBUG) return null;
                String string3 = String.valueOf(uRL);
                ExceptionUtils.dumpThrowable(new StringBuilder(32 + String.valueOf(string3).length() + String.valueOf(string).length()).append("IOUtil: urlExists(").append(string3).append(") [").append(string).append("] - false -").toString(), iOException);
                return null;
            }
        } else {
            if (!DEBUG) return null;
            System.err.println(new StringBuilder(35 + String.valueOf(string).length()).append("IOUtil: no url - urlExists(null) [").append(string).append("]").toString());
        }
        return null;
    }

    private static String getExeTestFileSuffix() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                if (Platform.CPUFamily.X86 == PlatformPropsImpl.CPU_ARCH.family) {
                    return ".exe";
                }
                return ".bat";
            }
        }
        return ".sh";
    }

    private static String getExeTestShellCode() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                String string = String.valueOf(PlatformPropsImpl.NEWLINE);
                return string.length() != 0 ? "echo off".concat(string) : new String("echo off");
            }
        }
        return null;
    }

    private static String[] getExeTestCommandArgs(String string) {
        switch (PlatformPropsImpl.OS_TYPE) {
            default: 
        }
        return new String[]{string};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final byte[] readCode(String string) throws IOException {
        URLConnection uRLConnection = IOUtil.getResource(string, IOUtil.class.getClassLoader(), IOUtil.class);
        byte[] byArray = null;
        try (InputStream inputStream = uRLConnection.getInputStream();){
            byArray = CustomCompress.inflateFromStream(inputStream);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillExeTestFile(File file) throws IOException {
        if (Platform.OSType.WINDOWS == PlatformPropsImpl.OS_TYPE && Platform.CPUFamily.X86 == PlatformPropsImpl.CPU_ARCH.family) {
            byte[] byArray;
            Object object = exeTestLock;
            synchronized (object) {
                byte[] byArray2 = null;
                if (null == exeTestCodeRef || null == (byArray2 = (byte[])exeTestCodeRef.get())) {
                    String string = Platform.CPUType.X86_64 == PlatformPropsImpl.CPU_ARCH ? "bin/exe-windows-x86_64.defl" : "bin/exe-windows-i386.defl";
                    byArray = IOUtil.readCode(string);
                    exeTestCodeRef = new WeakReference<byte[]>(byArray);
                } else {
                    byArray = byArray2;
                }
            }
            object = new FileOutputStream(file);
            try {
                ((FileOutputStream)object).write(byArray, 0, byArray.length);
                try {
                    ((FileOutputStream)object).getFD().sync();
                }
                catch (SyncFailedException syncFailedException) {
                    ExceptionUtils.dumpThrowable("", syncFailedException);
                }
            }
            finally {
                ((FileOutputStream)object).close();
            }
        } else {
            String string = IOUtil.getExeTestShellCode();
            if (IOUtil.isStringSet(string)) {
                try (FileWriter fileWriter = new FileWriter(file);){
                    fileWriter.write(string);
                    try {
                        fileWriter.flush();
                    }
                    catch (IOException iOException) {
                        ExceptionUtils.dumpThrowable("", iOException);
                    }
                }
            }
        }
    }

    private static boolean getOSHasNoexecFS() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case OPENKODE: {
                return false;
            }
        }
        return true;
    }

    private static boolean getOSHasFreeDesktopXDG() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: 
            case OPENKODE: 
            case ANDROID: 
            case MACOS: {
                return false;
            }
        }
        return true;
    }

    public static boolean testFile(File file, boolean bl, boolean bl2) {
        if (!file.exists()) {
            if (DEBUG) {
                String string = String.valueOf(file.getAbsolutePath());
                System.err.println(new StringBuilder(35 + String.valueOf(string).length()).append("IOUtil.testFile: <").append(string).append(">: does not exist").toString());
            }
            return false;
        }
        if (bl && !file.isDirectory()) {
            if (DEBUG) {
                String string = String.valueOf(file.getAbsolutePath());
                System.err.println(new StringBuilder(39 + String.valueOf(string).length()).append("IOUtil.testFile: <").append(string).append(">: is not a directory").toString());
            }
            return false;
        }
        if (bl2 && !file.canWrite()) {
            if (DEBUG) {
                String string = String.valueOf(file.getAbsolutePath());
                System.err.println(new StringBuilder(36 + String.valueOf(string).length()).append("IOUtil.testFile: <").append(string).append(">: is not writable").toString());
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static boolean testDirExec(File var0) throws SecurityException {
        v0 = var1_1 = IOUtil.DEBUG_EXE != false || IOUtil.DEBUG != false;
        if (!IOUtil.testFile(var0, true, true)) {
            if (var1_1) {
                var2_2 = String.valueOf(var0.getAbsolutePath());
                System.err.println(new StringBuilder(41 + String.valueOf(var2_2).length()).append("IOUtil.testDirExec: <").append(var2_2).append(">: Not writeable dir").toString());
            }
            return false;
        }
        if (!IOUtil.getOSHasNoexecFS()) {
            if (var1_1) {
                var2_3 = String.valueOf(var0.getAbsolutePath());
                System.err.println(new StringBuilder(41 + String.valueOf(var2_3).length()).append("IOUtil.testDirExec: <").append(var2_3).append(">: Always executable").toString());
            }
            return true;
        }
        var2_4 = var1_1 != false ? System.currentTimeMillis() : 0L;
        try {
            if (IOUtil.DEBUG_EXE_EXISTING_FILE) {
                v1 = String.valueOf(IOUtil.getExeTestFileSuffix());
                v2 = new File(var0, v1.length() != 0 ? "jogamp_exe_tst".concat(v1) : new String("jogamp_exe_tst"));
            } else {
                v2 = var6_5 = null;
            }
            if (null != var6_5 && var6_5.exists()) {
                var4_9 = var6_5;
                var5_10 = true;
            } else {
                var4_9 = File.createTempFile("jogamp_exe_tst", IOUtil.getExeTestFileSuffix(), var0);
                var5_10 = false;
            }
        }
        catch (SecurityException var6_6) {
            throw var6_6;
        }
        catch (IOException var6_7) {
            if (var1_1) {
                var6_7.printStackTrace();
            }
            return false;
        }
        var6_8 = var1_1 != false ? System.currentTimeMillis() : 0L;
        var10_11 = -1;
        var11_12 = -1;
        if (var5_10 || var4_9.setExecutable(true, true)) {
            var12_13 = null;
            try {
                if (!var5_10) {
                    IOUtil.fillExeTestFile(var4_9);
                }
                var8_15 = var1_1 != false ? System.currentTimeMillis() : 0L;
                var12_13 = Runtime.getRuntime().exec(IOUtil.getExeTestCommandArgs(var4_9.getCanonicalPath()), null, null);
                if (IOUtil.DEBUG_EXE && !IOUtil.DEBUG_EXE_NOSTREAM) {
                    new StreamMonitor(new InputStream[]{var12_13.getInputStream(), var12_13.getErrorStream()}, System.err, "Exe-Tst: ");
                }
                var12_13.waitFor();
                var11_12 = var12_13.exitValue();
                var10_11 = 0;
            }
            catch (SecurityException var13_17) {
                throw var13_17;
            }
            catch (Throwable var13_18) {
                var8_15 = var1_1 != false ? System.currentTimeMillis() : 0L;
                var10_11 = -2;
                if (!var1_1) ** GOTO lbl71
                var14_22 = String.valueOf(var4_9.getAbsolutePath());
                var15_23 = String.valueOf(var13_18.getClass().getSimpleName());
                var16_25 = String.valueOf(var13_18.getMessage());
                System.err.println(new StringBuilder(33 + String.valueOf(var14_22).length() + String.valueOf(var15_23).length() + String.valueOf(var16_25).length()).append("IOUtil.testDirExec: <").append(var14_22).append(">: Caught ").append(var15_23).append(": ").append(var16_25).toString());
                var13_18.printStackTrace();
            }
            finally {
                if (null != var12_13) {
                    try {
                        var12_13.destroy();
                    }
                    catch (Throwable var13_19) {
                        ExceptionUtils.dumpThrowable("", var13_19);
                    }
                }
            }
        } else {
            var8_15 = var1_1 != false ? System.currentTimeMillis() : 0L;
        }
lbl71:
        // 4 sources

        v3 = var12_14 = 0 == var10_11;
        if (!IOUtil.DEBUG_EXE && !var5_10) {
            var4_9.delete();
        }
        if (var1_1) {
            var13_21 = System.currentTimeMillis();
            var15_23 = String.valueOf(var4_9.getAbsolutePath());
            var16_26 = var11_12;
            System.err.println(new StringBuilder(75 + String.valueOf(var15_23).length()).append("IOUtil.testDirExec(): test-exe <").append(var15_23).append(">, existingFile ").append(var5_10).append(", returned ").append(var16_26).toString());
            var15_23 = String.valueOf(var0.getAbsolutePath());
            var16_26 = var10_11;
            System.err.println(new StringBuilder(59 + String.valueOf(var15_23).length()).append("IOUtil.testDirExec(): abs-path <").append(var15_23).append(">: res ").append(var16_26).append(" -> ").append(var12_14).toString());
            var15_24 = var13_21 - var2_4;
            var17_28 = var6_8 - var2_4;
            var19_30 = var8_15 - var6_8;
            var21_31 = var13_21 - var8_15;
            System.err.println(new StringBuilder(142).append("IOUtil.testDirExec(): total ").append(var15_24).append("ms, create ").append(var17_28).append("ms, fill ").append(var19_30).append("ms, execute ").append(var21_31).append("ms").toString());
        }
        return var12_14;
    }

    private static File testDirImpl(File file, boolean bl, boolean bl2, String string) throws SecurityException {
        File file2;
        if (bl && !file.exists()) {
            file.mkdirs();
        }
        if (bl2) {
            file2 = IOUtil.testDirExec(file) ? file : null;
        } else {
            File file3 = file2 = IOUtil.testFile(file, true, true) ? file : null;
        }
        if (DEBUG) {
            String string2 = String.valueOf(file.getAbsolutePath());
            boolean bl3 = null != file2;
            System.err.println(new StringBuilder(57 + String.valueOf(string).length() + String.valueOf(string2).length()).append("IOUtil.testDirImpl(").append(string).append("): <").append(string2).append(">, create ").append(bl).append(", exec ").append(bl2).append(": ").append(bl3).toString());
        }
        return file2;
    }

    public static File testDir(File file, boolean bl, boolean bl2) throws SecurityException {
        return IOUtil.testDirImpl(file, bl, bl2, "testDir");
    }

    private static boolean isStringSet(String string) {
        return null != string && 0 < string.length();
    }

    private static File getSubTempDir(File file, String string, boolean bl, String string2) throws SecurityException {
        File file2 = null;
        if (null != IOUtil.testDirImpl(file, true, bl, string2)) {
            for (int i = 0; null == file2 && i <= 9999; ++i) {
                String string3 = String.format("_%04d", i);
                String string4 = String.valueOf(string);
                String string5 = String.valueOf(string3);
                file2 = IOUtil.testDirImpl(new File(file, string5.length() != 0 ? string4.concat(string5) : new String(string4)), true, bl, string2);
            }
        }
        return file2;
    }

    private static File getFile(String string) {
        if (IOUtil.isStringSet(string)) {
            return new File(string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static File getTempDir(boolean bl) throws SecurityException, IOException {
        Object object;
        Object object2;
        if (!tempRootSet) {
            object2 = IOUtil.class;
            // MONITORENTER : com.jogamp.common.util.IOUtil.class
            if (!tempRootSet) {
                Object object3;
                String string;
                String string2;
                Object object4;
                Object object5;
                Object object6;
                tempRootSet = true;
                object = AndroidUtils.getTempRoot();
                if (null != object) {
                    tempRootExec = tempRootNoexec = IOUtil.getSubTempDir((File)object, tmpSubDir, false, "Android.ctxTemp");
                    // MONITOREXIT : object2
                    return tempRootExec;
                }
                object = IOUtil.getFile(PropertyAccess.getProperty(java_io_tmpdir_propkey, false));
                if (DEBUG) {
                    object6 = String.valueOf(object);
                    boolean bl2 = null != object;
                    System.err.println(new StringBuilder(43 + String.valueOf(object6).length()).append("IOUtil.getTempRoot(): tempX1 <").append((String)object6).append(">, used ").append(bl2).toString());
                }
                if (!IOUtil.isStringSet((String)(object5 = System.getenv("TMPDIR")))) {
                    object5 = System.getenv("TEMP");
                }
                object6 = null != (object4 = IOUtil.getFile((String)object5)) && !((File)object4).equals(object) ? object4 : null;
                if (DEBUG) {
                    string2 = String.valueOf(object4);
                    boolean bl3 = null != object6;
                    System.err.println(new StringBuilder(43 + String.valueOf(string2).length()).append("IOUtil.getTempRoot(): tempX3 <").append(string2).append(">, used ").append(bl3).toString());
                }
                object5 = IOUtil.getFile(PropertyAccess.getProperty(user_home_propkey, false));
                if (DEBUG) {
                    object4 = String.valueOf(object5);
                    boolean bl4 = null != object5;
                    System.err.println(new StringBuilder(43 + String.valueOf(object4).length()).append("IOUtil.getTempRoot(): tempX4 <").append((String)object4).append(">, used ").append(bl4).toString());
                }
                if (IOUtil.getOSHasFreeDesktopXDG()) {
                    string2 = System.getenv(XDG_CACHE_HOME_envkey);
                    if (!IOUtil.isStringSet(string2) && null != object5) {
                        String string3 = String.valueOf(((File)object5).getAbsolutePath());
                        string = String.valueOf(File.separator);
                        string2 = new StringBuilder(6 + String.valueOf(string3).length() + String.valueOf(string).length()).append(string3).append(string).append(".cache").toString();
                    }
                } else {
                    string2 = null;
                }
                object4 = null != (object3 = IOUtil.getFile(string2)) && !((File)object3).equals(object) ? object3 : null;
                if (DEBUG) {
                    string = String.valueOf(object3);
                    boolean bl5 = null != object4;
                    System.err.println(new StringBuilder(43 + String.valueOf(string).length()).append("IOUtil.getTempRoot(): tempX2 <").append(string).append(">, used ").append(bl5).toString());
                }
                if (null == tempRootExec && null != object) {
                    tempRootExec = Platform.OSType.MACOS == PlatformPropsImpl.OS_TYPE ? IOUtil.getSubTempDir((File)object, tmpSubDir, false, "tempX1") : IOUtil.getSubTempDir((File)object, tmpSubDir, true, "tempX1");
                }
                if (null == tempRootExec && null != object4) {
                    tempRootExec = IOUtil.getSubTempDir((File)object4, tmpSubDir, true, "tempX2");
                }
                if (null == tempRootExec && null != object6) {
                    tempRootExec = IOUtil.getSubTempDir((File)object6, tmpSubDir, true, "tempX3");
                }
                if (null == tempRootExec && null != object5) {
                    tempRootExec = IOUtil.getSubTempDir((File)object5, ".jogamp", true, "tempX4");
                }
                if (null != tempRootExec) {
                    tempRootNoexec = tempRootExec;
                } else {
                    if (null == tempRootNoexec && null != object) {
                        tempRootNoexec = IOUtil.getSubTempDir((File)object, tmpSubDir, false, "temp01");
                    }
                    if (null == tempRootNoexec && null != object4) {
                        tempRootNoexec = IOUtil.getSubTempDir((File)object4, tmpSubDir, false, "temp02");
                    }
                    if (null == tempRootNoexec && null != object6) {
                        tempRootNoexec = IOUtil.getSubTempDir((File)object6, tmpSubDir, false, "temp03");
                    }
                    if (null == tempRootNoexec && null != object5) {
                        tempRootNoexec = IOUtil.getSubTempDir((File)object5, ".jogamp", false, "temp04");
                    }
                }
                if (DEBUG) {
                    string2 = null != tempRootExec ? tempRootExec.getAbsolutePath() : null;
                    object3 = null != tempRootNoexec ? tempRootNoexec.getAbsolutePath() : null;
                    System.err.println(new StringBuilder(49 + String.valueOf(string2).length() + String.valueOf(object3).length()).append("IOUtil.getTempRoot(): temp dirs: exec: ").append(string2).append(", noexec: ").append((String)object3).toString());
                }
            }
            // MONITOREXIT : object2
        }
        Object object7 = object2 = bl ? tempRootExec : tempRootNoexec;
        if (null != object2) {
            object = new FilePermission(((File)object2).getAbsolutePath(), "read,write,delete");
            SecurityUtil.checkPermission((Permission)object);
            return object2;
        }
        object = bl ? "executable " : "";
        throw new IOException(new StringBuilder(41 + String.valueOf(object).length()).append("Could not determine a temporary ").append((String)object).append("directory").toString());
    }

    public static File createTempFile(String string, String string2, boolean bl) throws IllegalArgumentException, IOException, SecurityException {
        return File.createTempFile(string, string2, IOUtil.getTempDir(bl));
    }

    public static void close(Closeable closeable, boolean bl) throws RuntimeException {
        block4: {
            if (null != closeable) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    if (bl) {
                        throw new RuntimeException(iOException);
                    }
                    if (!DEBUG) break block4;
                    System.err.println("Caught Exception: ");
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static IOException close(Closeable closeable, IOException[] iOExceptionArray, PrintStream printStream) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            if (null == iOExceptionArray[0]) {
                iOExceptionArray[0] = iOException;
            }
            if (null != printStream) {
                String string = String.valueOf(iOException.getClass().getSimpleName());
                String string2 = String.valueOf(iOException.getMessage());
                printStream.println(new StringBuilder(9 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Caught ").append(string).append(": ").append(string2).toString());
                iOException.printStackTrace(printStream);
            }
            return iOException;
        }
        return null;
    }

    static {
        Debug.initSingleton();
        DEBUG = Debug.debug("IOUtil");
        DEBUG_EXE = PropertyAccess.isPropertyDefined("jogamp.debug.IOUtil.Exe", true);
        DEBUG_EXE_NOSTREAM = PropertyAccess.isPropertyDefined("jogamp.debug.IOUtil.Exe.NoStream", true);
        DEBUG_EXE_EXISTING_FILE = false;
        patternSingleBS = Pattern.compile("\\\\{1}");
        patternSpaceEnc = Pattern.compile("%20");
        exeTestLock = new Object();
        exeTestCodeRef = null;
        tempRootExec = null;
        tempRootNoexec = null;
        tempRootSet = false;
    }

    public static class StreamMonitor
    implements Runnable {
        private final InputStream[] istreams;
        private final boolean[] eos;
        private final PrintStream ostream;
        private final String prefix;

        public StreamMonitor(InputStream[] inputStreamArray, PrintStream printStream, String string) {
            this.istreams = inputStreamArray;
            this.eos = new boolean[inputStreamArray.length];
            this.ostream = printStream;
            this.prefix = string;
            String string2 = String.valueOf(Thread.currentThread().getName());
            InterruptSource.Thread thread = new InterruptSource.Thread(null, this, string2.length() != 0 ? "StreamMonitor-".concat(string2) : new String("StreamMonitor-"));
            thread.setDaemon(true);
            thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] byArray = new byte[4096];
            try {
                int n = this.istreams.length;
                int n2 = 0;
                do {
                    for (int i = 0; i < this.istreams.length; ++i) {
                        if (this.eos[i]) continue;
                        int n3 = this.istreams[i].read(byArray);
                        if (n3 > 0) {
                            if (null == this.ostream) continue;
                            if (null != this.prefix) {
                                this.ostream.write(this.prefix.getBytes());
                            }
                            this.ostream.write(byArray, 0, n3);
                            continue;
                        }
                        ++n2;
                        this.eos[i] = true;
                    }
                    if (null == this.ostream) continue;
                    this.ostream.flush();
                } while (n2 < n);
            }
            catch (IOException iOException) {
            }
            finally {
                if (null != this.ostream) {
                    this.ostream.flush();
                }
            }
        }
    }

    public static class ClassResources {
        public final ClassLoader classLoader;
        public final Class<?> contextCL;
        public final String[] resourcePaths;

        public final int resourceCount() {
            return this.resourcePaths.length;
        }

        public ClassResources(Class<?> clazz, String[] stringArray) {
            this(stringArray, clazz.getClassLoader(), clazz);
        }

        public ClassResources(String[] stringArray, ClassLoader classLoader, Class<?> clazz) {
            for (int i = stringArray.length - 1; i >= 0; --i) {
                if (null != stringArray[i]) continue;
                int n = i;
                throw new IllegalArgumentException(new StringBuilder(33).append("resourcePath[").append(n).append("] is null").toString());
            }
            this.classLoader = classLoader;
            this.contextCL = clazz;
            this.resourcePaths = stringArray;
        }

        public URLConnection resolve(int n) throws ArrayIndexOutOfBoundsException {
            return IOUtil.getResource(this.resourcePaths[n], this.classLoader, this.contextCL);
        }
    }
}

