/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.NativeBuffer;
import com.jogamp.common.os.Platform;
import java.nio.Buffer;

public abstract class AbstractBuffer<B extends AbstractBuffer>
implements NativeBuffer<B> {
    protected final Buffer buffer;
    protected final int elementSize;
    protected final int capacity;
    protected int position;

    protected AbstractBuffer(Buffer buffer, int n, int n2) {
        this.buffer = buffer;
        this.elementSize = n;
        this.capacity = n2;
        this.position = 0;
    }

    @Override
    public final int elementSize() {
        return this.elementSize;
    }

    @Override
    public final int limit() {
        return this.capacity;
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    @Override
    public final int position() {
        return this.position;
    }

    @Override
    public final B position(int n) {
        if (0 > n || n >= this.capacity) {
            int n2 = this.capacity();
            throw new IndexOutOfBoundsException(new StringBuilder(95).append("Sorry to interrupt, but the position ").append(n).append(" was out of bounds. ").append("My capacity is ").append(n2).append(".").toString());
        }
        this.position = n;
        return (B)this;
    }

    @Override
    public final int remaining() {
        return this.capacity - this.position;
    }

    @Override
    public final boolean hasRemaining() {
        return this.position < this.capacity;
    }

    @Override
    public final B rewind() {
        this.position = 0;
        return (B)this;
    }

    @Override
    public final Buffer getBuffer() {
        return this.buffer;
    }

    @Override
    public final boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public final boolean hasArray() {
        return this.buffer.hasArray();
    }

    @Override
    public final int arrayOffset() {
        if (this.hasArray()) {
            return this.buffer.arrayOffset();
        }
        return 0;
    }

    @Override
    public Object array() throws UnsupportedOperationException {
        return this.buffer.array();
    }

    public String toString() {
        boolean bl = this.isDirect();
        boolean bl2 = this.hasArray();
        int n = this.capacity;
        int n2 = this.position;
        int n3 = this.elementSize;
        int n4 = this.buffer.capacity();
        int n5 = this.buffer.limit();
        int n6 = this.buffer.position();
        return new StringBuilder(177).append("AbstractBuffer[direct ").append(bl).append(", hasArray ").append(bl2).append(", capacity ").append(n).append(", position ").append(n2).append(", elementSize ").append(n3).append(", buffer[capacity ").append(n4).append(", lim ").append(n5).append(", pos ").append(n6).append("]]").toString();
    }

    static {
        Platform.initSingleton();
    }
}

