/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.structure;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.seam.facet.SeamFacetType;
import com.intellij.seam.structure.SeamView;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import org.jetbrains.annotations.NotNull;

public class SeamToolWindowFactory
implements ToolWindowFactory {
    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/seam/structure/SeamToolWindowFactory", "createToolWindowContent"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/seam/structure/SeamToolWindowFactory", "createToolWindowContent"));
        }
        toolWindow.setAvailable(true, null);
        toolWindow.setToHideOnEmptyContent(true);
        toolWindow.setTitle(SeamFacetType.getInstance().getPresentableName());
        SeamView view = new SeamView(project);
        view.setupToolWindow((ToolWindowEx)toolWindow);
        ContentManager contentManager = toolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent(view.getComponent(), null, false);
        content.setDisposer((Disposable)view);
        content.setCloseable(false);
        content.setPreferredFocusableComponent(view.getComponent());
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
    }
}

