/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.structure;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiType;
import com.intellij.seam.model.SeamComponentScope;
import com.intellij.seam.model.xml.components.SeamDomComponent;
import com.intellij.ui.SimpleTextAttributes;
import icons.SeamIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class SeamDomComponentNodeDescriptor
extends JavaeeNodeDescriptor<SeamDomComponent> {
    public SeamDomComponentNodeDescriptor(Project project, NodeDescriptor parentDescriptor, Object parameters, SeamDomComponent element) {
        super(project, parentDescriptor, parameters, (Object)element);
    }

    protected String getNewNodeText() {
        SeamDomComponent seamDomComponent = (SeamDomComponent)this.getElement();
        if (!seamDomComponent.isValid()) {
            return "";
        }
        String name = seamDomComponent.getComponentName();
        return name == null ? "<" + seamDomComponent.getXmlTag().getName() + " ... />" : name;
    }

    protected Icon getNewIcon() {
        return SeamIcons.Seam;
    }

    public boolean isValid() {
        return ((SeamDomComponent)this.getElement()).isValid();
    }

    protected void doUpdate() {
        super.doUpdate();
        String textExt = this.getNewNodeTextExt();
        if (textExt != null) {
            this.addColoredFragment(" (" + this.getNewNodeTextExt() + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
    }

    @Nullable
    protected String getNewNodeTextExt() {
        if (!this.isValid()) {
            return null;
        }
        SeamDomComponent seamDomComponent = (SeamDomComponent)this.getElement();
        PsiType psiType = seamDomComponent.getComponentType();
        return psiType == null ? null : psiType.getPresentableText();
    }

    public Object getData(String dataId) {
        if ("psi.Element".equals(dataId)) {
            return ((SeamDomComponent)this.getElement()).getIdentifyingPsiElement();
        }
        return super.getData(dataId);
    }

    public String getNewTooltip() {
        if (!this.isValid()) {
            return null;
        }
        SeamDomComponent seamDomComponent = (SeamDomComponent)this.getElement();
        StringBuffer tooltip = new StringBuffer();
        String name = seamDomComponent.getComponentName();
        PsiType psiType = seamDomComponent.getComponentType();
        SeamComponentScope scope = seamDomComponent.getComponentScope();
        if (name != null) {
            tooltip.append("<tr><td><strong>name:</strong></td><td>").append(name).append("</td></tr>");
        }
        if (psiType != null) {
            tooltip.append("<tr><td><strong>class:</strong></td><td>").append(psiType.getCanonicalText()).append("</td></tr>");
        }
        if (scope != null) {
            tooltip.append("<tr><td><strong>scope:</strong></td><td>").append(scope.getValue()).append("</td></tr>");
        }
        if (tooltip.length() != 0) {
            return "<html><table>" + tooltip.toString() + "</table></html>";
        }
        return tooltip.toString();
    }
}

