/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.highlighting.jam;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.compiler.util.InspectionValidatorWrapper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.resources.SeamInspectionBundle;
import com.intellij.seam.utils.SeamCommonUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SeamJamModelInspectionBase
extends BaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = SeamInspectionBundle.message("model.inspection.group.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/highlighting/jam/SeamJamModelInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/seam/highlighting/jam/SeamJamModelInspectionBase", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/seam/highlighting/jam/SeamJamModelInspectionBase", "checkFile"));
        }
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)file)) {
            return null;
        }
        if (!SeamJamModelInspectionBase.isFileAccepted(file.getContainingFile())) {
            return null;
        }
        if (!SeamCommonUtils.isSeamFacetDefined(ModuleUtil.findModuleForPsiElement((PsiElement)file))) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        this.checkJavaFile((PsiJavaFile)file, holder, isOnTheFly);
        List problemDescriptors = holder.getResults();
        if (problemDescriptors != null) {
            return problemDescriptors.toArray(new ProblemDescriptor[problemDescriptors.size()]);
        }
        return null;
    }

    protected void checkJavaFile(@NotNull PsiJavaFile javaFile, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (javaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaFile", "com/intellij/seam/highlighting/jam/SeamJamModelInspectionBase", "checkJavaFile"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/seam/highlighting/jam/SeamJamModelInspectionBase", "checkJavaFile"));
        }
        for (PsiClass psiClass : javaFile.getClasses()) {
            this.checkClassInternal(psiClass, holder);
        }
    }

    private void checkClassInternal(PsiClass aClass, ProblemsHolder holder) {
        this.checkClass(aClass, holder);
        for (PsiClass psiClass : aClass.getInnerClasses()) {
            this.checkClass(psiClass, holder);
        }
    }

    protected void checkClass(PsiClass aClass, ProblemsHolder holder) {
        SeamJamComponent jamComponent = SeamCommonUtils.getSeamJamComponent(aClass);
        if (jamComponent != null) {
            this.checkSeamJamComponent(jamComponent, holder);
        }
    }

    protected void checkSeamJamComponent(SeamJamComponent jamComponent, ProblemsHolder holder) {
    }

    protected static boolean isFileAccepted(PsiFile file) {
        if (!InspectionValidatorWrapper.isCompilationThread()) {
            return true;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        return module != null;
    }
}

