/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.seam.actions.CreateSeamComponentsAction;
import com.intellij.seam.facet.SeamFacet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public abstract class BaseCreateSeamAction
extends AnAction {
    public static final Logger LOG = Logger.getInstance((String)CreateSeamComponentsAction.class.getName());

    public BaseCreateSeamAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    public final void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return;
        }
        PsiDirectory dir = view.getOrChooseDirectory();
        if (dir == null) {
            return;
        }
        PsiElement createdElement = this.create(dir);
        if (createdElement != null) {
            view.selectElement(createdElement);
        }
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        boolean enabled = this.isAvailable(dataContext);
        presentation.setVisible(enabled);
        presentation.setEnabled(enabled);
    }

    protected boolean isAvailable(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null || view.getDirectories().length == 0) {
            return false;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        return module != null && SeamFacet.getInstance(module) != null && this.isDirectoryAccepted(dataContext);
    }

    private boolean isDirectoryAccepted(DataContext dataContext) {
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module == null) {
            return false;
        }
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (view != null && project != null) {
            PsiDirectory[] dirs;
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            for (PsiDirectory dir : dirs = view.getDirectories()) {
                if (dir.findFile(this.getFileName()) != null || (!this.isAllowedInSourceDir() || !projectFileIndex.isUnderSourceRootOfType(dir.getVirtualFile(), JavaModuleSourceRootTypes.SOURCES) || JavaDirectoryService.getInstance().getPackage(dir) == null) && (!this.isAllowedInWebInf() || !"WEB-INF".equals(dir.getName()))) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isAllowedInWebInf() {
        return true;
    }

    protected boolean isAllowedInSourceDir() {
        return true;
    }

    @Nullable
    private PsiElement create(PsiDirectory directory) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)directory);
        PsiElement psiElement = null;
        try {
            psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)this.getTemplate(module), (String)this.getFileName(), null, (PsiDirectory)directory);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return psiElement;
    }

    @NotNull
    protected abstract FileTemplate getTemplate(Module var1);

    @NotNull
    protected abstract String getFileName();
}

