/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam;

import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.jsp.el.ELContextProvider;
import com.intellij.psi.impl.source.jsp.el.ELLanguage;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlText;
import com.intellij.seam.el.SeamELContextProvider;
import com.intellij.seam.el.SeamELInjectorUtil;
import com.intellij.seam.el.SeamElFileProvider;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SeamElXmlConfigProvider
implements MultiHostInjector {
    private static boolean isSeamElContainerFile(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/seam/SeamElXmlConfigProvider", "isSeamElContainerFile"));
        }
        for (SeamElFileProvider fileProvider : (SeamElFileProvider[])Extensions.getExtensions(SeamElFileProvider.EP_NAME)) {
            if (!fileProvider.isSeamElContainer(xmlFile)) continue;
            return true;
        }
        return false;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        List<TextRange> ranges;
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/seam/SeamElXmlConfigProvider", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/seam/SeamElXmlConfigProvider", "getLanguagesToInject"));
        }
        PsiElement originalElement = host.getOriginalElement();
        PsiFile psiFile = originalElement.getContainingFile();
        if (psiFile.getProject().isDefault()) {
            return;
        }
        if (psiFile instanceof XmlFile && !(psiFile instanceof JspFile) && SeamElXmlConfigProvider.isSeamElContainerFile((XmlFile)psiFile) && (ranges = SeamELInjectorUtil.getELTextRanges(originalElement)).size() > 0) {
            for (TextRange textRange : ranges) {
                registrar.startInjecting(ELLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)originalElement, textRange).doneInjecting();
            }
            originalElement.putUserData(ELContextProvider.ourContextProviderKey, (Object)new SeamELContextProvider(originalElement));
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(XmlAttributeValue.class, XmlText.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/SeamElXmlConfigProvider", "elementsToInjectIn"));
        }
        return list;
    }
}

