/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.toolWindow.tree.nodes;

import com.intellij.beanValidation.toolWindow.tree.BVTreeStructure;
import com.intellij.beanValidation.toolWindow.tree.nodes.AbstractBVNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.AbstractBVTypeNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.BVTreeRootNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.ConstraintMappingsNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.ConstraintsNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.ValidatorsNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.module.Module;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BVModuleNode
extends AbstractBVNode {
    private Module myModule;
    private BVTreeStructure myTreeStructure;

    public BVModuleNode(@NotNull Module module, BVTreeStructure treeStructure, BVTreeRootNode treeRootNode) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/beanValidation/toolWindow/tree/nodes/BVModuleNode", "<init>"));
        }
        super(treeRootNode);
        this.myModule = module;
        this.myTreeStructure = treeStructure;
    }

    protected void update(PresentationData presentation) {
        super.update(presentation);
        presentation.setIcon(PlatformIcons.CONTENT_ROOT_ICON_CLOSED);
        presentation.addText(this.myModule.getName(), this.getPlainAttributes());
    }

    @Override
    public SimpleNode[] getChildren() {
        ArrayList<SimpleNode> children = new ArrayList<SimpleNode>();
        this.addIfNeeded(children, new ConstraintsNode(this.myModule, this));
        this.addIfNeeded(children, new ValidatorsNode(this.myModule, this));
        this.addIfNeeded(children, new ConstraintMappingsNode(this.myModule, this));
        return children.toArray(new SimpleNode[children.size()]);
    }

    private void addIfNeeded(List<SimpleNode> children, AbstractBVTypeNode node) {
        if (this.myTreeStructure.getNodesConfig().isShow(node.getType())) {
            children.add(node);
        }
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myModule};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/toolWindow/tree/nodes/BVModuleNode", "getEqualityObjects"));
        }
        return objectArray;
    }
}

