/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.model.converters;

import com.intellij.beanValidation.utils.BVUtils;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BvGetterNameConverter
extends ResolvingConverter<PsiMethod> {
    @NotNull
    public Collection<? extends PsiMethod> getVariants(ConvertContext context) {
        PsiClass psiClass = BVUtils.getBeanClass(context);
        Collection<Object> collection = psiClass == null ? Collections.emptyList() : BvGetterNameConverter.getAllGetters(psiClass);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/model/converters/BvGetterNameConverter", "getVariants"));
        }
        return collection;
    }

    private static Collection<PsiMethod> getAllGetters(PsiClass psiClass) {
        ArrayList<PsiMethod> getters = new ArrayList<PsiMethod>();
        for (PsiMethod method : psiClass.getMethods()) {
            if (!PropertyUtil.isSimplePropertyGetter((PsiMethod)method)) continue;
            getters.add(method);
        }
        return getters;
    }

    public PsiMethod fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        for (PsiMethod psiMethod : this.getVariants(context)) {
            if (!s.equals(PropertyUtil.getPropertyName((PsiMethod)psiMethod))) continue;
            return psiMethod;
        }
        return null;
    }

    public String toString(@Nullable PsiMethod method, ConvertContext context) {
        return method == null ? null : PropertyUtil.getPropertyName((PsiMethod)method);
    }

    public void handleElementRename(GenericDomValue<PsiMethod> genericValue, ConvertContext context, String newElementName) {
        super.handleElementRename(genericValue, context, PropertyUtil.getPropertyName((String)newElementName));
    }
}

