/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting.fixes;

import com.intellij.beanValidation.highlighting.fixes.BaseBVQuickFix;
import com.intellij.beanValidation.resources.BVInspectionBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class SwapMinMax
extends BaseBVQuickFix {
    private final PsiElement minElement;
    private final PsiElement maxElement;

    public SwapMinMax(PsiElement minElement, PsiElement maxElement) {
        super(BVInspectionBundle.message("swap.min.max", new Object[0]));
        this.minElement = minElement;
        this.maxElement = maxElement;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/beanValidation/highlighting/fixes/SwapMinMax", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/beanValidation/highlighting/fixes/SwapMinMax", "applyFix"));
        }
        PsiElement maxCopy = this.maxElement.copy();
        PsiElement minCopy = this.minElement.copy();
        this.maxElement.replace(minCopy);
        this.minElement.replace(maxCopy);
    }
}

