/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting.fixes;

import com.intellij.beanValidation.highlighting.fixes.BaseBVQuickFix;
import com.intellij.beanValidation.model.xml.Constraint;
import com.intellij.beanValidation.model.xml.Element;
import com.intellij.beanValidation.resources.BVBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateConstraintParamsFix
extends BaseBVQuickFix {
    private final Constraint myConstraint;
    private final List<PsiMethod> myMethods;

    public CreateConstraintParamsFix(Constraint constraint, List<PsiMethod> methods) {
        super(BVBundle.message("create.missing.elements", new Object[0]));
        this.myConstraint = constraint;
        this.myMethods = methods;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/beanValidation/highlighting/fixes/CreateConstraintParamsFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/beanValidation/highlighting/fixes/CreateConstraintParamsFix", "applyFix"));
        }
        for (PsiMethod method : this.myMethods) {
            PsiClass psiClass;
            Element element = this.myConstraint.addElement();
            element.getName().setValue((Object)method);
            PsiType type = method.getReturnType();
            String defaultValue = "null";
            if (type instanceof PsiArrayType) {
                defaultValue = "";
            } else if (TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)type)) {
                defaultValue = PsiTypesUtil.getDefaultValueOfType((PsiType)type);
            } else if (type instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null && psiClass.isEnum()) {
                PsiEnumConstant defaultConstant = CreateConstraintParamsFix.getEnumDefaultConstant(psiClass);
                defaultValue = defaultConstant == null ? "null" : defaultConstant.getName();
            }
            element.setValue("null".equals(defaultValue) ? "value" : defaultValue);
        }
    }

    @Nullable
    private static PsiEnumConstant getEnumDefaultConstant(@NotNull PsiClass enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClass", "com/intellij/beanValidation/highlighting/fixes/CreateConstraintParamsFix", "getEnumDefaultConstant"));
        }
        assert (enumClass.isEnum()) : "Should be enum";
        for (PsiField field : enumClass.getFields()) {
            if (!(field instanceof PsiEnumConstant)) continue;
            return (PsiEnumConstant)field;
        }
        return null;
    }
}

