/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting;

import com.intellij.beanValidation.highlighting.BaseBeanValidationInspection;
import com.intellij.beanValidation.highlighting.fixes.SwapMinMax;
import com.intellij.beanValidation.resources.BVInspectionBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinMaxValuesInspection
extends BaseBeanValidationInspection {
    private static final PsiConstantEvaluationHelper HELPER = new PsiConstantEvaluationHelperImpl();

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = BVInspectionBundle.message("min.max.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/highlighting/MinMaxValuesInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public ProblemDescriptor[] checkAnnotation(@NotNull PsiAnnotation anno, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/beanValidation/highlighting/MinMaxValuesInspection", "checkAnnotation"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/beanValidation/highlighting/MinMaxValuesInspection", "checkAnnotation"));
        }
        if (MinMaxValuesInspection.isMinMaxAnnotation(anno)) {
            PsiAnnotationMemberValue maxValue = anno.findAttributeValue("max");
            PsiAnnotationMemberValue minValue = anno.findAttributeValue("min");
            if (maxValue == null || minValue == null) {
                return null;
            }
            PsiElement maxElement = maxValue.getOriginalElement();
            PsiElement minElement = minValue.getOriginalElement();
            if (maxElement instanceof PsiExpression && minElement instanceof PsiExpression) {
                Integer max = MinMaxValuesInspection.getIntOrNull(HELPER.computeConstantExpression((PsiElement)((PsiExpression)maxElement)));
                Integer min = MinMaxValuesInspection.getIntOrNull(HELPER.computeConstantExpression((PsiElement)((PsiExpression)minElement)));
                if (max == null && min == null) {
                    return null;
                }
                ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
                if (min != null && min < 0 && MinMaxValuesInspection.isLengthAnnotation(anno)) {
                    problems.add(manager.createProblemDescriptor(minElement, BVInspectionBundle.message("min.value.is.negative", new Object[0]), isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                }
                if (max != null && min != null && min > max) {
                    problems.add(manager.createProblemDescriptor(maxElement, BVInspectionBundle.message("max.value.is.less.than.min", new Object[0]), (LocalQuickFix)new SwapMinMax(minElement, maxElement), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
                }
                return problems.toArray(new ProblemDescriptor[problems.size()]);
            }
        }
        return null;
    }

    @Nullable
    public static Integer getIntOrNull(@Nullable Object obj) {
        String value;
        String string = value = obj == null ? null : obj.toString();
        if (value == null) {
            return null;
        }
        try {
            return new Integer(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isMinMaxAnnotation(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/beanValidation/highlighting/MinMaxValuesInspection", "isMinMaxAnnotation"));
        }
        return MinMaxValuesInspection.isLengthAnnotation(anno) || MinMaxValuesInspection.isSizeAnnotation(anno);
    }

    public static boolean isLengthAnnotation(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/beanValidation/highlighting/MinMaxValuesInspection", "isLengthAnnotation"));
        }
        return "org.hibernate.validator.constraints.Length".equals(anno.getQualifiedName());
    }

    public static boolean isSizeAnnotation(@NotNull PsiAnnotation anno) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/beanValidation/highlighting/MinMaxValuesInspection", "isSizeAnnotation"));
        }
        return "javax.validation.constraints.Size".equals(anno.getQualifiedName());
    }
}

