/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting;

import com.intellij.beanValidation.resources.BVInspectionBundle;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseBeanValidationInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = BVInspectionBundle.message("model.inspection.group.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/highlighting/BaseBeanValidationInspection", "getGroupDisplayName"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nullable
    public ProblemDescriptor[] checkAnnotation(@NotNull PsiAnnotation anno, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (anno == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anno", "com/intellij/beanValidation/highlighting/BaseBeanValidationInspection", "checkAnnotation"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/beanValidation/highlighting/BaseBeanValidationInspection", "checkAnnotation"));
        }
        return null;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/beanValidation/highlighting/BaseBeanValidationInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                this.addDescriptors(BaseBeanValidationInspection.this.checkMethod(method, holder.getManager(), isOnTheFly));
            }

            public void visitClass(PsiClass aClass) {
                this.addDescriptors(BaseBeanValidationInspection.this.checkClass(aClass, holder.getManager(), isOnTheFly));
            }

            public void visitField(PsiField field) {
                this.addDescriptors(BaseBeanValidationInspection.this.checkField(field, holder.getManager(), isOnTheFly));
            }

            public void visitFile(PsiFile file) {
                this.addDescriptors(BaseBeanValidationInspection.this.checkFile(file, holder.getManager(), isOnTheFly));
            }

            public void visitAnnotation(PsiAnnotation annotation) {
                this.addDescriptors(BaseBeanValidationInspection.this.checkAnnotation(annotation, holder.getManager(), isOnTheFly));
            }

            private void addDescriptors(ProblemDescriptor[] descriptors) {
                if (descriptors != null) {
                    for (ProblemDescriptor descriptor : descriptors) {
                        holder.registerProblem(descriptor);
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/highlighting/BaseBeanValidationInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @NotNull
    public String getShortName() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/beanValidation/highlighting/BaseBeanValidationInspection", "getShortName"));
        }
        return string;
    }
}

