/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.reference.property;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts.core.PsiBeanProperty;
import com.intellij.struts.core.PsiBeanPropertyCache;
import com.intellij.struts.inplace.reference.BaseReferenceProvider;
import com.intellij.struts.inplace.reference.property.FormPropertyReferenceProvider;
import com.intellij.struts.inplace.reference.property.PropertyReference;
import com.intellij.struts.inplace.reference.property.PropertyReferenceSet;
import com.intellij.struts.inplace.reference.property.ValidatorFormPropertyReference;
import org.jetbrains.annotations.NotNull;

public class ValidatorFormPropertyReferenceProvider
extends FormPropertyReferenceProvider {
    @Override
    protected PropertyReference createReference(PropertyReferenceSet set, int index, TextRange range) {
        return new ValidatorFormPropertyReference(set, index, range, (BaseReferenceProvider)this){

            @Override
            @NotNull
            protected PsiBeanProperty[] getPropertiesForTag(boolean forVariants) {
                XmlAttribute attribute;
                this.setSoft(false);
                PsiElement tag = this.myValue.getParent().getParent();
                if (tag instanceof XmlTag && (attribute = ((XmlTag)tag).getAttribute("indexedListProperty", null)) != null) {
                    PsiReference reference;
                    XmlAttributeValue xmlAttributeValue = attribute.getValueElement();
                    if (xmlAttributeValue != null && (reference = xmlAttributeValue.getReference()) instanceof PropertyReference) {
                        ResolveResult[] resolveResults;
                        for (ResolveResult result : resolveResults = ((PropertyReference)reference).multiResolve(false)) {
                            PsiElement element = result.getElement();
                            if (element instanceof PsiMethod) {
                                PsiType componentType;
                                PsiType returnType = ((PsiMethod)element).getReturnType();
                                PsiClass beanClass = null;
                                if (returnType instanceof PsiClassType) {
                                    PsiType[] psiTypes = ((PsiClassType)returnType).getParameters();
                                    if (psiTypes.length == 1 && psiTypes[0] instanceof PsiClassType) {
                                        beanClass = ((PsiClassType)psiTypes[0]).resolve();
                                    }
                                } else if (returnType instanceof PsiArrayType && (componentType = ((PsiArrayType)returnType).getComponentType()) instanceof PsiClassType) {
                                    beanClass = ((PsiClassType)componentType).resolve();
                                }
                                if (beanClass != null) {
                                    PsiBeanProperty[] psiBeanPropertyArray = PsiBeanPropertyCache.getInstance(beanClass.getProject()).getBeanProperties(beanClass);
                                    if (psiBeanPropertyArray == null) {
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/property/ValidatorFormPropertyReferenceProvider$1", "getPropertiesForTag"));
                                    }
                                    return psiBeanPropertyArray;
                                }
                            }
                            this.setSoft(true);
                        }
                    }
                    if (PsiBeanProperty.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/property/ValidatorFormPropertyReferenceProvider$1", "getPropertiesForTag"));
                    }
                    return PsiBeanProperty.EMPTY_ARRAY;
                }
                PsiBeanProperty[] psiBeanPropertyArray = super.getPropertiesForTag(forVariants);
                if (psiBeanPropertyArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/property/ValidatorFormPropertyReferenceProvider$1", "getPropertiesForTag"));
                }
                return psiBeanPropertyArray;
            }
        };
    }
}

