/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.reference.config;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.ValidationModel;
import com.intellij.struts.dom.validator.Validator;
import com.intellij.struts.inplace.reference.ListAttrReferenceProvider;
import com.intellij.struts.inplace.reference.XmlValueReference;
import com.intellij.util.xml.ElementPresentationManager;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValidatorReferenceProvider
extends ListAttrReferenceProvider {
    @NonNls
    public static final String CANONICAL = "validator";

    public ValidatorReferenceProvider() {
        super(CANONICAL, null, false);
    }

    @Override
    @NotNull
    protected XmlValueReference create(final XmlAttributeValue attribute, TextRange range) {
        XmlValueReference xmlValueReference = new XmlValueReference(attribute, this, range){

            @Nullable
            protected XmlTag doResolve() {
                ValidationModel model = StrutsManager.getInstance().getValidation((PsiElement)attribute);
                if (model == null) {
                    return null;
                }
                String name = this.getValue();
                Validator validator = model.findValidator(name);
                return validator == null ? null : validator.getXmlTag();
            }

            @Override
            @Nullable
            protected Object[] doGetVariants() {
                ValidationModel model = StrutsManager.getInstance().getValidation((PsiElement)attribute);
                if (model == null) {
                    return null;
                }
                List validators = model.getValidators();
                return ElementPresentationManager.getInstance().createVariants((Collection)validators);
            }
        };
        if (xmlValueReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/config/ValidatorReferenceProvider", "create"));
        }
        return xmlValueReference;
    }
}

