/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.reference.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.ValidationModel;
import com.intellij.struts.dom.Action;
import com.intellij.struts.dom.FormBean;
import com.intellij.struts.inplace.reference.XmlAttributeReferenceProvider;
import com.intellij.struts.inplace.reference.XmlValueReference;
import java.util.ArrayList;
import java.util.HashSet;

public class ValidatorFormReferenceProvider
extends XmlAttributeReferenceProvider {
    public ValidatorFormReferenceProvider() {
        super("symbol");
    }

    @Override
    protected PsiReference[] create(XmlAttributeValue attribute) {
        return new PsiReference[]{new XmlValueReference(attribute, this){

            public XmlTag doResolve() {
                ValidationModel validation = StrutsManager.getInstance().getValidation((PsiElement)this.myValue);
                if (validation == null) {
                    return null;
                }
                StrutsModel model = validation.getStrutsModel();
                String value = this.getValue();
                if (StringUtil.startsWithChar((CharSequence)value, (char)'/')) {
                    Action action = model.findAction(value);
                    return action == null ? null : action.getXmlTag();
                }
                FormBean bean = model.findFormBean(value);
                if (bean == null) {
                    Action action = model.findAction("/" + value);
                    return action == null ? null : action.getXmlTag();
                }
                return bean.getXmlTag();
            }

            @Override
            public Object[] doGetVariants() {
                ValidationModel validation = StrutsManager.getInstance().getValidation((PsiElement)this.myValue);
                if (validation == null) {
                    return null;
                }
                StrutsModel model = validation.getStrutsModel();
                PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
                GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.getProject());
                PsiClass validatorActionForm = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass("org.apache.struts.validator.ValidatorActionForm", scope);
                PsiClass beanValidatorForm = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass("org.apache.struts.validator.BeanValidatorForm", scope);
                HashSet<FormBean> pathValidated = new HashSet<FormBean>();
                ArrayList<Object> list = new ArrayList<Object>();
                for (FormBean form : model.getFormBeans()) {
                    PsiClass psiClass = (PsiClass)form.getType().getValue();
                    if (psiClass == null) continue;
                    if (InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)validatorActionForm, (boolean)true)) {
                        pathValidated.add(form);
                        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)beanValidatorForm, (boolean)true)) continue;
                        list.add(form);
                        continue;
                    }
                    list.add(form);
                }
                for (Action action : model.getActions()) {
                    FormBean bean = (FormBean)action.getName().getValue();
                    if (bean == null || !pathValidated.contains(bean)) continue;
                    list.add(action);
                }
                return 1.getItems(list);
            }
        }};
    }
}

