/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.reference.config;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.WebPathReferenceProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts.inplace.InplaceUtil;
import com.intellij.struts.inplace.reference.config.TilesReferenceProvider;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class TilesValueReferenceProvider
extends WebPathReferenceProvider {
    private final TilesReferenceProvider tilesProvider = new TilesReferenceProvider(false);
    private final TilesReferenceProvider tilesProviderSoft = new TilesReferenceProvider(true);

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts/inplace/reference/config/TilesValueReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/struts/inplace/reference/config/TilesValueReferenceProvider", "getReferencesByElement"));
        }
        if (element instanceof XmlAttributeValue) {
            XmlAttributeValue value = (XmlAttributeValue)element;
            if (!InplaceUtil.isSimpleText((PsiElement)value)) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/config/TilesValueReferenceProvider", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            XmlTag tag = (XmlTag)value.getContext().getContext();
            String type = tag.getAttributeValue("type");
            if ("string".equals(type)) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/config/TilesValueReferenceProvider", "getReferencesByElement"));
                }
                return PsiReference.EMPTY_ARRAY;
            }
            if ("definition".equals(type)) {
                PsiReference[] psiReferenceArray = this.tilesProvider.getReferencesByElement(element);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/config/TilesValueReferenceProvider", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
            if ("page".equals(type) || "template".equals(type) || type == null && StringUtil.startsWithChar((CharSequence)tag.getAttributeValue("value"), (char)'/')) {
                String text = tag.getAttributeValue("value");
                if (InplaceUtil.containsPlaceholderReference(text)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/config/TilesValueReferenceProvider", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                this.setSoft(false);
            } else {
                PsiReference[] psiReferenceArray = this.tilesProviderSoft.getReferencesByElement(element);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/config/TilesValueReferenceProvider", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }
        PsiReference[] psiReferenceArray = super.getReferencesByElement(element);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/config/TilesValueReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

