/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.reference.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.struts.StrutsBundle;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.inplace.reference.XmlAttributeReferenceProvider;
import com.intellij.struts.inplace.reference.XmlValueReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ModuleReferenceProvider
extends XmlAttributeReferenceProvider {
    private static final String CANONICAL = StrutsBundle.message((String)"canonical.names.module", (Object[])new Object[0]);

    public ModuleReferenceProvider() {
        super(CANONICAL);
    }

    @Override
    protected PsiReference[] create(XmlAttributeValue attribute) {
        XmlValueReference reference = new XmlValueReference(attribute, this){

            @Override
            @Nullable
            protected PsiElement doResolve() {
                StrutsModel model;
                String prefix = this.getValue();
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myValue);
                if (module != null && (model = StrutsManager.getInstance().getModelByPrefix(module, prefix)) != null) {
                    return model.getConfigurationTag();
                }
                return null;
            }

            @Override
            @Nullable
            protected Object[] doGetVariants() {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myValue);
                if (module != null) {
                    List models = StrutsManager.getInstance().getAllStrutsModels(module);
                    ArrayList<String> list = new ArrayList<String>();
                    for (StrutsModel model : models) {
                        String prefix = model.getModulePrefix();
                        list.add(prefix);
                    }
                    return list.toArray();
                }
                return null;
            }
        };
        return new PsiReference[]{reference};
    }
}

