/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.reference.config;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.dom.Forward;
import com.intellij.struts.dom.StrutsConfig;
import com.intellij.struts.inplace.reference.XmlAttributeReferenceProvider;
import com.intellij.struts.inplace.reference.XmlValueReference;
import com.intellij.util.xml.DomElement;
import org.jetbrains.annotations.Nullable;

public class ForwardReferenceProvider
extends XmlAttributeReferenceProvider {
    public ForwardReferenceProvider(boolean soft) {
        super(Forward.class);
        this.setSoft(soft);
    }

    @Override
    protected PsiReference[] create(XmlAttributeValue attribute) {
        XmlValueReference psiReference = new XmlValueReference(attribute, this){

            @Override
            public PsiElement doResolve() {
                StrutsModel model = StrutsManager.getInstance().getStrutsModel((PsiElement)this.myValue);
                if (model == null) {
                    return null;
                }
                String forwardName = this.myValue.getValue();
                Forward forward = model.findForward(forwardName);
                if (forward != null) {
                    return forward.getName().getXmlTag();
                }
                return null;
            }

            @Override
            @Nullable
            protected DomElement getScope() {
                StrutsModel model = StrutsManager.getInstance().getStrutsModel((PsiElement)this.myValue);
                if (model == null) {
                    return null;
                }
                return ((StrutsConfig)model.getMergedModel()).getGlobalForwards();
            }

            @Override
            public Object[] doGetVariants() {
                StrutsModel model = StrutsManager.getInstance().getStrutsModel((PsiElement)this.myValue);
                if (model == null) {
                    return null;
                }
                return 1.getItems(model.getGlobalForwards());
            }
        };
        return new PsiReference[]{psiReference};
    }
}

