/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.reference;

import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.struts.inplace.reference.BaseReferenceProvider;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PathReferenceAdapter
extends BaseReferenceProvider {
    private final PathReferenceProvider myConverter;
    private final boolean mySoft;

    public PathReferenceAdapter(PathReferenceProvider provider, boolean soft) {
        this.myConverter = provider;
        this.mySoft = soft;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts/inplace/reference/PathReferenceAdapter", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/struts/inplace/reference/PathReferenceAdapter", "getReferencesByElement"));
        }
        ArrayList list = new ArrayList();
        this.myConverter.createReferences(element, list, this.mySoft);
        PsiReference[] psiReferenceArray = list.toArray(new PsiReference[list.size()]);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/PathReferenceAdapter", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

