/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.facet.ui;

import com.intellij.facet.Facet;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.libraries.FacetLibrariesValidator;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.struts.facet.AddStrutsSupportUtil;
import com.intellij.struts.facet.StrutsFacet;
import com.intellij.struts.facet.StrutsSupportModel;
import com.intellij.struts.facet.ui.BooleanConfigurableElement;
import com.intellij.struts.facet.ui.StrutsVersion;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class StrutsFeaturesEditor
extends FacetEditorTab {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.struts.facet.ui.StrutsFeaturesEditor");
    private JPanel myMainPanel;
    private JPanel myDescriptionPanel;
    private JCheckBox myTilesCheckBox;
    private JCheckBox myValidatorCheckBox;
    private JCheckBox myStrutsELCheckBox;
    private JComboBox myVersionComboBox;
    private JCheckBox myStrutsTaglibCheckBox;
    private JCheckBox myScriptingCheckBox;
    private JCheckBox myExtrasCheckBox;
    private JCheckBox myStrutsFacesCheckBox;
    private final Ref<Boolean> myTilesSupport;
    private final Ref<Boolean> myValidatorSupport;
    private final Ref<Boolean> myStrutsTaglibSupport;
    private final Ref<Boolean> myStrutsELSupport;
    private final Ref<Boolean> myScriptingSupport;
    private final Ref<Boolean> myExtrasSupport;
    private final Ref<Boolean> myStrutsFacesSupport;
    private StrutsVersion myVersion;
    private final FacetEditorContext myEditorContext;
    private final FacetLibrariesValidator myLibrariesValidator;
    private final List<BooleanConfigurableElement> myConfigurables;
    private LibraryInfo[] myLastLibraryInfos;

    public StrutsFeaturesEditor(FacetEditorContext editorContext, FacetLibrariesValidator librariesValidator) {
        this.$$$setupUI$$$();
        this.myTilesSupport = Ref.create((Object)false);
        this.myValidatorSupport = Ref.create((Object)false);
        this.myStrutsTaglibSupport = Ref.create((Object)false);
        this.myStrutsELSupport = Ref.create((Object)false);
        this.myScriptingSupport = Ref.create((Object)false);
        this.myExtrasSupport = Ref.create((Object)false);
        this.myStrutsFacesSupport = Ref.create((Object)false);
        this.myConfigurables = new ArrayList<BooleanConfigurableElement>();
        this.myLastLibraryInfos = LibraryInfo.EMPTY_ARRAY;
        this.myEditorContext = editorContext;
        this.myLibrariesValidator = librariesValidator;
        this.initCheckboxes();
        Facet parentFacet = this.myEditorContext.getParentFacet();
        if (parentFacet != null) {
            this.init((WebFacet)parentFacet);
        }
        this.myVersionComboBox.setModel(new EnumComboBoxModel(StrutsVersion.class));
        this.myVersionComboBox.setEnabled(this.myVersion == null);
        if (this.myVersion == null) {
            this.myVersion = StrutsVersion.Struts1_3_8;
        }
        this.myVersionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StrutsFeaturesEditor.this.selectVersion(StrutsFeaturesEditor.this.getSelectedVersion());
            }
        });
        this.myStrutsTaglibCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StrutsFeaturesEditor.this.updateStrutsELCheckbox();
            }
        });
        this.myDescriptionPanel.setLayout(new BorderLayout());
        this.myDescriptionPanel.add((Component)StrutsFeaturesEditor.createDescriptionPanel(), "Center");
        this.addCheckboxesListeners();
    }

    private void updateStrutsELCheckbox() {
        if (!this.myStrutsTaglibCheckBox.isSelected()) {
            this.myStrutsELCheckBox.setSelected(false);
        }
        this.myStrutsELCheckBox.setEnabled(this.myStrutsTaglibCheckBox.isSelected());
    }

    private StrutsVersion getSelectedVersion() {
        return (StrutsVersion)((Object)this.myVersionComboBox.getModel().getSelectedItem());
    }

    private void initCheckboxes() {
        this.myConfigurables.add(new BooleanConfigurableElement(this.myTilesCheckBox, this.myTilesSupport));
        this.myConfigurables.add(new BooleanConfigurableElement(this.myExtrasCheckBox, this.myExtrasSupport));
        this.myConfigurables.add(new BooleanConfigurableElement(this.myScriptingCheckBox, this.myScriptingSupport));
        this.myConfigurables.add(new BooleanConfigurableElement(this.myStrutsELCheckBox, this.myStrutsELSupport));
        this.myConfigurables.add(new BooleanConfigurableElement(this.myStrutsFacesCheckBox, this.myStrutsFacesSupport));
        this.myConfigurables.add(new BooleanConfigurableElement(this.myStrutsTaglibCheckBox, this.myStrutsTaglibSupport));
        this.myConfigurables.add(new BooleanConfigurableElement(this.myValidatorCheckBox, this.myValidatorSupport));
    }

    private void addCheckboxesListeners() {
        for (BooleanConfigurableElement configurable : this.myConfigurables) {
            configurable.getCheckBox().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StrutsFeaturesEditor.this.updateRequiredLibraries();
                }
            });
        }
    }

    private void updateRequiredLibraries() {
        Object[] libraries = this.getRequiredLibraries();
        if (!Arrays.equals(libraries, this.myLastLibraryInfos)) {
            this.myLibrariesValidator.setRequiredLibraries((LibraryInfo[])libraries);
            this.myLastLibraryInfos = libraries;
        }
    }

    private void selectVersion(StrutsVersion strutsVersion) {
        switch (strutsVersion) {
            case Struts1_2_9: {
                this.myStrutsTaglibCheckBox.setEnabled(false);
                this.myStrutsTaglibCheckBox.setSelected(true);
                this.myStrutsFacesCheckBox.setEnabled(false);
                this.myStrutsFacesCheckBox.setSelected(false);
                this.myScriptingCheckBox.setEnabled(false);
                this.myScriptingCheckBox.setSelected(false);
                this.myExtrasCheckBox.setEnabled(false);
                this.myExtrasCheckBox.setSelected(false);
                break;
            }
            case Struts1_3_8: {
                this.myExtrasCheckBox.setEnabled((Boolean)this.myExtrasSupport.get() == false);
                this.myExtrasCheckBox.setSelected((Boolean)this.myExtrasSupport.get());
                this.myScriptingCheckBox.setEnabled((Boolean)this.myScriptingSupport.get() == false);
                this.myScriptingCheckBox.setSelected((Boolean)this.myScriptingSupport.get());
                this.myStrutsFacesCheckBox.setEnabled((Boolean)this.myStrutsFacesSupport.get() == false);
                this.myStrutsFacesCheckBox.setSelected((Boolean)this.myStrutsFacesSupport.get());
                this.myStrutsTaglibCheckBox.setEnabled((Boolean)this.myStrutsTaglibSupport.get() == false || this.myEditorContext.isNewFacet());
                this.myStrutsTaglibCheckBox.setSelected((Boolean)this.myStrutsTaglibSupport.get() != false || this.myEditorContext.isNewFacet());
            }
        }
    }

    public void reset() {
        for (BooleanConfigurableElement configurable : this.myConfigurables) {
            configurable.reset();
        }
        this.myStrutsTaglibCheckBox.setSelected((Boolean)this.myStrutsTaglibSupport.get() != false || this.myEditorContext.isNewFacet());
        this.updateStrutsELCheckbox();
        this.myVersionComboBox.setSelectedItem((Object)this.myVersion);
        this.updateRequiredLibraries();
    }

    public boolean isModified() {
        for (BooleanConfigurableElement configurable : this.myConfigurables) {
            if (!configurable.isModified()) continue;
            return true;
        }
        return this.myVersionComboBox.getSelectedItem() != this.myVersion || this.myLibrariesValidator.isLibrariesAdded();
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/facet/ui/StrutsFeaturesEditor", "createComponent"));
        }
        return jPanel;
    }

    public void disposeUIResources() {
    }

    @Nls
    public String getDisplayName() {
        return "Struts Features";
    }

    public void apply() {
        for (BooleanConfigurableElement configurable : this.myConfigurables) {
            configurable.apply();
        }
        this.myVersion = this.getSelectedVersion();
    }

    public void onFacetInitialized(@NotNull Facet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/struts/facet/ui/StrutsFeaturesEditor", "onFacetInitialized"));
        }
        this.myLibrariesValidator.onFacetInitialized(facet);
        StrutsFacet strutsFacet = (StrutsFacet)facet;
        WebFacet webFacet = strutsFacet.getWebFacet();
        assert (webFacet != null);
        AddStrutsSupportUtil.addSupportInWriteCommandAction(webFacet, (Boolean)this.myValidatorSupport.get(), (Boolean)this.myTilesSupport.get(), this.myVersion);
    }

    @NotNull
    private LibraryInfo[] getRequiredLibraries() {
        Object[] libs = this.myVersion.getJars();
        if (this.myStrutsTaglibCheckBox.isSelected() && this.myVersion.getStrutsTaglib() != null) {
            libs = (LibraryInfo[])ArrayUtil.append((Object[])libs, (Object)this.myVersion.getStrutsTaglib());
        }
        if ((this.myTilesCheckBox.isSelected() || this.myStrutsFacesCheckBox.isSelected()) && this.myVersion.getTiles() != null) {
            libs = (LibraryInfo[])ArrayUtil.append((Object[])libs, (Object)this.myVersion.getTiles());
        }
        if (this.myStrutsFacesCheckBox.isSelected()) {
            libs = (LibraryInfo[])ArrayUtil.append((Object[])libs, (Object)this.myVersion.getStrutsFaces());
        }
        if (this.myScriptingCheckBox.isSelected()) {
            libs = (LibraryInfo[])ArrayUtil.mergeArrays((Object[])libs, (Object[])this.myVersion.getScripting());
        }
        if (this.myExtrasCheckBox.isSelected()) {
            libs = (LibraryInfo[])ArrayUtil.append((Object[])libs, (Object)this.myVersion.getExtras());
        }
        if (this.myStrutsELCheckBox.isSelected()) {
            libs = (LibraryInfo[])ArrayUtil.mergeArrays((Object[])libs, (Object[])this.myVersion.getStrutsEl());
        }
        if (libs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/facet/ui/StrutsFeaturesEditor", "getRequiredLibraries"));
        }
        return libs;
    }

    private void init(@NotNull WebFacet webFacet) {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/struts/facet/ui/StrutsFeaturesEditor", "init"));
        }
        DumbService.getInstance((Project)webFacet.getModule().getProject()).runWhenSmart(() -> {
            if (webFacet == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/struts/facet/ui/StrutsFeaturesEditor", "lambda$init$0"));
            }
            StrutsSupportModel model = StrutsSupportModel.checkStrutsSupport(webFacet);
            if (model.isStrutsLib()) {
                this.myVersion = model.isStruts13() ? StrutsVersion.Struts1_3_8 : StrutsVersion.Struts1_2_9;
            }
            this.myTilesSupport.set((Object)model.isTiles());
            this.myValidatorSupport.set((Object)model.isValidation());
            this.myStrutsELSupport.set((Object)model.isStrutsEl());
            this.myStrutsTaglibSupport.set((Object)model.isStrutsTaglib());
            this.myStrutsFacesSupport.set((Object)model.isStrutsFaces());
            this.myScriptingSupport.set((Object)model.isScripting());
            this.myExtrasSupport.set((Object)model.isExtras());
        });
    }

    public static JPanel createDescriptionPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("Struts is a Java web-application development framework."), "North");
        HyperlinkLabel hyperlinkLabel = new HyperlinkLabel("More about Struts");
        hyperlinkLabel.setHyperlinkTarget("http://struts.apache.org/");
        panel.add((Component)hyperlinkLabel, "South");
        return panel;
    }

    public String getHelpTopic() {
        return "reference.settings.project.modules.struts.facet.tab.features";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, 15, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myDescriptionPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, 5, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myValidatorCheckBox = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("Validator");
        jCheckBox7.setMnemonic('V');
        jCheckBox7.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jCheckBox7, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Select Struts features which support you want to add to this module:");
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myStrutsELCheckBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Struts-EL taglib");
        jCheckBox6.setMnemonic('E');
        jCheckBox6.setDisplayedMnemonicIndex(7);
        jPanel3.add((Component)jCheckBox6, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myStrutsTaglibCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Struts taglib");
        jPanel3.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myExtrasCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Extras");
        jPanel3.add((Component)jCheckBox4, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myScriptingCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Scripting");
        jPanel3.add((Component)jCheckBox3, new GridConstraints(2, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTilesCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Tiles");
        jCheckBox2.setMnemonic('T');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jCheckBox2, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myStrutsFacesCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Struts-Faces");
        jPanel3.add((Component)jCheckBox, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(1, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Select Struts version:");
        jPanel4.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVersionComboBox = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(100, -1), null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel2.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

